/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.conjurer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.DrownedConjurerEntity;
import net.j677.adventuresmod.entity.custom.NecromancerSpellEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class CastSpellTask
extends class_4097<DrownedConjurerEntity> {
    private static final int RECOVER_EXPIRY = Math.round(9.0f);
    private static final int SHOOT_CHARGING_EXPIRY = Math.round(10.0f);
    private static final int SHOOT_COOLDOWN_EXPIRY = Math.round(7.0f);

    @VisibleForTesting
    public CastSpellTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.SHOOT_SPELL_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.SHOOT_SPELL_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.SHOOT_SPELL_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.SHOOT_SPELL, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.HEAVY_ATTACK, (Object)class_4141.field_18457), SHOOT_CHARGING_EXPIRY + 1 + RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
        return conjurerEntity.getState() == DrownedConjurerEntity.State.STANDING && conjurerEntity.method_18868().method_18904(class_4140.field_22355).map(target -> CastSpellTask.isTargetWithinRange(conjurerEntity, target)).map(withinRange -> {
            if (!withinRange.booleanValue()) {
                conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.SHOOT_SPELL);
            }
            return withinRange;
        }).orElse(false) != false;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        return conjurerEntity.method_18868().method_18896(class_4140.field_22355) && conjurerEntity.method_18868().method_18896(AdventureMemoryModuleTypes.SHOOT_SPELL);
    }

    protected void run(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        conjurerEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> conjurerEntity.setState(DrownedConjurerEntity.State.CASTING));
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.SHOOT_SPELL_CHARGING, (Object)class_3902.field_17274, (long)SHOOT_CHARGING_EXPIRY);
    }

    protected void keepRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        class_4095<DrownedConjurerEntity> brain = conjurerEntity.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null) {
            conjurerEntity.method_5702(class_2183.class_2184.field_9851, livingEntity.method_19538());
            if (brain.method_18904(AdventureMemoryModuleTypes.SHOOT_SPELL_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.SHOOT_SPELL_RECOVER).isEmpty()) {
                brain.method_24525(AdventureMemoryModuleTypes.SHOOT_SPELL_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
                if (CastSpellTask.isFacingTarget(conjurerEntity, livingEntity)) {
                    float yaw = (float)class_3532.method_15349((double)(livingEntity.method_23321() - conjurerEntity.method_23321()), (double)(livingEntity.method_23317() - conjurerEntity.method_23317()));
                    double d = livingEntity.method_23317() - conjurerEntity.method_23317();
                    double e = livingEntity.method_23323(livingEntity.method_5765() ? 0.8 : 0.3) - conjurerEntity.method_23323(0.5);
                    double f = livingEntity.method_23321() - conjurerEntity.method_23321();
                    NecromancerSpellEntity necromancerSpellEntity = new NecromancerSpellEntity((class_1937)serverWorld, conjurerEntity, conjurerEntity.method_23317(), conjurerEntity.method_5829().method_1005().method_10214(), conjurerEntity.method_23321(), yaw);
                    conjurerEntity.method_5783(class_3417.field_47195, 1.5f, 1.0f);
                    necromancerSpellEntity.method_7485(d, e, f, 0.7f, 5 - serverWorld.method_8407().method_5461() * 4);
                    serverWorld.method_8649((class_1297)necromancerSpellEntity);
                }
            }
        }
    }

    protected void finishRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        if (conjurerEntity.getState() == DrownedConjurerEntity.State.CASTING) {
            conjurerEntity.setState(DrownedConjurerEntity.State.STANDING);
        }
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.SHOOT_SPELL_COOLDOWN, (Object)class_3902.field_17274, (long)SHOOT_COOLDOWN_EXPIRY);
        conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.SHOOT_SPELL);
        if (conjurerEntity.method_18868().method_18896(class_4140.field_22355)) {
            conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.PREFORM_CONJURING, (Object)class_3902.field_17274, 60L);
        }
    }

    @VisibleForTesting
    public static boolean isFacingTarget(DrownedConjurerEntity conjurerEntity, class_1309 target) {
        class_243 vec3d2;
        class_243 vec3d = conjurerEntity.method_5828(1.0f);
        return vec3d.method_1026(vec3d2 = target.method_19538().method_1020(conjurerEntity.method_19538()).method_1029()) > 0.5;
    }

    private static boolean isTargetWithinRange(DrownedConjurerEntity conjurerEntity, class_1309 target) {
        double d = conjurerEntity.method_19538().method_1025(target.method_19538());
        return d > 4.0 && d < 256.0;
    }
}

