/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.conjurer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.DrownedConjurerEntity;
import net.j677.adventuresmod.entity.custom.DrownedVanguardEntity;
import net.j677.adventuresmod.entity.custom.NecromancerSpellEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4051;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class ConjureBarrageTask
extends class_4097<DrownedConjurerEntity> {
    private static final int RECOVER_EXPIRY = Math.round(250.0f);
    private static final int CHARGING_EXPIRY = Math.round(15.0f);
    private final class_4051 closeVanguardPredicate = class_4051.method_36626().method_18418(24.0).method_18424().method_36627();

    public ConjureBarrageTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.SPECIAL_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.PREFORM_CONJURING, (Object)class_4141.field_18456), CHARGING_EXPIRY + 1 + RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
        int i = conjurerEntity.method_37908().method_18466(DrownedVanguardEntity.class, this.closeVanguardPredicate, (class_1309)conjurerEntity, conjurerEntity.method_5829().method_1014(24.0)).size();
        return conjurerEntity.method_18868().method_18904(class_4140.field_22355).map(target -> ConjureBarrageTask.isTargetWithinRange(conjurerEntity, target)).map(withinRange -> {
            if (!withinRange.booleanValue()) {
                conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.PREFORM_CONJURING);
            }
            return withinRange;
        }).orElse(false) != false && 1 > i && conjurerEntity.method_6032() <= conjurerEntity.method_6063() - 30.0f;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        return true;
    }

    protected void run(class_3218 world, DrownedConjurerEntity conjurerEntity, long time) {
        this.spawnTeleportParticles(world, conjurerEntity);
        conjurerEntity.method_18868().method_18904(AdventureMemoryModuleTypes.ARENA_CENTER).flatMap(teleportTarget -> ConjureBarrageTask.getTeleportPos(teleportTarget.comp_2208())).ifPresent(teleportPos -> conjurerEntity.method_6082(teleportPos.method_10263(), teleportPos.method_10264(), teleportPos.method_10260(), false));
        this.spawnTeleportParticles(world, conjurerEntity);
        conjurerEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> conjurerEntity.setState(DrownedConjurerEntity.State.CONJURE_BARRAGE));
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.CONJURING_CHARGING, (Object)class_3902.field_17274, (long)CHARGING_EXPIRY);
        conjurerEntity.method_5783(class_3417.field_15193, 3.0f, 1.0f);
    }

    protected void keepRunning(class_3218 world, DrownedConjurerEntity conjurerEntity, long time) {
        class_4095<DrownedConjurerEntity> brain = conjurerEntity.method_18868();
        if (brain.method_18904(AdventureMemoryModuleTypes.CONJURING_CHARGING).isEmpty() && conjurerEntity.field_6012 % 3 == 0) {
            for (int i = 0; i < 8; ++i) {
                double x = 3.0f * class_3532.method_15362((float)((float)Math.PI * (float)i / 4.0f + (float)(3 * conjurerEntity.field_6012)));
                double z = 3.0f * class_3532.method_15374((float)((float)Math.PI * (float)i / 4.0f + (float)(3 * conjurerEntity.field_6012)));
                NecromancerSpellEntity necromancerSpellEntity = new NecromancerSpellEntity((class_1937)world, conjurerEntity, 45 * i);
                conjurerEntity.method_5783(class_3417.field_14970, 0.3f, 1.0f);
                necromancerSpellEntity.method_7485(x, 0.0, z, 0.2f, 5 - world.method_8407().method_5461() * 4);
                world.method_8649((class_1297)necromancerSpellEntity);
            }
        }
    }

    private static Optional<class_2338> getTeleportPos(class_2338 pos) {
        if (pos != null) {
            return Optional.of(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        }
        return Optional.empty();
    }

    private void spawnTeleportParticles(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
        for (int j = 0; j < 128; ++j) {
            double d = (double)j / 127.0;
            float f = (conjurerEntity.random.method_43057() - 0.5f) * 0.2f;
            float g = (conjurerEntity.random.method_43057() - 0.5f) * 0.2f;
            float h = (conjurerEntity.random.method_43057() - 0.5f) * 0.2f;
            double e = class_3532.method_16436((double)d, (double)conjurerEntity.field_6014, (double)conjurerEntity.method_23317()) + (conjurerEntity.random.method_43058() - 0.5) * (double)conjurerEntity.method_17681() * 2.0;
            double k = class_3532.method_16436((double)d, (double)conjurerEntity.field_6036, (double)conjurerEntity.method_23318()) + conjurerEntity.random.method_43058() * (double)conjurerEntity.method_17682();
            double l = class_3532.method_16436((double)d, (double)conjurerEntity.field_5969, (double)conjurerEntity.method_23321()) + (conjurerEntity.random.method_43058() - 0.5) * (double)conjurerEntity.method_17681() * 2.0;
            serverWorld.method_14199((class_2394)class_2398.field_11237, e, k, l, 1, (double)f, (double)g, (double)h, 0.0);
        }
    }

    private static boolean isTargetWithinRange(DrownedConjurerEntity conjurerEntity, class_1309 target) {
        double d = conjurerEntity.method_19538().method_1025(target.method_19538());
        return d < 256.0;
    }

    protected void finishRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        if (conjurerEntity.getState() == DrownedConjurerEntity.State.CONJURE_BARRAGE) {
            conjurerEntity.setState(DrownedConjurerEntity.State.STANDING);
        }
        conjurerEntity.startState(DrownedConjurerEntity.State.STUNNED);
        conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.PREFORM_CONJURING);
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.SPECIAL_COOLDOWN, (Object)class_3902.field_17274, 600L);
    }
}

