/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.conjurer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.DrownedConjurerEntity;
import net.j677.adventuresmod.entity.custom.DrownedVanguardEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4051;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class ConjureDrownedTask
extends class_4097<DrownedConjurerEntity> {
    private static final int RECOVER_EXPIRY = Math.round(22.0f);
    private static final int SUMMONING_CHARGING_EXPIRY = Math.round(15.0f);
    private static final int SUMMONING_COOLDOWN_EXPIRY = Math.round(50.0f);
    private final class_4051 closeVanguardPredicate = class_4051.method_36626().method_18418(24.0).method_18424().method_36627();

    public ConjureDrownedTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.CONJURING_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.PREFORM_CONJURING, (Object)class_4141.field_18456), SUMMONING_CHARGING_EXPIRY + 1 + RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
        class_1309 livingEntity = ConjureDrownedTask.getAttackTarget((class_1309)conjurerEntity);
        int i = conjurerEntity.method_37908().method_18466(DrownedVanguardEntity.class, this.closeVanguardPredicate, (class_1309)conjurerEntity, conjurerEntity.method_5829().method_1014(24.0)).size();
        return conjurerEntity.getState() == DrownedConjurerEntity.State.STANDING && class_4215.method_24565((class_1309)conjurerEntity, (class_1309)livingEntity) && 1 > i;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        return conjurerEntity.method_18868().method_18896(class_4140.field_22355) && conjurerEntity.method_18868().method_18896(AdventureMemoryModuleTypes.PREFORM_CONJURING);
    }

    protected void run(class_3218 world, DrownedConjurerEntity conjurerEntity, long time) {
        conjurerEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> conjurerEntity.setState(DrownedConjurerEntity.State.CONJURE_DROWNED));
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.CONJURING_CHARGING, (Object)class_3902.field_17274, (long)SUMMONING_CHARGING_EXPIRY);
        conjurerEntity.method_5783(class_3417.field_15193, 3.0f, 1.0f);
    }

    protected void keepRunning(class_3218 world, DrownedConjurerEntity conjurerEntity, long time) {
        block5: {
            class_4095<DrownedConjurerEntity> brain = conjurerEntity.method_18868();
            class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
            if (livingEntity == null) break block5;
            conjurerEntity.method_5702(class_2183.class_2184.field_9851, livingEntity.method_19538());
            if (brain.method_18904(AdventureMemoryModuleTypes.CONJURING_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.CONJURING_RECOVER).isEmpty()) {
                brain.method_24525(AdventureMemoryModuleTypes.CONJURING_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
                if (conjurerEntity.method_6032() <= conjurerEntity.method_6063() / 2.0f) {
                    for (int i = 0; i < 5; ++i) {
                        class_2338 blockPos = conjurerEntity.method_24515().method_10069(-3 + conjurerEntity.random.method_43048(5), 0, -3 + conjurerEntity.random.method_43048(5));
                        this.conjureDrowned(world, conjurerEntity, blockPos.method_10263(), blockPos.method_10260(), conjurerEntity.method_23318(), conjurerEntity.method_23318() + 1.0, conjurerEntity.method_36454());
                    }
                } else {
                    for (int i = 0; i < 3; ++i) {
                        class_2338 blockPos = conjurerEntity.method_24515().method_10069(-3 + conjurerEntity.random.method_43048(5), 0, -3 + conjurerEntity.random.method_43048(5));
                        this.conjureDrowned(world, conjurerEntity, blockPos.method_10263(), blockPos.method_10260(), conjurerEntity.method_23318(), conjurerEntity.method_23318() + 1.0, conjurerEntity.method_36454());
                    }
                }
            }
        }
    }

    protected void finishRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        if (conjurerEntity.getState() == DrownedConjurerEntity.State.CONJURE_DROWNED) {
            conjurerEntity.setState(DrownedConjurerEntity.State.STANDING);
        }
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.CONJURING_COOLDOWN, (Object)class_3902.field_17274, (long)SUMMONING_COOLDOWN_EXPIRY * 2L);
        conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.PREFORM_CONJURING);
    }

    private static class_1309 getAttackTarget(class_1309 entity) {
        return (class_1309)entity.method_18868().method_18904(class_4140.field_22355).get();
    }

    private void conjureDrowned(class_3218 world, DrownedConjurerEntity conjurerEntity, double x, double z, double maxY, double y, float yaw) {
        DrownedVanguardEntity vanguardEntity;
        class_268 team = conjurerEntity.method_5781();
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        boolean bl = false;
        double d = 0.0;
        do {
            class_2680 blockState2;
            class_265 voxelShape;
            class_2338 blockPos2 = blockPos.method_10074();
            class_2680 blockState = conjurerEntity.method_37908().method_8320(blockPos2);
            if (!blockState.method_26206((class_1922)conjurerEntity.method_37908(), blockPos2, class_2350.field_11036)) continue;
            if (!conjurerEntity.method_37908().method_22347(blockPos) && !(voxelShape = (blockState2 = conjurerEntity.method_37908().method_8320(blockPos)).method_26220((class_1922)conjurerEntity.method_37908(), blockPos)).method_1110()) {
                d = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)maxY) - 1);
        if (bl && (vanguardEntity = (DrownedVanguardEntity)AdventureEntityTypes.DROWNED_VANGUARD.method_5883(conjurerEntity.method_37908())) != null) {
            vanguardEntity.setSummoned(true);
            vanguardEntity.method_5808(blockPos.method_10263(), blockPos.method_10264(), (double)blockPos.method_10260() + d, yaw, 0.0f);
            vanguardEntity.method_5943((class_5425)world, conjurerEntity.method_37908().method_8404(blockPos), class_3730.field_16471, null);
            if (team != null) {
                world.method_14170().method_1172(vanguardEntity.method_5820(), team);
            }
            world.method_30771((class_1297)vanguardEntity);
            world.method_32888((class_6880)class_5712.field_28738, new class_243(x, (double)blockPos.method_10264() + d, z), class_5712.class_7397.method_43285((class_1297)conjurerEntity));
            for (int i = 0; i < 20; ++i) {
                double e = (double)blockPos.method_10263() + 0.5 + (conjurerEntity.method_59922().method_43058() - 0.5) * 2.0;
                double f = (double)blockPos.method_10264() + 0.5 + (conjurerEntity.method_59922().method_43058() - 0.5) * 2.0;
                double g = (double)blockPos.method_10260() + 0.5 + (conjurerEntity.method_59922().method_43058() - 0.5) * 2.0;
                world.method_14199((class_2394)class_2398.field_11251, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
                world.method_14199((class_2394)class_2398.field_38002, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

