/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.conjurer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.ConjuredTridentEntity;
import net.j677.adventuresmod.entity.custom.DrownedConjurerEntity;
import net.j677.adventuresmod.particle.AdventureParticles;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class ConjureTridentsTask
extends class_4097<DrownedConjurerEntity> {
    private static final int RECOVER_EXPIRY = Math.round(10.0f);
    private static final int SUMMONING_CHARGING_EXPIRY = Math.round(10.0f);
    private static final int SUMMONING_COOLDOWN_EXPIRY = Math.round(50.0f);

    public ConjureTridentsTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.CONJURING_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.PREFORM_CONJURING, (Object)class_4141.field_18456), SUMMONING_CHARGING_EXPIRY + 1 + RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
        return conjurerEntity.getState() == DrownedConjurerEntity.State.STANDING && conjurerEntity.method_18868().method_18904(class_4140.field_22355).map(target -> ConjureTridentsTask.isTargetWithinRange(conjurerEntity, target)).map(withinRange -> {
            if (!withinRange.booleanValue()) {
                conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.PREFORM_CONJURING);
            }
            return withinRange;
        }).orElse(false) != false;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        return conjurerEntity.method_18868().method_18896(class_4140.field_22355) && conjurerEntity.method_18868().method_18896(AdventureMemoryModuleTypes.PREFORM_CONJURING);
    }

    protected void run(class_3218 world, DrownedConjurerEntity conjurerEntity, long time) {
        conjurerEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> conjurerEntity.setState(DrownedConjurerEntity.State.CONJURE_TRIDENTS));
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.CONJURING_CHARGING, (Object)class_3902.field_17274, (long)SUMMONING_CHARGING_EXPIRY);
        conjurerEntity.method_5783(class_3417.field_14908, 3.0f, 0.5f);
    }

    protected void keepRunning(class_3218 world, DrownedConjurerEntity conjurerEntity, long time) {
        class_4095<DrownedConjurerEntity> brain = conjurerEntity.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null) {
            conjurerEntity.method_5702(class_2183.class_2184.field_9851, livingEntity.method_19538());
            if (brain.method_18904(AdventureMemoryModuleTypes.CONJURING_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.CONJURING_RECOVER).isEmpty()) {
                brain.method_24525(AdventureMemoryModuleTypes.CONJURING_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
                double c = Math.min(livingEntity.method_23318(), conjurerEntity.method_23318()) + 0.01;
                double d = Math.max(livingEntity.method_23318(), conjurerEntity.method_23318()) + 1.0;
                double e = Math.max(livingEntity.method_23318(), conjurerEntity.method_23318()) + 5.0;
                float f = (float)class_3532.method_15349((double)(livingEntity.method_23321() - conjurerEntity.method_23321()), (double)(livingEntity.method_23317() - conjurerEntity.method_23317()));
                for (int i = 0; i < 5; ++i) {
                    float g = f + (float)i * (float)Math.PI * 2.0f / 5.0f + 1.2566371f;
                    class_2338 blockPos = class_2338.method_49637((double)(conjurerEntity.method_23317() + (double)class_3532.method_15362((float)g) * 3.5), (double)e, (double)(conjurerEntity.method_23321() + (double)class_3532.method_15374((float)g) * 3.5));
                    this.spawnSummonParticles(world, blockPos, conjurerEntity.method_59922());
                    this.spawnWarningParticles(world, conjurerEntity, blockPos.method_10263(), blockPos.method_10260(), d, c);
                    ConjuredTridentEntity conjuredTrident = (ConjuredTridentEntity)AdventureEntityTypes.CONJURED_TRIDENT.method_5883(conjurerEntity.method_37908());
                    if (conjuredTrident == null) continue;
                    conjuredTrident.method_7432((class_1297)conjurerEntity);
                    conjuredTrident.method_5725(blockPos, 0.0f, 0.0f);
                    world.method_30771((class_1297)conjuredTrident);
                    world.method_43276((class_6880)class_5712.field_28738, blockPos, class_5712.class_7397.method_43285((class_1297)conjurerEntity));
                }
            }
        }
    }

    protected void finishRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        if (conjurerEntity.getState() == DrownedConjurerEntity.State.CONJURE_TRIDENTS) {
            conjurerEntity.setState(DrownedConjurerEntity.State.STANDING);
        }
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.CONJURING_COOLDOWN, (Object)class_3902.field_17274, (long)SUMMONING_COOLDOWN_EXPIRY * 2L);
        conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.PREFORM_CONJURING);
    }

    private static boolean isTargetWithinRange(DrownedConjurerEntity conjurerEntity, class_1309 target) {
        double d = conjurerEntity.method_19538().method_1025(target.method_19538());
        return d < 256.0;
    }

    private void spawnSummonParticles(class_3218 world, class_2338 blockPos, class_5819 random) {
        for (int i = 0; i < 20; ++i) {
            double e = (double)blockPos.method_10263() + 0.5 + (random.method_43058() - 0.5) * 2.0;
            double f = (double)blockPos.method_10264() + 0.5 + (random.method_43058() - 0.5) * 2.0;
            double g = (double)blockPos.method_10260() + 0.5 + (random.method_43058() - 0.5) * 2.0;
            world.method_14199((class_2394)class_2398.field_11251, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
            world.method_14199((class_2394)class_2398.field_38002, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnWarningParticles(class_3218 world, DrownedConjurerEntity conjurerEntity, double x, double z, double maxY, double y) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        boolean bl = false;
        double d = 0.0;
        do {
            class_2680 blockState2;
            class_265 voxelShape;
            class_2338 blockPos2 = blockPos.method_10074();
            class_2680 blockState = conjurerEntity.method_37908().method_8320(blockPos2);
            if (!blockState.method_26206((class_1922)conjurerEntity.method_37908(), blockPos2, class_2350.field_11036)) continue;
            if (!conjurerEntity.method_37908().method_22347(blockPos) && !(voxelShape = (blockState2 = conjurerEntity.method_37908().method_8320(blockPos)).method_26220((class_1922)conjurerEntity.method_37908(), blockPos)).method_1110()) {
                d = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)maxY) - 1);
        if (bl) {
            world.method_14199((class_2394)AdventureParticles.THUNDER_IMPACT, (double)blockPos.method_10263(), y + d, (double)blockPos.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

