/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.conjurer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.DrownedConjurerEntity;
import net.j677.adventuresmod.entity.custom.WhirlpoolEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class ConjureWhirlpoolTask
extends class_4097<DrownedConjurerEntity> {
    private static final int RECOVER_EXPIRY = Math.round(9.0f);
    private static final int SUMMONING_CHARGING_EXPIRY = Math.round(50.0f);
    private static final int SUMMONING_COOLDOWN_EXPIRY = Math.round(75.0f);
    private static class_2338 targetpos;

    public ConjureWhirlpoolTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.CONJURING_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.PREFORM_CONJURING, (Object)class_4141.field_18456), SUMMONING_CHARGING_EXPIRY + 1 + RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
        return conjurerEntity.getState() == DrownedConjurerEntity.State.STANDING && conjurerEntity.method_18868().method_18904(class_4140.field_22355).map(target -> ConjureWhirlpoolTask.isTargetWithinRange(conjurerEntity, target)).map(withinRange -> {
            if (!withinRange.booleanValue()) {
                conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.PREFORM_CONJURING);
            }
            return withinRange;
        }).orElse(false) != false;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, DrownedConjurerEntity drownedConjurerEntity, long l) {
        return true;
    }

    protected void run(class_3218 world, DrownedConjurerEntity conjurerEntity, long time) {
        conjurerEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> conjurerEntity.setState(DrownedConjurerEntity.State.CONJURE_WHIRLPOOLS));
        conjurerEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(ConjureWhirlpoolTask::setPos);
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.CONJURING_CHARGING, (Object)class_3902.field_17274, (long)SUMMONING_CHARGING_EXPIRY);
        conjurerEntity.method_5783(class_3417.field_15193, 1.0f, 1.0f);
    }

    protected void keepRunning(class_3218 world, DrownedConjurerEntity conjurerEntity, long time) {
        class_4095<DrownedConjurerEntity> brain = conjurerEntity.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null) {
            conjurerEntity.method_5702(class_2183.class_2184.field_9851, livingEntity.method_19538());
            if (brain.method_18904(AdventureMemoryModuleTypes.CONJURING_CHARGING).isPresent()) {
                this.spawnParticles(world, conjurerEntity, targetpos);
            }
            if (brain.method_18904(AdventureMemoryModuleTypes.CONJURING_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.CONJURING_RECOVER).isEmpty()) {
                brain.method_24525(AdventureMemoryModuleTypes.CONJURING_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
                conjurerEntity.method_18868().method_18904(AdventureMemoryModuleTypes.ARENA_CENTER).flatMap(conjurerPos -> ConjureWhirlpoolTask.getWhirlpoolPos(conjurerPos.comp_2208())).ifPresent(blockPos -> this.conjurerWhirlpools(world, conjurerEntity, targetpos.method_10263(), blockPos.method_10264(), targetpos.method_10260()));
            }
        }
    }

    protected void finishRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        if (conjurerEntity.getState() == DrownedConjurerEntity.State.CONJURE_WHIRLPOOLS) {
            conjurerEntity.setState(DrownedConjurerEntity.State.STANDING);
        }
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.CONJURING_COOLDOWN, (Object)class_3902.field_17274, (long)SUMMONING_COOLDOWN_EXPIRY * 2L);
        conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.PREFORM_CONJURING);
    }

    private static boolean isTargetWithinRange(DrownedConjurerEntity conjurerEntity, class_1309 target) {
        double d = conjurerEntity.method_19538().method_1025(target.method_19538());
        return d < 256.0;
    }

    private static void setPos(class_1309 entity) {
        targetpos = entity.method_24515();
    }

    private static Optional<class_2338> getWhirlpoolPos(class_2338 pos) {
        if (pos != null) {
            return Optional.of(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        }
        return Optional.empty();
    }

    private void conjurerWhirlpools(class_3218 world, DrownedConjurerEntity conjurerEntity, double x, double y, double z) {
        WhirlpoolEntity whirlpoolEntity = new WhirlpoolEntity((class_1937)world, x, y, z, 1.0f);
        whirlpoolEntity.method_5783(class_3417.field_15193, 1.5f, 1.0f);
        whirlpoolEntity.setOwner((class_1309)conjurerEntity);
        whirlpoolEntity.setRadius(5.0f);
        whirlpoolEntity.setDuration(180);
        world.method_8649((class_1297)whirlpoolEntity);
    }

    private void spawnParticles(class_3218 world, DrownedConjurerEntity conjurerEntity, class_2338 blockPos) {
        for (int i = 0; i < 20; ++i) {
            double e = (double)blockPos.method_10263() + 0.5 + (conjurerEntity.random.method_43058() - 0.5) * 2.0;
            double f = (double)blockPos.method_10264() + 0.5 + (conjurerEntity.random.method_43058() - 0.5) * 2.0;
            double g = (double)blockPos.method_10260() + 0.5 + (conjurerEntity.random.method_43058() - 0.5) * 2.0;
            world.method_14199((class_2394)class_2398.field_11247, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
            world.method_14199((class_2394)class_2398.field_38002, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

