/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.conjurer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.DrownedConjurerEntity;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4141;

public class DrownedAwakenTask
extends class_4097<DrownedConjurerEntity> {
    private static final int RECOVER_EXPIRY = Math.round(30.0f);

    @VisibleForTesting
    public DrownedAwakenTask() {
        super((Map)ImmutableMap.of(AdventureMemoryModuleTypes.ARENA_CENTER, (Object)class_4141.field_18456), RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
        return conjurerEntity.getState() == DrownedConjurerEntity.State.AWAKEN;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        return true;
    }

    protected void finishRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        this.spawnTeleportParticles(serverWorld, conjurerEntity);
        conjurerEntity.method_18868().method_18904(AdventureMemoryModuleTypes.ARENA_CENTER).flatMap(teleportTarget -> DrownedAwakenTask.getTeleportPos(teleportTarget.comp_2208())).ifPresent(teleportPos -> conjurerEntity.method_6082(teleportPos.method_10263(), teleportPos.method_10264(), teleportPos.method_10260(), false));
        this.spawnTeleportParticles(serverWorld, conjurerEntity);
        conjurerEntity.setAwakened(true);
        conjurerEntity.startState(DrownedConjurerEntity.State.STANDING);
    }

    private static Optional<class_2338> getTeleportPos(class_2338 pos) {
        if (pos != null) {
            return Optional.of(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        }
        return Optional.empty();
    }

    private void spawnTeleportParticles(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
        for (int j = 0; j < 128; ++j) {
            double d = (double)j / 127.0;
            float f = (conjurerEntity.random.method_43057() - 0.5f) * 0.2f;
            float g = (conjurerEntity.random.method_43057() - 0.5f) * 0.2f;
            float h = (conjurerEntity.random.method_43057() - 0.5f) * 0.2f;
            double e = class_3532.method_16436((double)d, (double)conjurerEntity.field_6014, (double)conjurerEntity.method_23317()) + (conjurerEntity.random.method_43058() - 0.5) * (double)conjurerEntity.method_17681() * 2.0;
            double k = class_3532.method_16436((double)d, (double)conjurerEntity.field_6036, (double)conjurerEntity.method_23318()) + conjurerEntity.random.method_43058() * (double)conjurerEntity.method_17682();
            double l = class_3532.method_16436((double)d, (double)conjurerEntity.field_5969, (double)conjurerEntity.method_23321()) + (conjurerEntity.random.method_43058() - 0.5) * (double)conjurerEntity.method_17681() * 2.0;
            serverWorld.method_14199((class_2394)class_2398.field_11237, e, k, l, 1, (double)f, (double)g, (double)h, 0.0);
        }
    }
}

