/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.conjurer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.brain.conjurer.CastSpellTask;
import net.j677.adventuresmod.entity.brain.conjurer.ConjureBarrageTask;
import net.j677.adventuresmod.entity.brain.conjurer.ConjureDrownedTask;
import net.j677.adventuresmod.entity.brain.conjurer.ConjureTridentsTask;
import net.j677.adventuresmod.entity.brain.conjurer.ConjureWhirlpoolTask;
import net.j677.adventuresmod.entity.brain.conjurer.DrownedAwakenTask;
import net.j677.adventuresmod.entity.brain.conjurer.DrownedConjurerMoveTowardsTargetTask;
import net.j677.adventuresmod.entity.brain.conjurer.TridentLodgeTask;
import net.j677.adventuresmod.entity.custom.DrownedConjurerEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5321;

public class DrownedConjurerBrain {
    public static final ImmutableList<class_4149<? extends class_4148<? super DrownedConjurerEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_18469);
    public static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_30243, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_22355, (Object)class_4140.field_22475, (Object[])new class_4140[]{class_4140.field_18449, AdventureMemoryModuleTypes.ARENA_CENTER, AdventureMemoryModuleTypes.SPECIAL_COOLDOWN, AdventureMemoryModuleTypes.PREFORM_CONJURING, AdventureMemoryModuleTypes.CONJURING_CHARGING, AdventureMemoryModuleTypes.CONJURING_COOLDOWN, AdventureMemoryModuleTypes.CONJURING_RECOVER, AdventureMemoryModuleTypes.SHOOT_SPELL, AdventureMemoryModuleTypes.SHOOT_SPELL_CHARGING, AdventureMemoryModuleTypes.SHOOT_SPELL_COOLDOWN, AdventureMemoryModuleTypes.SHOOT_SPELL_RECOVER, AdventureMemoryModuleTypes.HEAVY_ATTACK, AdventureMemoryModuleTypes.HEAVY_MELEE_CHARGING, AdventureMemoryModuleTypes.HEAVY_MELEE_RECOVER, AdventureMemoryModuleTypes.HEAVY_MELEE_COOLDOWN, AdventureMemoryModuleTypes.STUNNED});

    public static class_4095<?> create(DrownedConjurerEntity drownedConjurer, class_4095<DrownedConjurerEntity> brain) {
        DrownedConjurerBrain.addCoreActivities(brain);
        DrownedConjurerBrain.addIdleActivities(brain);
        DrownedConjurerBrain.addFightActivities(drownedConjurer, brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    public static void setArenaCenterPos(DrownedConjurerEntity drownedConjurer) {
        class_2338 blockPos = drownedConjurer.method_24515().method_10079(drownedConjurer.method_58149(), 16).method_10079(class_2350.field_11033, 2);
        class_4208 globalPos = class_4208.method_19443((class_5321)drownedConjurer.method_37908().method_27983(), (class_2338)blockPos);
        drownedConjurer.method_18868().method_18878(AdventureMemoryModuleTypes.ARENA_CENTER, (Object)globalPos);
    }

    private static void addCoreActivities(class_4095<DrownedConjurerEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4110(45, 90), (Object)((Object)new DrownedAwakenTask()), new RecoveryTask(50)));
    }

    private static void addIdleActivities(class_4095<DrownedConjurerEntity> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4824.method_47119(DrownedConjurerBrain::getTarget)), (Object)Pair.of((Object)1, (Object)((Object)new PrepareAttackTask(10, 15)))));
    }

    private static void addFightActivities(DrownedConjurerEntity drownedConjurer, class_4095<DrownedConjurerEntity> brain) {
        brain.method_24529(class_4168.field_22396, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4828.method_47138(livingEntity -> !class_4148.method_36982((class_1309)drownedConjurer, (class_1309)livingEntity))), (Object)Pair.of((Object)1, (Object)((Object)new CastSpellTask())), (Object)Pair.of((Object)1, (Object)((Object)new TridentLodgeTask())), (Object)Pair.of((Object)2, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)((Object)new ConjureDrownedTask()), (Object)2), (Object)Pair.of((Object)((Object)new ConjureTridentsTask()), (Object)2), (Object)Pair.of((Object)((Object)new ConjureWhirlpoolTask()), (Object)1), (Object)Pair.of((Object)((Object)new ConjureBarrageTask()), (Object)1)))), (Object)Pair.of((Object)3, (Object)((Object)new DrownedConjurerMoveTowardsTargetTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (Object)Pair.of(AdventureMemoryModuleTypes.STUNNED, (Object)class_4141.field_18457)));
    }

    public static void tick(DrownedConjurerEntity drownedConjurer) {
        class_4095<DrownedConjurerEntity> brain = drownedConjurer.method_18868();
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_18595));
        drownedConjurer.method_19540(brain.method_18896(class_4140.field_22355));
    }

    private static Optional<? extends class_1309> getTarget(DrownedConjurerEntity drownedConjurer) {
        Optional optional2 = DrownedConjurerBrain.getTargetIfInRange(drownedConjurer);
        return optional2.isPresent() ? optional2 : drownedConjurer.method_18868().method_18904(class_4140.field_30243);
    }

    private static Optional<? extends class_1309> getTargetIfInRange(DrownedConjurerEntity drownedConjurer) {
        return drownedConjurer.method_18868().method_18904(class_4140.field_18444).filter(target -> target.method_24516((class_1297)drownedConjurer, 40.0));
    }

    public static class RecoveryTask<E extends DrownedConjurerEntity>
    extends class_4097<E> {
        public RecoveryTask(int duration) {
            super((Map)ImmutableMap.of(AdventureMemoryModuleTypes.STUNNED, (Object)class_4141.field_18457), duration);
        }

        protected boolean shouldRun(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
            return conjurerEntity.isInState(DrownedConjurerEntity.State.STUNNED);
        }

        protected boolean shouldKeepRunning(class_3218 serverWorld, E conjurerEntity, long l) {
            return true;
        }

        protected void finishRunning(class_3218 serverWorld, E conjurerEntity, long l) {
            if (((DrownedConjurerEntity)((Object)conjurerEntity)).isInState(DrownedConjurerEntity.State.STUNNED)) {
                ((DrownedConjurerEntity)((Object)conjurerEntity)).setState(DrownedConjurerEntity.State.STANDING);
            }
        }
    }

    public static class PrepareAttackTask
    extends class_4112 {
        @VisibleForTesting
        public PrepareAttackTask(int i, int j) {
            super(i, j);
        }

        protected void method_18982(class_3218 serverWorld, class_1308 mobEntity, long l) {
            super.method_18982(serverWorld, mobEntity, l);
        }

        protected void method_18981(class_3218 serverWorld, class_1308 mobEntity, long l) {
            super.method_18981(serverWorld, mobEntity, l);
            if (mobEntity.method_18868().method_18896(class_4140.field_22355)) {
                mobEntity.method_18868().method_24525(AdventureMemoryModuleTypes.SHOOT_SPELL, (Object)class_3902.field_17274, 60L);
            }
        }
    }
}

