/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.conjurer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.DrownedConjurerEntity;
import net.j677.adventuresmod.entity.custom.DrownedVanguardEntity;
import net.j677.adventuresmod.particle.AdventureParticles;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_2183;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class TridentLodgeTask
extends class_4097<DrownedConjurerEntity> {
    private static final int RECOVER_EXPIRY = Math.round(20.0f);
    private static final int SUMMONING_CHARGING_EXPIRY = Math.round(15.0f);
    private static final int SUMMONING_COOLDOWN_EXPIRY = Math.round(50.0f);

    public TridentLodgeTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.CONJURING_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.CONJURING_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.HEAVY_MELEE_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.HEAVY_MELEE_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.HEAVY_MELEE_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.SHOOT_SPELL, (Object)class_4141.field_18456), SUMMONING_CHARGING_EXPIRY + 1 + RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, DrownedConjurerEntity drownedConjurerEntity) {
        return drownedConjurerEntity.method_18868().method_18904(class_4140.field_22355).map(target -> TridentLodgeTask.isTargetWithinRange(drownedConjurerEntity, target)).orElse(false);
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        return true;
    }

    protected void run(class_3218 world, DrownedConjurerEntity conjurerEntity, long time) {
        conjurerEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> conjurerEntity.setState(DrownedConjurerEntity.State.TRIDENT_LODGE));
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.HEAVY_MELEE_CHARGING, (Object)class_3902.field_17274, (long)SUMMONING_CHARGING_EXPIRY);
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.HEAVY_ATTACK, (Object)class_3902.field_17274, (long)SUMMONING_CHARGING_EXPIRY);
    }

    protected void keepRunning(class_3218 world, DrownedConjurerEntity conjurerEntity, long l) {
        class_4095<DrownedConjurerEntity> brain = conjurerEntity.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null) {
            conjurerEntity.method_5702(class_2183.class_2184.field_9851, livingEntity.method_19538());
            if (brain.method_18904(AdventureMemoryModuleTypes.HEAVY_MELEE_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.HEAVY_MELEE_RECOVER).isEmpty()) {
                brain.method_24525(AdventureMemoryModuleTypes.HEAVY_MELEE_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
                this.knockbackEntities(world, conjurerEntity);
            }
        }
    }

    private static boolean isTargetWithinRange(DrownedConjurerEntity conjurerEntity, class_1309 target) {
        double d = conjurerEntity.method_19538().method_1025(target.method_19538());
        return d < 5.0;
    }

    protected void finishRunning(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity, long l) {
        if (conjurerEntity.getState() == DrownedConjurerEntity.State.TRIDENT_LODGE) {
            conjurerEntity.setState(DrownedConjurerEntity.State.STANDING);
        }
        conjurerEntity.method_18868().method_24525(AdventureMemoryModuleTypes.HEAVY_MELEE_COOLDOWN, (Object)class_3902.field_17274, (long)SUMMONING_COOLDOWN_EXPIRY * 2L);
        conjurerEntity.method_18868().method_18875(AdventureMemoryModuleTypes.HEAVY_ATTACK);
    }

    public void knockbackEntities(class_3218 serverWorld, DrownedConjurerEntity conjurerEntity) {
        for (class_1309 target : serverWorld.method_8390(class_1309.class, conjurerEntity.method_5829().method_1014(4.0), class_1301.field_6156)) {
            if (target instanceof DrownedVanguardEntity || target instanceof DrownedConjurerEntity) continue;
            double f = target.method_23317() - conjurerEntity.method_23317();
            double g = target.method_23321() - conjurerEntity.method_23321();
            double h = Math.max(f * f + g * g, 0.1);
            target.method_5762(f / h * 12.0, (double)0.3f, g / h * 12.0);
            class_1282 damageSource = conjurerEntity.method_48923().method_48812((class_1309)conjurerEntity);
            target.method_5643(damageSource, 3.0f);
            class_1890.method_60107((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource);
        }
        serverWorld.method_14199((class_2394)AdventureParticles.EXPLOSION_DUST, conjurerEntity.method_23317(), conjurerEntity.method_23318() + 0.2, conjurerEntity.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
    }
}

