/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.golem;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.config.AdventurersBeyondConfig;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.RunestoneGolemEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class GolemMeleeTask
extends class_4097<RunestoneGolemEntity> {
    private static final int RUN_TIME = class_3532.method_15386((float)60.0f);
    private static final int DELAY = class_3532.method_15384((double)25.0);

    public GolemMeleeTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.HEAVY_MELEE_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.HEAVY_MELEE_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.HEAVY_MELEE_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.AURA_ATTACK, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.STOMP_ATTACK, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.HEAVY_ATTACK, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.FAKE_DEATH, (Object)class_4141.field_18457), RUN_TIME + DELAY);
    }

    protected boolean shouldRun(class_3218 world, RunestoneGolemEntity entity) {
        return entity.method_18868().method_18904(class_4140.field_22355).map(target -> GolemMeleeTask.isTargetWithinRange(entity, target)).orElse(false);
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, RunestoneGolemEntity entity, long l) {
        return !entity.method_18868().method_18896(AdventureMemoryModuleTypes.FAKE_DEATH);
    }

    protected void run(class_3218 world, RunestoneGolemEntity entity, long time) {
        entity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> entity.setState(RunestoneGolemEntity.State.HEAVY_ATTACK));
        entity.method_18868().method_24525(AdventureMemoryModuleTypes.HEAVY_ATTACK, (Object)class_3902.field_17274, (long)(RUN_TIME - DELAY));
        entity.method_18868().method_24525(AdventureMemoryModuleTypes.HEAVY_MELEE_CHARGING, (Object)class_3902.field_17274, (long)DELAY);
        entity.method_5783(class_3417.field_47192, 1.0f, 1.0f);
    }

    protected void keepRunning(class_3218 world, RunestoneGolemEntity entity, long time) {
        if (!entity.method_18868().method_18896(AdventureMemoryModuleTypes.HEAVY_MELEE_CHARGING) && !entity.method_18868().method_18896(AdventureMemoryModuleTypes.HEAVY_MELEE_RECOVER)) {
            entity.method_18868().method_24525(AdventureMemoryModuleTypes.HEAVY_MELEE_RECOVER, (Object)class_3902.field_17274, (long)(RUN_TIME - DELAY));
            entity.method_18868().method_18904(class_4140.field_22355).filter(target -> entity.method_43259((class_1297)target, 4.0, 4.0)).ifPresent(target -> {
                if (entity.getRemainingCrystals() > 0) {
                    if (target.method_5643(world.method_48963().method_48812((class_1309)entity), AdventurersBeyondConfig.RUNESTONE_GOLEM_ATTACK_DAMAGE + (float)entity.getRemainingCrystals() * 1.5f)) {
                        double d0 = target.method_23317() - entity.method_23317();
                        double d1 = target.method_23321() - entity.method_23321();
                        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                        target.method_5762(d0 / d2 * 3.0, 0.2, d1 / d2 * 3.0);
                    }
                } else if (target.method_5643(world.method_48963().method_48812((class_1309)entity), AdventurersBeyondConfig.RUNESTONE_GOLEM_ATTACK_DAMAGE)) {
                    double d0 = target.method_23317() - entity.method_23317();
                    double d1 = target.method_23321() - entity.method_23321();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    target.method_5762(d0 / d2 * 3.0, 0.2, d1 / d2 * 3.0);
                }
            });
        }
    }

    protected void finishRunning(class_3218 serverWorld, RunestoneGolemEntity golemEntity, long l) {
        if (golemEntity.getState() == RunestoneGolemEntity.State.HEAVY_ATTACK) {
            golemEntity.setState(RunestoneGolemEntity.State.IDLING);
        }
        golemEntity.method_18868().method_24525(AdventureMemoryModuleTypes.HEAVY_MELEE_COOLDOWN, (Object)class_3902.field_17274, 5L);
        golemEntity.method_18868().method_18875(AdventureMemoryModuleTypes.HEAVY_ATTACK);
    }

    private static boolean isTargetWithinRange(RunestoneGolemEntity entity, class_1309 target) {
        double d = entity.method_5739((class_1297)target);
        return d <= 4.5;
    }
}

