/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.golem;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.brain.AdventureSensorTypes;
import net.j677.adventuresmod.entity.brain.golem.BlightCrystalDefenseTask;
import net.j677.adventuresmod.entity.brain.golem.FakeDeathTask;
import net.j677.adventuresmod.entity.brain.golem.GolemMeleeTask;
import net.j677.adventuresmod.entity.brain.golem.GolemStompTask;
import net.j677.adventuresmod.entity.brain.golem.SummonAuraTask;
import net.j677.adventuresmod.entity.brain.golem.SummonCoresTask;
import net.j677.adventuresmod.entity.brain.golem.SummonCrystalsTask;
import net.j677.adventuresmod.entity.custom.RunestoneGolemEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4115;
import net.minecraft.class_4118;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4215;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5321;
import net.minecraft.class_6670;
import net.minecraft.class_7893;
import net.minecraft.class_7898;

public class RunestoneGolemBrain {
    public static final List<class_4149<? extends class_4148<? super RunestoneGolemEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, (Object)class_4149.field_18467, AdventureSensorTypes.GOLEM_ATTACK_ENTITY_SENSOR);
    public static final List<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18442, (Object)class_4140.field_22354, (Object)class_4140.field_30243, (Object)class_4140.field_19293, (Object)class_4140.field_22355, (Object)class_4140.field_18445, AdventureMemoryModuleTypes.ARENA_CENTER, AdventureMemoryModuleTypes.AURA_ATTACK, AdventureMemoryModuleTypes.SPECIAL_COOLDOWN, AdventureMemoryModuleTypes.STOMP_ATTACK, AdventureMemoryModuleTypes.HEAVY_ATTACK, (Object[])new class_4140[]{AdventureMemoryModuleTypes.STOMP_CHARGING, AdventureMemoryModuleTypes.STOMP_RECOVER, AdventureMemoryModuleTypes.STOMP_COOLDOWN, AdventureMemoryModuleTypes.HEAVY_MELEE_CHARGING, AdventureMemoryModuleTypes.HEAVY_MELEE_RECOVER, AdventureMemoryModuleTypes.HEAVY_MELEE_COOLDOWN, AdventureMemoryModuleTypes.AURA_CHARGING, AdventureMemoryModuleTypes.AURA_RECOVER, AdventureMemoryModuleTypes.AURA_COOLDOWN, AdventureMemoryModuleTypes.FAKE_DEATH, class_4140.field_18451, class_4140.field_18452, class_4140.field_18449});

    public static class_4095<?> create(RunestoneGolemEntity golemEntity, class_4095<RunestoneGolemEntity> brain) {
        RunestoneGolemBrain.addCoreTasks(brain);
        RunestoneGolemBrain.addIdleTasks(brain);
        RunestoneGolemBrain.addFightTasks(golemEntity, brain);
        brain.method_18890(Set.of(class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreTasks(class_4095<RunestoneGolemEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4110(45, 90), (Object)new class_4112(), new BlightCooldownTask(), (Object)((Object)new FakeDeathTask())));
    }

    private static void addIdleTasks(class_4095<RunestoneGolemEntity> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4824.method_47119(golem -> golem.method_18868().method_18904(class_4140.field_22354))), (Object)Pair.of((Object)1, (Object)class_4824.method_47119(RunestoneGolemEntity::getHurtBy))));
    }

    private static void addFightTasks(RunestoneGolemEntity golem, class_4095<RunestoneGolemEntity> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of(GolemApproachTask.create(1.2f, golem), (Object)((Object)new GolemMeleeTask()), (Object)((Object)new GolemStompTask()), (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)((Object)new SummonAuraTask()), (Object)1), (Object)Pair.of((Object)((Object)new SummonCrystalsTask()), (Object)1), (Object)Pair.of((Object)((Object)new SummonCoresTask()), (Object)1))), (Object)((Object)new BlightCrystalDefenseTask()), (Object)class_4828.method_47132()), class_4140.field_22355);
    }

    public static void tick(RunestoneGolemEntity golemEntity) {
        class_4095<RunestoneGolemEntity> brain = golemEntity.method_18868();
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_18595));
        golemEntity.method_19540(brain.method_18896(class_4140.field_22355));
    }

    public static void setArenaCenterPos(RunestoneGolemEntity runestoneGolem) {
        class_2338 blockPos = runestoneGolem.method_24515();
        class_4208 globalPos = class_4208.method_19443((class_5321)runestoneGolem.method_37908().method_27983(), (class_2338)blockPos);
        runestoneGolem.method_18868().method_18878(AdventureMemoryModuleTypes.ARENA_CENTER, (Object)globalPos);
    }

    public static class BlightCooldownTask<E extends RunestoneGolemEntity>
    extends class_4097<E> {
        public BlightCooldownTask() {
            super((Map)ImmutableMap.of(), 1);
        }

        protected boolean shouldRun(class_3218 serverWorld, E runestoneGolem) {
            return ((RunestoneGolemEntity)((Object)runestoneGolem)).getRemainingCrystals() == 0 && ((RunestoneGolemEntity)((Object)runestoneGolem)).hasCrystals();
        }

        protected boolean shouldKeepRunning(class_3218 serverWorld, E runestoneGolem, long l) {
            return true;
        }

        protected void finishRunning(class_3218 serverWorld, E runestoneGolem, long l) {
            ((RunestoneGolemEntity)((Object)runestoneGolem)).method_18868().method_24525(AdventureMemoryModuleTypes.SPECIAL_COOLDOWN, (Object)class_3902.field_17274, 1000L);
            ((RunestoneGolemEntity)((Object)runestoneGolem)).setHasCrystals(false);
        }
    }

    public static class GolemApproachTask {
        public static class_7893<class_1308> create(float speed, RunestoneGolemEntity golem) {
            return GolemApproachTask.create(entity -> Float.valueOf(speed), golem);
        }

        public static class_7893<class_1308> create(Function<class_1309, Float> speed, RunestoneGolemEntity golem) {
            return class_7898.method_47224(context -> context.group((App)context.method_47235(class_4140.field_18445), (App)context.method_47235(class_4140.field_18446), (App)context.method_47235(AdventureMemoryModuleTypes.HEAVY_ATTACK), (App)context.method_47235(AdventureMemoryModuleTypes.STOMP_ATTACK), (App)context.method_47235(AdventureMemoryModuleTypes.AURA_ATTACK), (App)context.method_47235(AdventureMemoryModuleTypes.FAKE_DEATH), (App)context.method_47244(class_4140.field_22355), (App)context.method_47235(class_4140.field_18442)).apply((Applicative)context, (walkTarget, lookTarget, stompAttack, heavyAttack, auraAttack, fakeDeath, attackTarget, visibleMobs) -> (world, entity, time) -> {
                class_1309 livingEntity = (class_1309)context.method_47243(attackTarget);
                Optional optional = context.method_47233(visibleMobs);
                Optional optional2 = context.method_47233(stompAttack);
                Optional optional3 = context.method_47233(auraAttack);
                Optional optional4 = context.method_47233(fakeDeath);
                Optional optional5 = context.method_47233(heavyAttack);
                if (optional.isPresent() && ((class_6670)optional.get()).method_38972(livingEntity) && class_4215.method_25940((class_1308)entity, (class_1309)livingEntity, (int)1)) {
                    walkTarget.method_47252();
                } else if (optional2.isPresent() || optional3.isPresent() || optional4.isPresent() || optional5.isPresent()) {
                    walkTarget.method_47252();
                } else {
                    lookTarget.method_47249((Object)new class_4102((class_1297)livingEntity, true));
                    walkTarget.method_47249((Object)new class_4142((class_4115)new class_4102((class_1297)livingEntity, false), ((Float)speed.apply(entity)).floatValue(), 0));
                }
                return true;
            }));
        }
    }
}

