/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.golem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.RunestoneCoreEntity;
import net.j677.adventuresmod.entity.custom.RunestoneGolemEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class SummonCoresTask
extends class_4097<RunestoneGolemEntity> {
    private static final int AURA_CHARGING_EXPIRY = Math.round(14.0f);
    private static final int RECOVER_EXPIRY = Math.round(110.0f);

    @VisibleForTesting
    public SummonCoresTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.AURA_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.AURA_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.AURA_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.AURA_ATTACK, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.STOMP_ATTACK, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.HEAVY_ATTACK, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.FAKE_DEATH, (Object)class_4141.field_18457), RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, RunestoneGolemEntity golemEntity) {
        return golemEntity.method_18868().method_18904(class_4140.field_22355).map(target -> SummonCoresTask.isTargetWithinRange(golemEntity, target)).orElse(false);
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, RunestoneGolemEntity golemEntity, long l) {
        return !golemEntity.method_18868().method_18896(AdventureMemoryModuleTypes.FAKE_DEATH);
    }

    protected void run(class_3218 serverWorld, RunestoneGolemEntity golemEntity, long l) {
        golemEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> golemEntity.setState(RunestoneGolemEntity.State.RUNIC_ATTACK_START));
        golemEntity.method_18868().method_24525(AdventureMemoryModuleTypes.AURA_ATTACK, (Object)class_3902.field_17274, (long)(RECOVER_EXPIRY + 10));
        golemEntity.method_18868().method_24525(AdventureMemoryModuleTypes.AURA_CHARGING, (Object)class_3902.field_17274, (long)AURA_CHARGING_EXPIRY);
        golemEntity.method_5783(class_3417.field_47192, 1.0f, 1.0f);
    }

    protected void keepRunning(class_3218 serverWorld, RunestoneGolemEntity golemEntity, long l) {
        class_4095<RunestoneGolemEntity> brain = golemEntity.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null) {
            golemEntity.method_5702(class_2183.class_2184.field_9851, livingEntity.method_19538());
            if (brain.method_18904(AdventureMemoryModuleTypes.AURA_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.AURA_RECOVER).isEmpty()) {
                brain.method_24525(AdventureMemoryModuleTypes.AURA_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
                double y = golemEntity.method_5829().method_1005().method_10214();
                this.spawnCores(serverWorld, golemEntity, livingEntity, golemEntity.method_23317() + 3.0, y, golemEntity.method_23321() + 3.0, 10.0f, (float)golemEntity.getRemainingCrystals() * 0.5f);
                this.spawnCores(serverWorld, golemEntity, livingEntity, golemEntity.method_23317() - 3.0, y, golemEntity.method_23321() + 3.0, 20.0f, (float)golemEntity.getRemainingCrystals() * 0.5f);
                this.spawnCores(serverWorld, golemEntity, livingEntity, golemEntity.method_23317() - 3.0, y, golemEntity.method_23321() - 3.0, 30.0f, (float)golemEntity.getRemainingCrystals() * 0.5f);
            }
        }
    }

    protected void finishRunning(class_3218 serverWorld, RunestoneGolemEntity golemEntity, long l) {
        if (golemEntity.getState() == RunestoneGolemEntity.State.RUNIC_ATTACK_START) {
            golemEntity.setState(RunestoneGolemEntity.State.RUNIC_ATTACK_STOP);
        }
        golemEntity.method_18868().method_24525(AdventureMemoryModuleTypes.AURA_COOLDOWN, (Object)class_3902.field_17274, 120L);
    }

    private static boolean isTargetWithinRange(RunestoneGolemEntity golem, class_1309 target) {
        double d = golem.method_19538().method_1025(target.method_19538());
        return d < 256.0;
    }

    private void spawnCores(class_3218 world, RunestoneGolemEntity runestoneGolemEntity, class_1309 target, double x, double y, double z, float delay, float damage) {
        RunestoneCoreEntity coreEntity = new RunestoneCoreEntity((class_1937)world, (class_1309)runestoneGolemEntity, (class_1297)target, x, y, z, 100.0f + delay, damage);
        world.method_8649((class_1297)coreEntity);
    }
}

