/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.golem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.RunestoneCrystalEntity;
import net.j677.adventuresmod.entity.custom.RunestoneGolemEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class SummonCrystalsTask
extends class_4097<RunestoneGolemEntity> {
    private static final int AURA_CHARGING_EXPIRY = Math.round(14.0f);
    private static final int RECOVER_EXPIRY = Math.round(30.0f);

    @VisibleForTesting
    public SummonCrystalsTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.AURA_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.AURA_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.AURA_RECOVER, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.AURA_ATTACK, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.STOMP_ATTACK, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.HEAVY_ATTACK, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.FAKE_DEATH, (Object)class_4141.field_18457), RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, RunestoneGolemEntity golemEntity) {
        return golemEntity.method_18868().method_18904(class_4140.field_22355).map(target -> SummonCrystalsTask.isTargetWithinRange(golemEntity, target)).orElse(false);
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, RunestoneGolemEntity golemEntity, long l) {
        return !golemEntity.method_18868().method_18896(AdventureMemoryModuleTypes.FAKE_DEATH);
    }

    protected void run(class_3218 serverWorld, RunestoneGolemEntity golemEntity, long l) {
        golemEntity.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> golemEntity.setState(RunestoneGolemEntity.State.STOMP_ATTACK));
        golemEntity.method_18868().method_24525(AdventureMemoryModuleTypes.AURA_ATTACK, (Object)class_3902.field_17274, (long)(RECOVER_EXPIRY + 10));
        golemEntity.method_18868().method_24525(AdventureMemoryModuleTypes.AURA_CHARGING, (Object)class_3902.field_17274, (long)AURA_CHARGING_EXPIRY);
        golemEntity.method_5783(class_3417.field_47192, 1.0f, 1.0f);
    }

    protected void keepRunning(class_3218 serverWorld, RunestoneGolemEntity golemEntity, long l) {
        block5: {
            class_4095<RunestoneGolemEntity> brain = golemEntity.method_18868();
            class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
            if (livingEntity == null) break block5;
            golemEntity.method_5702(class_2183.class_2184.field_9851, livingEntity.method_19538());
            if (brain.method_18904(AdventureMemoryModuleTypes.AURA_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.AURA_RECOVER).isEmpty()) {
                brain.method_24525(AdventureMemoryModuleTypes.AURA_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
                double d = Math.min(livingEntity.method_23318(), golemEntity.method_23318());
                double e = Math.max(livingEntity.method_23318(), golemEntity.method_23318()) + 1.0;
                float f = (float)class_3532.method_15349((double)(livingEntity.method_23321() - golemEntity.method_23321()), (double)(livingEntity.method_23317() - golemEntity.method_23317()));
                if (golemEntity.getRemainingCrystals() > 0) {
                    for (int j = 0; j < 12; ++j) {
                        float g = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        double h = 4.5 * (double)golemEntity.method_59922().method_39332(2, 5);
                        this.spawnCrystals(golemEntity, golemEntity.method_23317() + (double)class_3532.method_15362((float)g) * h, golemEntity.method_23321() + (double)class_3532.method_15374((float)g) * h, d, e, j);
                    }
                } else {
                    for (int j = 0; j < 24; ++j) {
                        float g = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        double h = 4.5 * (double)golemEntity.method_59922().method_39332(2, 5);
                        this.spawnCrystals(golemEntity, golemEntity.method_23317() + (double)class_3532.method_15362((float)g) * h, golemEntity.method_23321() + (double)class_3532.method_15374((float)g) * h, d, e, j);
                    }
                }
            }
        }
    }

    protected void finishRunning(class_3218 serverWorld, RunestoneGolemEntity golemEntity, long l) {
        if (golemEntity.getState() == RunestoneGolemEntity.State.STOMP_ATTACK) {
            golemEntity.setState(RunestoneGolemEntity.State.IDLING);
        }
        golemEntity.method_18868().method_24525(AdventureMemoryModuleTypes.AURA_COOLDOWN, (Object)class_3902.field_17274, 120L);
    }

    private static boolean isTargetWithinRange(RunestoneGolemEntity golem, class_1309 target) {
        double d = golem.method_19538().method_1025(target.method_19538());
        return d < 256.0;
    }

    private void spawnCrystals(RunestoneGolemEntity golem, double x, double z, double maxY, double y, int warmup) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        boolean bl = false;
        double d = 0.0;
        do {
            class_2680 blockState2;
            class_265 voxelShape;
            class_2338 blockPos2 = blockPos.method_10074();
            class_2680 blockState = golem.method_37908().method_8320(blockPos2);
            if (!blockState.method_26206((class_1922)golem.method_37908(), blockPos2, class_2350.field_11036)) continue;
            if (!golem.method_37908().method_22347(blockPos) && !(voxelShape = (blockState2 = golem.method_37908().method_8320(blockPos)).method_26220((class_1922)golem.method_37908(), blockPos)).method_1110()) {
                d = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)maxY) - 1);
        if (bl) {
            golem.method_37908().method_8649((class_1297)new RunestoneCrystalEntity(golem.method_37908(), x, (double)blockPos.method_10264() + d, z, 0.0f, warmup, (class_1309)golem, true));
        }
    }
}

