/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.rekindled;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.MortarEntity;
import net.j677.adventuresmod.entity.custom.RekindledEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5819;
import org.jetbrains.annotations.VisibleForTesting;

public class MortarTask
extends class_4097<RekindledEntity> {
    private static final int WARMUP_EXPIRY = Math.round(25.0f);
    private static final int RECOVER_EXPIRY = Math.round(40.0f);

    @VisibleForTesting
    public MortarTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.REKINDLED_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.REKINDLED_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.REKINDLED_RECOVER, (Object)class_4141.field_18457), RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 world, RekindledEntity rekindledEntity) {
        return rekindledEntity.canAttack() && rekindledEntity.method_18868().method_18904(class_4140.field_22355).map(target -> MortarTask.isTargetWithinRange(rekindledEntity, target)).orElse(false) != false;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, RekindledEntity rekindledEntity, long l) {
        return true;
    }

    protected void run(class_3218 world, RekindledEntity entity, long time) {
        entity.method_18868().method_24525(AdventureMemoryModuleTypes.REKINDLED_CHARGING, (Object)class_3902.field_17274, (long)WARMUP_EXPIRY);
        entity.addPreAttackParticles();
        entity.method_5783(class_3417.field_50092, 1.0f, 1.0f);
    }

    protected void keepRunning(class_3218 world, RekindledEntity rekindledEntity, long l) {
        class_4095<RekindledEntity> brain = rekindledEntity.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null && brain.method_18904(AdventureMemoryModuleTypes.REKINDLED_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.REKINDLED_RECOVER).isEmpty()) {
            brain.method_24525(AdventureMemoryModuleTypes.REKINDLED_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
            for (int i = 0; i < 16; ++i) {
                MortarEntity projectile = new MortarEntity(rekindledEntity.method_37908(), (class_1309)rekindledEntity);
                float b0 = class_3532.method_15344((class_5819)rekindledEntity.method_59922(), (float)5.0f, (float)10.0f);
                float b1 = class_3532.method_15344((class_5819)rekindledEntity.method_59922(), (float)1.0f, (float)8.0f);
                double b2 = (double)class_3532.method_15344((class_5819)rekindledEntity.method_59922(), (float)0.0f, (float)2.0f) * Math.PI;
                double x = b1 * class_3532.method_15362((float)((float)b2));
                double z = b1 * class_3532.method_15374((float)((float)b2));
                double y = (double)class_3532.method_27285((float)b0) / 10.0;
                projectile.method_5814(rekindledEntity.method_23317(), rekindledEntity.method_23318() + 10.0, rekindledEntity.method_23321());
                projectile.method_7485(x, y, z, 0.7f, 14 - rekindledEntity.method_37908().method_8407().method_5461() * 4);
                rekindledEntity.method_37908().method_8649((class_1297)projectile);
            }
        }
    }

    protected void finishRunning(class_3218 world, RekindledEntity rekindledEntity, long time) {
        rekindledEntity.addOverheat(1);
        rekindledEntity.method_18868().method_24525(AdventureMemoryModuleTypes.REKINDLED_COOLDOWN, (Object)class_3902.field_17274, 3L);
    }

    private static boolean isTargetWithinRange(RekindledEntity entity, class_1309 target) {
        double d = entity.method_19538().method_1025(target.method_19538());
        return d < 256.0;
    }
}

