/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.rekindled;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.EruptionSpawnerEntity;
import net.j677.adventuresmod.entity.custom.RekindledEntity;
import net.j677.adventuresmod.particle.AdventureParticles;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1677;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import org.jetbrains.annotations.VisibleForTesting;

public class RapidFireTask
extends class_4097<RekindledEntity> {
    private static final int RECOVER_EXPIRY = Math.round(250.0f);
    private static final int CHARGING_EXPIRY = Math.round(10.0f);

    @VisibleForTesting
    public RapidFireTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.REKINDLED_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.REKINDLED_RECOVER, (Object)class_4141.field_18457), CHARGING_EXPIRY + 1 + RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, RekindledEntity rekindledEntity) {
        return rekindledEntity.canAttack() && rekindledEntity.method_18868().method_18904(class_4140.field_22355).map(target -> RapidFireTask.isTargetWithinRange(rekindledEntity, target)).orElse(false) != false;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, RekindledEntity rekindledEntity, long l) {
        return !rekindledEntity.isInState(RekindledEntity.State.OVERHEATED);
    }

    protected void run(class_3218 world, RekindledEntity rekindledEntity, long time) {
        rekindledEntity.method_18868().method_24525(AdventureMemoryModuleTypes.REKINDLED_CHARGING, (Object)class_3902.field_17274, (long)CHARGING_EXPIRY);
        rekindledEntity.addPreAttackParticles();
        rekindledEntity.method_5783(class_3417.field_50092, 5.0f, 1.0f);
    }

    protected void keepRunning(class_3218 world, RekindledEntity rekindledEntity, long time) {
        class_4095<RekindledEntity> brain = rekindledEntity.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null) {
            if (brain.method_18904(AdventureMemoryModuleTypes.REKINDLED_CHARGING).isEmpty() && brain.method_18904(AdventureMemoryModuleTypes.REKINDLED_RECOVER).isEmpty()) {
                brain.method_24525(AdventureMemoryModuleTypes.REKINDLED_RECOVER, (Object)class_3902.field_17274, (long)RECOVER_EXPIRY);
                double d = Math.min(livingEntity.method_23318(), rekindledEntity.method_23318());
                double e = Math.max(livingEntity.method_23318(), rekindledEntity.method_23318()) + 1.0;
                for (int i = 0; i < 2; ++i) {
                    float j = (float)(i + 1) * 5.0f;
                    this.spawnWarningAndEruption(world, rekindledEntity, rekindledEntity.method_23317() + (double)j, rekindledEntity.method_23321() + (double)j, e, d);
                    this.spawnWarningAndEruption(world, rekindledEntity, rekindledEntity.method_23317() - (double)j, rekindledEntity.method_23321() - (double)j, e, d);
                    this.spawnWarningAndEruption(world, rekindledEntity, rekindledEntity.method_23317() + (double)j, rekindledEntity.method_23321() - (double)j, e, d);
                    this.spawnWarningAndEruption(world, rekindledEntity, rekindledEntity.method_23317() - (double)j, rekindledEntity.method_23321() + (double)j, e, d);
                }
                this.spawnWarningAndEruption(world, rekindledEntity, rekindledEntity.method_23317() + 10.0, rekindledEntity.method_23321(), e, d);
                this.spawnWarningAndEruption(world, rekindledEntity, rekindledEntity.method_23317() - 10.0, rekindledEntity.method_23321(), e, d);
                this.spawnWarningAndEruption(world, rekindledEntity, rekindledEntity.method_23317(), rekindledEntity.method_23321() + 10.0, e, d);
                this.spawnWarningAndEruption(world, rekindledEntity, rekindledEntity.method_23317(), rekindledEntity.method_23321() - 10.0, e, d);
            }
            if (brain.method_18904(AdventureMemoryModuleTypes.REKINDLED_CHARGING).isEmpty() && rekindledEntity.field_6012 % 7 == 0) {
                double e = livingEntity.method_23317() - rekindledEntity.method_23317();
                double f = livingEntity.method_23323(0.5) - rekindledEntity.method_23323(1.0);
                double g = livingEntity.method_23321() - rekindledEntity.method_23321();
                rekindledEntity.method_5783(AdventureSounds.ENTITY_REKINDLED_SHOOT, 1.0f, 1.0f);
                class_243 vec3d = new class_243(e, f, g);
                class_1677 fireballEntity = new class_1677((class_1937)world, (class_1309)rekindledEntity, vec3d.method_1029());
                fireballEntity.method_5814(fireballEntity.method_23317(), rekindledEntity.method_23318() + 10.0, fireballEntity.method_23321());
                world.method_8649((class_1297)fireballEntity);
            }
        }
    }

    protected void finishRunning(class_3218 serverWorld, RekindledEntity rekindledEntity, long l) {
        rekindledEntity.addOverheat(1);
    }

    private static boolean isTargetWithinRange(RekindledEntity rekindledEntity, class_1309 target) {
        double d = rekindledEntity.method_19538().method_1025(target.method_19538());
        return d < 256.0;
    }

    private void spawnWarningAndEruption(class_3218 world, RekindledEntity rekindledEntity, double x, double z, double maxY, double y) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        boolean bl = false;
        double d = 0.0;
        do {
            class_2680 blockState2;
            class_265 voxelShape;
            class_2338 blockPos2 = blockPos.method_10074();
            class_2680 blockState = rekindledEntity.method_37908().method_8320(blockPos2);
            if (!blockState.method_26206((class_1922)rekindledEntity.method_37908(), blockPos2, class_2350.field_11036)) continue;
            if (!rekindledEntity.method_37908().method_22347(blockPos) && !(voxelShape = (blockState2 = rekindledEntity.method_37908().method_8320(blockPos)).method_26220((class_1922)rekindledEntity.method_37908(), blockPos)).method_1110()) {
                d = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)maxY) - 1);
        if (bl) {
            EruptionSpawnerEntity eruptionSpawnerEntity = EruptionSpawnerEntity.create((class_1937)world);
            eruptionSpawnerEntity.method_24203(blockPos.method_10263(), y + d, blockPos.method_10260());
            world.method_8649((class_1297)eruptionSpawnerEntity);
            world.method_14199((class_2394)AdventureParticles.MAGMA_IMPACT, (double)blockPos.method_10263(), y + d + 0.2, (double)blockPos.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
            world.method_14199((class_2394)AdventureParticles.FISSURE, (double)blockPos.method_10263(), y + d + 0.05, (double)blockPos.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

