/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.rekindled;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.brain.AdventureSensorTypes;
import net.j677.adventuresmod.entity.brain.rekindled.EruptionTask;
import net.j677.adventuresmod.entity.brain.rekindled.MortarTask;
import net.j677.adventuresmod.entity.brain.rekindled.RapidFireTask;
import net.j677.adventuresmod.entity.brain.rekindled.ScorchTask;
import net.j677.adventuresmod.entity.custom.IgniterEntity;
import net.j677.adventuresmod.entity.custom.InflamedEntity;
import net.j677.adventuresmod.entity.custom.RekindledEntity;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4118;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class RekindledBrain {
    public static final int EMERGE_DURATION = class_3532.method_15386((float)86.59999f);
    public static final List<class_4149<? extends class_4148<? super RekindledEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, (Object)class_4149.field_18467, AdventureSensorTypes.REKINDLED_ATTACK_ENTITY_SENSOR);
    public static final List<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18442, (Object)class_4140.field_18444, (Object)class_4140.field_30243, (Object)class_4140.field_19293, (Object)class_4140.field_22355, (Object)class_4140.field_18445, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object)class_4140.field_18449, (Object)class_4140.field_38112, AdventureMemoryModuleTypes.REKINDLED_CHARGING, (Object[])new class_4140[]{AdventureMemoryModuleTypes.REKINDLED_RECOVER, AdventureMemoryModuleTypes.REKINDLED_COOLDOWN, AdventureMemoryModuleTypes.OVERHEATED});

    public static class_4095<?> create(RekindledEntity rekindledEntity, class_4095<RekindledEntity> brain) {
        RekindledBrain.addCoreTasks(brain);
        RekindledBrain.addEmergeActivities(brain);
        RekindledBrain.addIdleTasks(brain);
        RekindledBrain.addFightTasks(rekindledEntity, brain);
        brain.method_18890(Set.of(class_4168.field_18594));
        brain.method_18897(class_4168.field_22396);
        brain.method_24536();
        return brain;
    }

    private static void addCoreTasks(class_4095<RekindledEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of(new RekindleTask(50)));
    }

    private static void addEmergeActivities(class_4095<RekindledEntity> brain) {
        brain.method_24527(class_4168.field_38202, 5, ImmutableList.of(new EmergeTask(EMERGE_DURATION)), class_4140.field_38112);
    }

    private static void addIdleTasks(class_4095<RekindledEntity> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4824.method_47119(rekindled -> rekindled.method_18868().method_18904(class_4140.field_30243))), (Object)Pair.of((Object)1, (Object)class_4824.method_47119(RekindledEntity::getHurtBy))));
    }

    private static void addFightTasks(RekindledEntity entity, class_4095<RekindledEntity> brain) {
        brain.method_24529(class_4168.field_22396, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4828.method_47138(livingEntity -> !class_4148.method_36982((class_1309)entity, (class_1309)livingEntity))), (Object)Pair.of((Object)1, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)((Object)new MortarTask()), (Object)1), (Object)Pair.of((Object)((Object)new RapidFireTask()), (Object)1), (Object)Pair.of((Object)((Object)new ScorchTask()), (Object)1)))), (Object)Pair.of((Object)2, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)((Object)new EruptionTask()), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18456), (Object)Pair.of(AdventureMemoryModuleTypes.OVERHEATED, (Object)class_4141.field_18457)));
    }

    public static void updateActivities(RekindledEntity rekindledEntity) {
        rekindledEntity.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_38202, (Object)class_4168.field_22396, (Object)class_4168.field_18595));
    }

    public static void spawnReinforcements(RekindledEntity rekindledEntity) {
        int i = rekindledEntity.method_37908().method_18466(IgniterEntity.class, rekindledEntity.closeIgniterPredicate, (class_1309)rekindledEntity, rekindledEntity.method_5829().method_1014(24.0)).size();
        int random = class_5819.method_43047().method_39332(1, 2);
        class_1937 class_19372 = rekindledEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (1 > i && random == 1) {
                RekindledBrain.spawnInflamedAtPos(serverWorld, rekindledEntity, rekindledEntity.method_23317() + 6.5);
                RekindledBrain.spawnInflamedAtPos(serverWorld, rekindledEntity, rekindledEntity.method_23317() - 6.5);
            } else {
                for (int j = 0; j < 3; ++j) {
                    class_1309 livingEntity = rekindledEntity.method_18868().method_18904(class_4140.field_22355).orElse(null);
                    if (livingEntity == null) continue;
                    float f = (float)class_3532.method_15349((double)(livingEntity.method_23321() - rekindledEntity.method_23321()), (double)(livingEntity.method_23317() - rekindledEntity.method_23317()));
                    float g = f + (float)j * (float)Math.PI * 0.6f;
                    RekindledBrain.spawnIgnitersAtPos(rekindledEntity, rekindledEntity.method_23317() + (double)class_3532.method_15362((float)g) * 8.5, rekindledEntity.method_23321() + (double)class_3532.method_15374((float)g) * 8.5, g);
                }
            }
        }
    }

    private static void spawnIgnitersAtPos(RekindledEntity rekindled, double x, double z, float yaw) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)rekindled.method_23318(), (double)z);
        rekindled.method_37908().method_8649((class_1297)new IgniterEntity(rekindled.method_37908(), x, (double)blockPos.method_10264(), z, yaw, 3, (class_1309)rekindled));
        rekindled.method_37908().method_32888((class_6880)class_5712.field_28738, new class_243(x, (double)blockPos.method_10264(), z), class_5712.class_7397.method_43285((class_1297)rekindled));
    }

    private static void spawnInflamedAtPos(class_3218 world, RekindledEntity rekindled, double x) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)rekindled.method_23318(), (double)rekindled.method_23321());
        InflamedEntity inflamedEntity = (InflamedEntity)AdventureEntityTypes.INFLAMED.method_5883(rekindled.method_37908());
        if (inflamedEntity != null) {
            inflamedEntity.method_5808(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), 0.0f, 0.0f);
            inflamedEntity.method_5943((class_5425)world, rekindled.method_37908().method_8404(blockPos), class_3730.field_16471, null);
            world.method_30771((class_1297)inflamedEntity);
            world.method_32888((class_6880)class_5712.field_28738, new class_243(x, (double)blockPos.method_10264(), (double)blockPos.method_10260()), class_5712.class_7397.method_43285((class_1297)rekindled));
            for (int i = 0; i < 20; ++i) {
                double e = (double)blockPos.method_10263() + 0.5 + (rekindled.method_59922().method_43058() - 0.5) * 2.0;
                double f = (double)blockPos.method_10264() + 0.5 + (rekindled.method_59922().method_43058() - 0.5) * 2.0;
                double g = (double)blockPos.method_10260() + 0.5 + (rekindled.method_59922().method_43058() - 0.5) * 2.0;
                world.method_14199((class_2394)class_2398.field_11251, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
                world.method_14199((class_2394)class_2398.field_11240, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class RekindleTask<E extends RekindledEntity>
    extends class_4097<E> {
        public RekindleTask(int duration) {
            super((Map)ImmutableMap.of(AdventureMemoryModuleTypes.OVERHEATED, (Object)class_4141.field_18457), duration);
        }

        protected boolean shouldRun(class_3218 serverWorld, RekindledEntity rekindledEntity) {
            return rekindledEntity.isInState(RekindledEntity.State.OVERHEATED);
        }

        protected boolean shouldKeepRunning(class_3218 serverWorld, E rekindledEntity, long l) {
            return true;
        }

        protected void finishRunning(class_3218 serverWorld, E rekindledEntity, long l) {
            ((RekindledEntity)((Object)rekindledEntity)).knockbackEntities();
            if (((RekindledEntity)((Object)rekindledEntity)).isInState(RekindledEntity.State.OVERHEATED)) {
                ((RekindledEntity)((Object)rekindledEntity)).setState(RekindledEntity.State.IDLE);
            }
        }
    }

    public static class EmergeTask<E extends RekindledEntity>
    extends class_4097<E> {
        public EmergeTask(int duration) {
            super((Map)ImmutableMap.of((Object)class_4140.field_38112, (Object)class_4141.field_18456), duration);
        }

        protected boolean shouldKeepRunning(class_3218 serverWorld, E rekindledEntity, long l) {
            return true;
        }

        protected void run(class_3218 serverWorld, E rekindledEntity, long l) {
            ((RekindledEntity)((Object)rekindledEntity)).setState(RekindledEntity.State.EMERGING);
            rekindledEntity.method_5783(AdventureSounds.ENTITY_REKINDLED_EMERGE, 5.0f, 1.0f);
        }

        protected void finishRunning(class_3218 serverWorld, E rekindledEntity, long l) {
            if (((RekindledEntity)((Object)rekindledEntity)).isInState(RekindledEntity.State.EMERGING)) {
                ((RekindledEntity)((Object)rekindledEntity)).setState(RekindledEntity.State.IDLE);
            }
        }
    }
}

