/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.brain.rekindled;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.j677.adventuresmod.config.AdventurersBeyondConfig;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.custom.RekindledEntity;
import net.j677.adventuresmod.entity.custom.ScorchSpawnerEntity;
import net.j677.adventuresmod.util.AdventureDamageTypes;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import org.jetbrains.annotations.VisibleForTesting;

public class ScorchTask
extends class_4097<RekindledEntity> {
    private static final int RECOVER_EXPIRY = Math.round(120.0f);
    private static final int CHARGING_EXPIRY = Math.round(10.0f);
    private final List<class_2350> directions = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039);

    @VisibleForTesting
    public ScorchTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, AdventureMemoryModuleTypes.REKINDLED_COOLDOWN, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.REKINDLED_CHARGING, (Object)class_4141.field_18457, AdventureMemoryModuleTypes.REKINDLED_RECOVER, (Object)class_4141.field_18457), CHARGING_EXPIRY + 1 + RECOVER_EXPIRY);
    }

    protected boolean shouldRun(class_3218 serverWorld, RekindledEntity rekindledEntity) {
        return rekindledEntity.canAttack() && rekindledEntity.method_18868().method_18904(class_4140.field_22355).map(target -> ScorchTask.isTargetWithinRange(rekindledEntity, target)).orElse(false) != false;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, RekindledEntity rekindledEntity, long l) {
        return true;
    }

    protected void run(class_3218 serverWorld, RekindledEntity rekindledEntity, long l) {
        rekindledEntity.method_18868().method_24525(AdventureMemoryModuleTypes.REKINDLED_CHARGING, (Object)class_3902.field_17274, (long)CHARGING_EXPIRY);
        rekindledEntity.addPreAttackParticles();
        rekindledEntity.method_5783(class_3417.field_50092, 1.0f, 1.0f);
    }

    protected void keepRunning(class_3218 world, RekindledEntity rekindledEntity, long l) {
        class_4095<RekindledEntity> brain = rekindledEntity.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null && brain.method_18904(AdventureMemoryModuleTypes.REKINDLED_CHARGING).isEmpty()) {
            for (class_2350 direction : this.directions) {
                class_2338 furnacePos = new class_2338(rekindledEntity.method_24515().method_10263(), rekindledEntity.method_24515().method_10264(), rekindledEntity.method_24515().method_10260());
                class_238 box = ScorchTask.getScorchHitBox((class_1937)world, furnacePos, direction);
                List entities = world.method_8390(class_1309.class, Objects.requireNonNull(box), class_1301.field_6156);
                for (class_1309 entity : entities) {
                    if (entity instanceof RekindledEntity) continue;
                    if (entity.method_6059(class_1294.field_5918)) {
                        entity.method_5643(entity.method_48923().method_48795(AdventureDamageTypes.DEBRIS), AdventurersBeyondConfig.SCORCH_ATTACK_DEBRIS_DAMAGE);
                        continue;
                    }
                    entity.method_5643(entity.method_48923().method_48795(AdventureDamageTypes.INCINERATED), AdventurersBeyondConfig.SCORCH_ATTACK_FIRE_DAMAGE);
                }
                class_243 vec3d = furnacePos.method_46558();
                class_243 vec3d2 = box.method_1005().method_1020(vec3d);
                class_243 vec3d3 = vec3d2.method_1029();
                int i = class_3532.method_15357((double)vec3d2.method_1033()) + 7;
                for (int j = 1; j < i; ++j) {
                    class_243 vec3d4 = vec3d.method_1019(vec3d3.method_1021((double)j));
                    for (int k = 1; k < 3; ++k) {
                        world.method_14199((class_2394)class_2398.field_11240, vec3d4.field_1352, vec3d4.field_1351 + 0.5, vec3d4.field_1350, 1, world.method_8409().method_43058(), world.method_8409().method_43058(), world.method_8409().method_43058(), 0.0);
                    }
                }
            }
            if (rekindledEntity.field_6012 % 60 == 0) {
                for (int j = -1; j < 2; ++j) {
                    this.spawnScorch(world, livingEntity.method_23317() + (double)j * 1.5, rekindledEntity.method_23318(), livingEntity.method_23321());
                    this.spawnScorch(world, livingEntity.method_23317() + (double)j * 1.5, rekindledEntity.method_23318(), livingEntity.method_23321() + 1.5);
                    this.spawnScorch(world, livingEntity.method_23317() + (double)j * 1.5, rekindledEntity.method_23318(), livingEntity.method_23321() - 1.5);
                }
            }
        }
    }

    protected void finishRunning(class_3218 world, RekindledEntity rekindledEntity, long time) {
        rekindledEntity.addOverheat(1);
    }

    private static boolean isTargetWithinRange(RekindledEntity rekindled, class_1309 target) {
        double d = rekindled.method_19538().method_1025(target.method_19538());
        return d < 256.0;
    }

    private void spawnScorch(class_3218 world, double x, double y, double z) {
        ScorchSpawnerEntity eruptionSpawnerEntity = ScorchSpawnerEntity.create((class_1937)world);
        eruptionSpawnerEntity.method_24203(x, y, z);
        world.method_8649((class_1297)eruptionSpawnerEntity);
    }

    public static class_238 getScorchHitBox(class_1937 world, class_2338 blockPos, class_2350 directions) {
        Optional<class_2350> optional = Optional.ofNullable(directions);
        if (optional.isEmpty()) {
            return null;
        }
        class_2350 direction = optional.get();
        int width = 1;
        int height = 1;
        int distance = 16;
        for (int i = 1; i <= distance; ++i) {
            if (!world.method_8320(blockPos.method_10079(direction, i)).method_26234((class_1922)world, blockPos)) continue;
            distance = i - 1;
        }
        class_2338.class_2339 start = new class_2338.class_2339(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        class_2338.class_2339 end = new class_2338.class_2339(blockPos.method_10263() + 1, blockPos.method_10264() + 1, blockPos.method_10260() + 1);
        switch (direction) {
            case field_11043: {
                start.method_10100(-width, -height, -distance);
                end.method_10100(width, height, -1);
                break;
            }
            case field_11035: {
                start.method_10100(-width, -height, 1);
                end.method_10100(width, height, distance);
                break;
            }
            case field_11039: {
                start.method_10100(-distance, -height, -width);
                end.method_10100(-1, height, width);
                break;
            }
            case field_11034: {
                start.method_10100(1, -height, -width);
                end.method_10100(distance, height, width);
            }
        }
        return new class_238((double)start.method_10263(), (double)start.method_10264(), (double)start.method_10260(), (double)end.method_10263(), (double)end.method_10264(), (double)end.method_10260());
    }
}

