/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.client;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.j677.adventuresmod.block.AdventurePotPatterns;
import net.j677.adventuresmod.block.entity.AncientPotBlockEntity;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_8173;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class AncientPotBlockEntityRenderer
implements class_827<AncientPotBlockEntity> {
    public static final class_5601 LAYER_LOCATION = new class_5601(class_2960.method_60655((String)"adventuresmod", (String)"ancient_pot"), "main");
    public static final class_5601 SIDE_LAYER_LOCATION = new class_5601(class_2960.method_60655((String)"adventuresmod", (String)"ancient_pot"), "side");
    private final class_630 neck;
    private final class_630 frontSide;
    private final class_630 backSide;
    private final class_630 leftSide;
    private final class_630 rightSide;
    private final class_630 top;
    private final class_630 bottom;
    private final class_4730 baseMaterial = Objects.requireNonNull(class_4722.method_49341(AdventurePotPatterns.ANCIENT_BASE));
    private static final class_4730 sideMaterial = Objects.requireNonNull(class_4722.method_49341(AdventurePotPatterns.ANCIENT_SIDE));

    public AncientPotBlockEntityRenderer(class_5614.class_5615 context) {
        class_630 modelPart = context.method_32140(class_5602.field_42882);
        this.neck = modelPart.method_32086("neck");
        this.top = modelPart.method_32086("top");
        this.bottom = modelPart.method_32086("bottom");
        class_630 modelPart2 = context.method_32140(class_5602.field_42883);
        this.frontSide = modelPart2.method_32086("front");
        this.backSide = modelPart2.method_32086("back");
        this.leftSide = modelPart2.method_32086("left");
        this.rightSide = modelPart2.method_32086("right");
    }

    public static class_5607 getTopBottomNeckTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5605 dilation = new class_5605(0.2f);
        class_5605 dilation2 = new class_5605(-0.1f);
        modelPartData.method_32117("neck", class_5606.method_32108().method_32101(0, 0).method_32098(4.0f, 17.0f, 4.0f, 8.0f, 3.0f, 8.0f, dilation2).method_32101(0, 5).method_32098(5.0f, 20.0f, 5.0f, 6.0f, 1.0f, 6.0f, dilation), class_5603.method_32091((float)0.0f, (float)37.0f, (float)16.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        class_5606 modelPartBuilder = class_5606.method_32108().method_32101(-14, 13).method_32097(0.0f, 0.0f, 0.0f, 14.0f, 0.0f, 14.0f);
        modelPartData.method_32117("top", modelPartBuilder, class_5603.method_32091((float)1.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.method_32117("bottom", modelPartBuilder, class_5603.method_32091((float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)32, (int)32);
    }

    public static class_5607 getSidesTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5606 modelPartBuilder = class_5606.method_32108().method_32101(1, 0).method_49304(0.0f, 0.0f, 0.0f, 14.0f, 16.0f, 0.0f, EnumSet.of(class_2350.field_11043));
        modelPartData.method_32117("back", modelPartBuilder, class_5603.method_32091((float)15.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        modelPartData.method_32117("left", modelPartBuilder, class_5603.method_32091((float)1.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)-1.5707964f, (float)((float)Math.PI)));
        modelPartData.method_32117("right", modelPartBuilder, class_5603.method_32091((float)15.0f, (float)16.0f, (float)15.0f, (float)0.0f, (float)1.5707964f, (float)((float)Math.PI)));
        modelPartData.method_32117("front", modelPartBuilder, class_5603.method_32091((float)1.0f, (float)16.0f, (float)15.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)16, (int)16);
    }

    private static class_4730 getTextureIdFromSherd(Optional<class_1792> sherd) {
        class_4730 spriteIdentifier;
        if (sherd.isPresent() && (spriteIdentifier = class_4722.method_49341((class_5321)class_8173.method_49206((class_1792)sherd.get()))) != null) {
            return spriteIdentifier;
        }
        return sideMaterial;
    }

    public void render(AncientPotBlockEntity ancientPotBlockEntity, float f, class_4587 matrices, class_4597 vertexConsumerProvider, int i, int j) {
        float g;
        matrices.method_22903();
        class_2350 direction = ancientPotBlockEntity.getHorizontalFacing();
        matrices.method_22904(0.5, 0.0, 0.5);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f - direction.method_10144()));
        matrices.method_22904(-0.5, 0.0, -0.5);
        AncientPotBlockEntity.WobbleType wobbleType = ancientPotBlockEntity.lastWobbleType;
        if (wobbleType != null && ancientPotBlockEntity.method_10997() != null && (g = ((float)(ancientPotBlockEntity.method_10997().method_8510() - ancientPotBlockEntity.lastWobbleTime) + f) / (float)wobbleType.lengthInTicks) >= 0.0f && g <= 1.0f) {
            if (wobbleType == AncientPotBlockEntity.WobbleType.POSITIVE) {
                float f1 = 0.015625f;
                float f2 = g * ((float)Math.PI * 2);
                float f3 = -1.5f * (class_3532.method_15362((float)f2) + 0.5f) * class_3532.method_15374((float)(f2 / 2.0f));
                matrices.method_49278(class_7833.field_40714.rotation(f3 * 0.015625f), 0.5f, 0.0f, 0.5f);
                float f4 = class_3532.method_15374((float)f2);
                matrices.method_49278(class_7833.field_40718.rotation(f4 * 0.015625f), 0.5f, 0.0f, 0.5f);
            } else {
                float f5 = class_3532.method_15374((float)(-g * 3.0f * (float)Math.PI)) * 0.125f;
                float f6 = 1.0f - g;
                matrices.method_49278(class_7833.field_40716.rotation(f5 * f6), 0.5f, 0.0f, 0.5f);
            }
        }
        if (ancientPotBlockEntity instanceof AncientPotBlockEntity) {
            AncientPotBlockEntity decor = ancientPotBlockEntity;
            class_4588 vertexconsumer = this.baseMaterial.method_24145(vertexConsumerProvider, class_1921::method_23572);
            this.neck.method_22698(matrices, vertexconsumer, i, j);
            this.top.method_22698(matrices, vertexconsumer, i, j);
            this.bottom.method_22698(matrices, vertexconsumer, i, j);
            AncientPotBlockEntity.AncientPotDecorations potDecorations = decor.getSherds();
            this.renderDecoratedSide(this.frontSide, matrices, vertexConsumerProvider, i, j, AncientPotBlockEntityRenderer.getTextureIdFromSherd(potDecorations.front()));
            this.renderDecoratedSide(this.backSide, matrices, vertexConsumerProvider, i, j, AncientPotBlockEntityRenderer.getTextureIdFromSherd(potDecorations.back()));
            this.renderDecoratedSide(this.leftSide, matrices, vertexConsumerProvider, i, j, AncientPotBlockEntityRenderer.getTextureIdFromSherd(potDecorations.left()));
            this.renderDecoratedSide(this.rightSide, matrices, vertexConsumerProvider, i, j, AncientPotBlockEntityRenderer.getTextureIdFromSherd(potDecorations.right()));
            matrices.method_22909();
        }
    }

    private void renderDecoratedSide(class_630 part, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_4730 textureId) {
        part.method_22698(matrices, textureId.method_24145(vertexConsumers, class_1921::method_23572), light, overlay);
    }
}

