/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.client;

import net.j677.adventuresmod.entity.client.RunestoneGolemEntityModel;
import net.j677.adventuresmod.entity.custom.RunestoneGolemEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class RunestoneGolemDeathRenderer
extends class_3887<RunestoneGolemEntity, RunestoneGolemEntityModel<RunestoneGolemEntity>> {
    private static final class_2960 EXPLOSION_TEXTURE = class_2960.method_60655((String)"adventuresmod", (String)"textures/entity/golem/runestone_golem_exploding.png");
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private final RunestoneGolemEntityModel<RunestoneGolemEntity> model;

    public RunestoneGolemDeathRenderer(class_5617.class_5618 context, class_3883<RunestoneGolemEntity, RunestoneGolemEntityModel<RunestoneGolemEntity>> featureRendererContext) {
        super(featureRendererContext);
        this.model = new RunestoneGolemEntityModel(context.method_32167(RunestoneGolemEntityModel.LAYER_LOCATION));
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, RunestoneGolemEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        this.model.setAngles(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        if (entity.ticksSinceDeath > 0) {
            float k = (float)entity.ticksSinceDeath / 100.0f;
            int l = class_5253.class_5254.method_58144((int)class_3532.method_15375((float)(k * 255.0f)), (int)-1);
            class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23573((class_2960)EXPLOSION_TEXTURE));
            this.model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, l);
        }
        if (entity.ticksSinceDeath > 0) {
            float m = ((float)entity.ticksSinceDeath + tickDelta) / 100.0f;
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, 0.0f);
            RunestoneGolemDeathRenderer.renderDeathAnimation(matrices, m, vertexConsumers.getBuffer(class_1921.method_61046()));
            RunestoneGolemDeathRenderer.renderDeathAnimation(matrices, m, vertexConsumers.getBuffer(class_1921.method_61157()));
            matrices.method_22909();
        }
    }

    private static void renderDeathAnimation(class_4587 matrices, float animationProgress, class_4588 vertexCOnsumer) {
        matrices.method_22903();
        float f = Math.min(animationProgress > 0.8f ? (animationProgress - 0.8f) / 0.2f : 0.0f, 1.0f);
        int i = class_5253.class_5254.method_59554((float)(1.0f - f), (float)1.0f, (float)1.0f, (float)1.0f);
        class_5819 random = class_5819.method_43049((long)432L);
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Quaternionf quaternionf = new Quaternionf();
        int k = class_3532.method_15375((float)((animationProgress + animationProgress * animationProgress) / 2.0f * 60.0f));
        for (int l = 0; l < k; ++l) {
            quaternionf.rotationXYZ(random.method_43057() * ((float)Math.PI * 2), random.method_43057() * ((float)Math.PI * 2), random.method_43057() * ((float)Math.PI * 2)).rotateXYZ(random.method_43057() * ((float)Math.PI * 2), random.method_43057() * ((float)Math.PI * 2), random.method_43057() * ((float)Math.PI * 2) + animationProgress * 1.5707964f);
            matrices.method_22907(quaternionf);
            float g = random.method_43057() * 20.0f + 5.0f + f * 10.0f;
            float h = random.method_43057() * 2.0f + 1.0f + f * 2.0f;
            vector3f2.set(-HALF_SQRT_3 * h, g, -0.5f * h);
            vector3f3.set(HALF_SQRT_3 * h, g, -0.5f * h);
            vector3f4.set(0.0f, g, h);
            class_4587.class_4665 entry = matrices.method_23760();
            vertexCOnsumer.method_61032(entry, vector3f).method_39415(i);
            vertexCOnsumer.method_61032(entry, vector3f2).method_39415(1564211);
            vertexCOnsumer.method_61032(entry, vector3f3).method_39415(1564211);
            vertexCOnsumer.method_61032(entry, vector3f).method_39415(i);
            vertexCOnsumer.method_61032(entry, vector3f3).method_39415(1564211);
            vertexCOnsumer.method_61032(entry, vector3f4).method_39415(1564211);
            vertexCOnsumer.method_61032(entry, vector3f).method_39415(i);
            vertexCOnsumer.method_61032(entry, vector3f4).method_39415(1564211);
            vertexCOnsumer.method_61032(entry, vector3f2).method_39415(1564211);
        }
        matrices.method_22909();
    }
}

