/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.client;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.j677.adventuresmod.block.StoneChestPatterns;
import net.j677.adventuresmod.block.entity.StoneChestBlockEntity;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_4739;
import net.minecraft.class_5321;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class StoneChestBlockEntityRenderer<T extends StoneChestBlockEntity>
implements class_827<T> {
    public static final class_5601 LAYER_LOCATION = new class_5601(class_2960.method_60655((String)"adventuresmod", (String)"stone_chest"), "main");
    private final class_630 lid;
    private final class_630 bottom;
    public static final Map<class_5321<String>, class_4730> CHEST_SPRITE_IDENTIFIER = StoneChestPatterns.patterns().collect(Collectors.toMap(Function.identity(), StoneChestBlockEntityRenderer::createChestMaterial));
    private static final class_4730 chestSprite = Objects.requireNonNull(StoneChestBlockEntityRenderer.getStoneChestTextureId(StoneChestPatterns.SILENT));

    public StoneChestBlockEntityRenderer(class_5614.class_5615 ctx) {
        class_630 modelpart = ctx.method_32140(LAYER_LOCATION);
        this.bottom = modelpart.method_32086("bottom");
        this.lid = modelpart.method_32086("lid");
    }

    public static class_5607 createBodyLayer() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("bottom", class_5606.method_32108().method_32101(0, 19).method_32097(0.0f, 0.0f, 1.0f, 16.0f, 10.0f, 14.0f), class_5603.field_27701);
        modelPartData.method_32117("lid", class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, 0.0f, 0.0f, 16.0f, 5.0f, 14.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64);
    }

    private static class_4730 getTextureIdFromSlate(Optional<class_1792> slate) {
        class_4730 spriteIdentifier;
        if (slate.isPresent() && (spriteIdentifier = StoneChestBlockEntityRenderer.getStoneChestTextureId(StoneChestPatterns.fromSlate(slate.get()))) != null) {
            return spriteIdentifier;
        }
        return chestSprite;
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        boolean bl = world != null;
        class_2680 blockState = bl ? entity.method_11010() : (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_4739) {
            class_4739 abstractChestBlock = (class_4739)block;
            matrices.method_22903();
            float f = ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-f));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            class_4732.class_4734 propertySource = bl ? abstractChestBlock.method_24167(blockState, world, entity.method_11016(), true) : class_4732.class_3923::method_24174;
            float g = ((Float2FloatFunction)propertySource.apply(class_2281.method_24166(entity))).get(tickDelta);
            g = 1.0f - g;
            g = 1.0f - g * g * g;
            int i = ((Int2IntFunction)propertySource.apply((class_4732.class_3923)new class_4737())).applyAsInt(light);
            StoneChestBlockEntity.StoneChestDecorations slates = ((StoneChestBlockEntity)((Object)entity)).getSlates();
            this.renderBottom(this.bottom, matrices, vertexConsumers, i, overlay, StoneChestBlockEntityRenderer.getTextureIdFromSlate(slates.body()));
            this.renderLid(this.lid, matrices, vertexConsumers, g, i, overlay, StoneChestBlockEntityRenderer.getTextureIdFromSlate(slates.lid()));
            matrices.method_22909();
        }
    }

    private void renderBottom(class_630 base, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_4730 textureId) {
        base.method_22698(matrices, textureId.method_24145(vertexConsumers, class_1921::method_23572), light, overlay);
    }

    private void renderLid(class_630 lid, class_4587 matrices, class_4597 vertexConsumers, float openFactor, int light, int overlay, class_4730 textureId) {
        lid.field_3654 = -(openFactor * 1.5707964f);
        lid.method_22698(matrices, textureId.method_24145(vertexConsumers, class_1921::method_23572), light, overlay);
    }

    @Nullable
    public static class_4730 getStoneChestTextureId(@Nullable class_5321<String> name) {
        return name == null ? null : CHEST_SPRITE_IDENTIFIER.get(name);
    }

    private static class_4730 createChestMaterial(class_5321<String> name) {
        return new class_4730(class_2960.method_60656((String)"textures/atlas/chest.png"), StoneChestPatterns.identifier(name));
    }
}

