/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.google.common.collect.Sets;
import com.mojang.serialization.Dynamic;
import java.util.LinkedHashSet;
import net.j677.adventuresmod.entity.brain.ArchaicBrain;
import net.j677.adventuresmod.item.AdventureItems;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5146;
import net.minecraft.class_5147;
import net.minecraft.class_5275;
import net.minecraft.class_5425;
import net.minecraft.class_5630;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7248;
import org.jetbrains.annotations.Nullable;

public class ArchaicEntity
extends class_1496
implements class_1265,
class_7248,
class_5146,
class_5147 {
    private static final class_2940<Integer> BOOST_TIME = class_2945.method_12791(ArchaicEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> DASHING = class_2945.method_12791(ArchaicEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHEARED = class_2945.method_12791(ArchaicEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SADDLED = class_2945.method_12791(ArchaicEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CHEST = class_2945.method_12791(ArchaicEntity.class, (class_2941)class_2943.field_13323);
    private int dashCooldown = 0;

    public ArchaicEntity(class_1299<? extends ArchaicEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.field_6207 = new class_1331((class_1308)this, 10, true);
    }

    public static boolean canSpawn(class_1299<ArchaicEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(class_3481.field_35567) && ArchaicEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    public static class_5132.class_5133 createCloudSwimmerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23720, (double)0.1f).method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_23717, 16.0);
    }

    protected class_4095.class_5303<ArchaicEntity> method_28306() {
        return ArchaicBrain.createProfile();
    }

    protected void method_5959() {
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return ArchaicBrain.create((class_4095<ArchaicEntity>)this.method_28306().method_28335(dynamic));
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("archaicBrain");
        class_4095 brain = this.method_18868();
        brain.method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("archaicActivityUpdate");
        ArchaicBrain.updateActivities(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public void method_5773() {
        super.method_5773();
        if (this.isDashing() && this.dashCooldown < 50 && (this.method_52535() || this.method_5765())) {
            this.setDashing(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
        }
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407(this, (class_1308)this, world){

            public boolean method_6333(class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215();
            }
        };
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(true);
        birdNavigation.method_6331(false);
        return birdNavigation;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5787()) {
            if (this.method_5799()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)0.8f));
            } else if (this.method_5771()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.5));
            } else {
                this.method_5724(this.method_6029(), movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)0.71f));
            }
        }
        this.method_29242(false);
    }

    protected class_3414 method_5994() {
        return AdventureSounds.ENTITY_ARCHAIC_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return AdventureSounds.ENTITY_ARCHAIC_HURT;
    }

    public class_3414 method_45328() {
        return AdventureSounds.ENTITY_ARCHAIC_SADDLE;
    }

    protected class_3414 method_6002() {
        return AdventureSounds.ENTITY_ARCHAIC_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_42593, 1.0f, 1.0f);
    }

    public void method_5674(class_2940<?> data) {
        if (this.method_6725()) {
            this.field_6011.method_12778(SADDLED, (Object)true);
        }
        if (!this.field_5953 && DASHING.equals(data)) {
            this.dashCooldown = this.dashCooldown == 0 ? 55 : this.dashCooldown;
        }
        super.method_5674(data);
    }

    public void method_6155(int height) {
        this.method_32876((class_6880)class_5712.field_45148);
        this.setDashing(true);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(BOOST_TIME, (Object)0);
        builder.method_56912(CHEST, (Object)false);
        builder.method_56912(DASHING, (Object)false);
        builder.method_56912(SADDLED, (Object)false);
        builder.method_56912(SHEARED, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Sheared", this.isSheared());
        nbt.method_10556("ChestedArchaic", this.hasChest());
        if (this.hasChest()) {
            class_2499 nbtList = new class_2499();
            for (int i = 1; i < this.field_6962.method_5439(); ++i) {
                class_1799 itemStack = this.field_6962.method_5438(i);
                if (itemStack.method_7960()) continue;
                class_2487 nbtCompound = new class_2487();
                nbtCompound.method_10567("Slot", (byte)(i - 1));
                nbtList.add((Object)itemStack.method_57376((class_7225.class_7874)this.method_56673(), (class_2520)nbtCompound));
            }
            nbt.method_10566("Items", (class_2520)nbtList);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasChest(nbt.method_10577("ChestedArchaic"));
        this.setSheared(nbt.method_10577("Sheared"));
        this.method_6721();
        if (this.hasChest()) {
            class_2499 nbtList = nbt.method_10554("Items", 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound = nbtList.method_10602(i);
                int j = nbtCompound.method_10571("Slot") & 0xFF;
                if (j >= this.field_6962.method_5439() - 1) continue;
                this.field_6962.method_5447(j + 1, class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbtCompound).orElse(class_1799.field_8037));
            }
        }
        this.method_56679();
    }

    public boolean method_6765() {
        return this.method_5805() && this.isSheared();
    }

    public void setSheared(boolean sheared) {
        this.field_6011.method_12778(SHEARED, (Object)sheared);
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(SHEARED);
    }

    public boolean method_27072() {
        return this.method_5805() && !this.isSheared();
    }

    public boolean hasChest() {
        return (Boolean)this.field_6011.method_12789(CHEST);
    }

    public void setHasChest(boolean hasChest) {
        this.field_6011.method_12778(CHEST, (Object)hasChest);
    }

    protected class_243 method_52533(class_1297 passenger, class_4048 dimensions, float scaleFactor) {
        int i = Math.max(this.method_5685().indexOf(passenger), 0);
        boolean bl = i == 0;
        float f = 0.5f;
        float g = (float)(this.method_31481() ? (double)0.01f : this.getPassengerAttachmentY(dimensions, scaleFactor));
        if (this.method_5685().size() > 1) {
            if (!bl) {
                f = -0.7f;
            }
            if (passenger instanceof class_1429) {
                f += 0.2f;
            }
        }
        return new class_243(0.0, (double)g, (double)(f * scaleFactor)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
    }

    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this);
    }

    @Nullable
    public class_1309 method_5642() {
        class_1657 playerEntity;
        class_1297 class_12972;
        return this.method_6725() && (class_12972 = this.method_31483()) instanceof class_1657 && (playerEntity = (class_1657)class_12972).method_24518(AdventureItems.TANGERINE) ? playerEntity : super.method_5642();
    }

    protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
        this.method_5710(controllingPlayer.method_36454(), controllingPlayer.method_36455() * 0.5f);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
        if (this.method_5787()) {
            if (movementInput.field_1350 <= 0.0) {
                this.field_6975 = 0;
            }
            if (this.field_6976 > 0.0f) {
                this.method_45343(this.field_6976, movementInput);
            }
            this.field_6976 = 0.0f;
        }
        super.method_49481(controllingPlayer, movementInput);
    }

    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        return new class_243(0.0, (double)controllingPlayer.method_58149().method_10164(), 1.0);
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243[] vec3ds = new class_243[]{ArchaicEntity.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)passenger.method_36454()), ArchaicEntity.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(passenger.method_36454() - 22.5f)), ArchaicEntity.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(passenger.method_36454() + 22.5f)), ArchaicEntity.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(passenger.method_36454() - 45.0f)), ArchaicEntity.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(passenger.method_36454() + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d = this.method_5829().field_1325;
        double e = this.method_5829().field_1322 - 0.5;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_243 vec3d : vec3ds) {
            mutable.method_10102(this.method_23317() + vec3d.field_1352, d, this.method_23321() + vec3d.field_1350);
            for (double f = d; f > e; f -= 1.0) {
                set.add(mutable.method_10062());
                mutable.method_10098(class_2350.field_11033);
            }
        }
        for (class_2338 blockPos : set) {
            double g;
            if (this.method_37908().method_8316(blockPos).method_15767(class_3486.field_15518) || !class_5275.method_27932((double)(g = this.method_37908().method_30347(blockPos)))) continue;
            class_243 vec3d2 = class_243.method_26410((class_2382)blockPos, (double)g);
            for (class_4050 entityPose : passenger.method_24831()) {
                class_238 box = passenger.method_24833(entityPose);
                if (!class_5275.method_27933((class_1941)this.method_37908(), (class_1309)passenger, (class_238)box.method_997(vec3d2))) continue;
                passenger.method_18380(entityPose);
                return vec3d2;
            }
        }
        return new class_243(this.method_23317(), this.method_5829().field_1325, this.method_23321());
    }

    protected void method_6726(class_1657 player) {
        if (this.isSheared()) {
            super.method_6726(player);
        }
    }

    private double getPassengerAttachmentY(class_4048 dimensions, float scaleFactor) {
        return dimensions.comp_2186() - 0.175f * scaleFactor;
    }

    public class_243 method_45321(float tickDelta) {
        class_4048 entityDimensions = this.method_18377(this.method_18376());
        float f = this.method_17825();
        return new class_243(0.0, this.getPassengerAttachmentY(entityDimensions, f) - (double)(0.2f * f), (double)(entityDimensions.comp_2185() * 0.56f));
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() <= 2;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.6f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    protected float method_5867() {
        return this.field_5994 + 0.6f;
    }

    protected boolean method_26323() {
        return true;
    }

    protected void method_16078() {
        super.method_16078();
        if (this.method_6725()) {
            this.method_5706((class_1935)class_1802.field_8175);
        }
        if (this.hasChest()) {
            if (!this.method_37908().field_9236) {
                this.method_5706((class_1935)class_2246.field_10034);
            }
            this.setHasChest(false);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_5782() && !player.method_21823()) {
            class_1799 itemStack = player.method_5998(hand);
            if (!itemStack.method_7960()) {
                if (this.isSheared() && !this.hasChest() && itemStack.method_31574(class_1802.field_8106)) {
                    this.addChest(player, itemStack);
                    return class_1269.method_29236((boolean)this.method_37908().field_9236);
                }
                if (itemStack.method_31574(class_1802.field_8868) && !this.method_37908().field_9236 && this.method_27072()) {
                    this.method_6636(class_3419.field_15248);
                    this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                    itemStack.method_7970(1, (class_1309)player, ArchaicEntity.method_56079((class_1268)hand));
                    return class_1269.field_5812;
                }
            }
        } else {
            if (this.isSheared() && this.method_5685().size() < 2) {
                this.method_6726(player);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(class_3419 shearedSoundCategory) {
        this.method_37908().method_43129(null, (class_1297)this, AdventureSounds.ENTITY_ARCHAIC_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.field_5974.method_43048(3);
        for (int j = 0; j < i; ++j) {
            class_1542 itemEntity = this.method_5706((class_1935)class_1802.field_28654);
            if (itemEntity == null) continue;
            itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
        }
    }

    public class_5630 method_32318(int mappedIndex) {
        return mappedIndex == 499 ? new class_5630(){

            public class_1799 method_32327() {
                return ArchaicEntity.this.hasChest() ? new class_1799((class_1935)class_1802.field_8106) : class_1799.field_8037;
            }

            public boolean method_32332(class_1799 stack) {
                if (stack.method_7960()) {
                    if (ArchaicEntity.this.hasChest()) {
                        ArchaicEntity.this.setHasChest(false);
                        ArchaicEntity.this.method_6721();
                    }
                    return true;
                }
                if (stack.method_31574(class_1802.field_8106)) {
                    if (!ArchaicEntity.this.hasChest()) {
                        ArchaicEntity.this.setHasChest(true);
                        ArchaicEntity.this.method_6721();
                    }
                    return true;
                }
                return false;
            }
        } : super.method_32318(mappedIndex);
    }

    private void addChest(class_1657 player, class_1799 chest) {
        this.setHasChest(true);
        this.playAddChestSound();
        chest.method_57008(1, (class_1309)player);
        this.method_6721();
    }

    protected void playAddChestSound() {
        this.method_5783(AdventureSounds.ENTITY_ARCHAIC_CHEST, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
    }

    public int method_6702() {
        return this.hasChest() ? 5 : 0;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        ArchaicBrain.initialize(this, world.method_8409());
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public boolean method_6727() {
        return true;
    }

    protected boolean method_6734() {
        return false;
    }

    public boolean method_6109() {
        return false;
    }

    public void method_6154(int strength) {
        if (this.method_6725() && this.dashCooldown <= 0) {
            super.method_6154(strength);
        }
    }

    public boolean method_48155() {
        return true;
    }

    protected void method_45343(float strength, class_243 movementInput) {
        this.method_45319(this.method_5720().method_18805(1.0, 0.0, 1.0).method_1029().method_1021((double)(5.2222f * strength) * (double)this.method_23326()));
        this.dashCooldown = 55;
        this.setDashing(true);
        this.field_6007 = true;
    }

    public boolean isDashing() {
        return (Boolean)this.field_6011.method_12789(DASHING);
    }

    public void setDashing(boolean dashing) {
        this.field_6011.method_12778(DASHING, (Object)dashing);
    }

    public int method_45327() {
        return this.dashCooldown;
    }
}

