/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import java.util.Objects;
import java.util.Optional;
import net.j677.adventuresmod.effect.AdventureStatusEffects;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.item.AdventureItems;
import net.j677.adventuresmod.particle.AdventureParticles;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5362;
import net.minecraft.class_9749;
import org.jetbrains.annotations.Nullable;

public class ConjuringTridentEntity
extends class_1665 {
    private static final class_2940<Byte> LOYALTY = class_2945.method_12791(ConjuringTridentEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> ENCHANTED = class_2945.method_12791(ConjuringTridentEntity.class, (class_2941)class_2943.field_13323);
    public static final class_5362 EXPLOSION_BEHAVIOR = new class_9749(false, true, Optional.of(Float.valueOf(0.0f)), Optional.empty());
    private boolean dealtDamage;
    public int returnTimer;

    public ConjuringTridentEntity(class_1299<? extends ConjuringTridentEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ConjuringTridentEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(AdventureEntityTypes.CONJURING_TRIDENT, owner, world, stack, null);
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(stack));
        this.field_6011.method_12778(ENCHANTED, (Object)stack.method_7958());
    }

    public ConjuringTridentEntity(class_1937 world, double x, double y, double z, class_1799 stack) {
        super(AdventureEntityTypes.CONJURING_TRIDENT, x, y, z, world, stack, stack);
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(stack));
        this.field_6011.method_12778(ENCHANTED, (Object)stack.method_7958());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LOYALTY, (Object)0);
        builder.method_56912(ENCHANTED, (Object)false);
    }

    public void method_5773() {
        if (this.field_7576 > 4) {
            this.dealtDamage = true;
        }
        class_1297 entity = this.method_24921();
        byte i = (Byte)this.field_6011.method_12789(LOYALTY);
        if (i > 0 && (this.dealtDamage || this.method_7441()) && entity != null) {
            if (!this.isOwnerAlive()) {
                if (!this.method_37908().field_9236 && this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(this.method_7445(), 0.1f);
                }
                this.method_31472();
            } else {
                this.method_7433(true);
                class_243 vec3d = entity.method_33571().method_1020(this.method_19538());
                this.method_23327(this.method_23317(), this.method_23318() + vec3d.field_1351 * 0.015 * (double)i, this.method_23321());
                if (this.method_37908().field_9236) {
                    this.field_5971 = this.method_23318();
                }
                double d = 0.05 * (double)i;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
                if (this.returnTimer == 0) {
                    this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
                }
                ++this.returnTimer;
            }
        }
        super.method_5773();
    }

    private boolean isOwnerAlive() {
        class_1297 entity = this.method_24921();
        return entity != null && entity.method_5805() && (!(entity instanceof class_3222) || !entity.method_7325());
    }

    public boolean isEnchanted() {
        return (Boolean)this.field_6011.method_12789(ENCHANTED);
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_3218 serverWorld;
        class_1297 entity = entityHitResult.method_17782();
        float f = 8.0f;
        class_1297 entity2 = this.method_24921();
        class_1282 damageSource = this.method_48923().method_48799((class_1297)this, (class_1297)(entity2 == null ? this : entity2));
        Object object = this.method_37908();
        if (object instanceof class_3218) {
            serverWorld = (class_3218)object;
            f = class_1890.method_60120((class_3218)serverWorld, (class_1799)Objects.requireNonNull(this.method_59958()), (class_1297)entity, (class_1282)damageSource, (float)f);
        }
        this.dealtDamage = true;
        if (entity.method_5643(damageSource, f)) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            object = this.method_37908();
            if (object instanceof class_3218) {
                serverWorld = (class_3218)object;
                class_1890.method_60619((class_3218)serverWorld, (class_1297)entity, (class_1282)damageSource, (class_1799)this.method_59958());
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                this.method_59957(livingEntity, damageSource);
                this.method_7450(livingEntity);
                for (class_1309 nearbyEntities : livingEntity.method_37908().method_8390(class_1309.class, entity.method_5829().method_1014(2.0), class_1301.field_6156)) {
                    if (nearbyEntities == entity2) continue;
                    double x = nearbyEntities.method_23317();
                    double y = nearbyEntities.method_23318() + (double)(nearbyEntities.method_17682() / 2.0f);
                    double z = nearbyEntities.method_23321();
                    nearbyEntities.method_6092(new class_1293(AdventureStatusEffects.CONDUCTING, 100));
                    livingEntity.method_37908().method_8454(entity, entity.method_48923().method_48809(), EXPLOSION_BEHAVIOR, x, y, z, 0.5f, false, class_1937.class_7867.field_51779, (class_2394)AdventureParticles.ION, (class_2394)AdventureParticles.ION, AdventureSounds.ITEM_CONJURING_TRIDENT_ZAP);
                }
            }
        }
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        this.method_5783(class_3417.field_15213, 1.0f, 1.0f);
    }

    protected void method_59956(class_3218 world, class_3965 blockHitResult, class_1799 weaponStack) {
        class_1309 livingEntity;
        class_243 vec3d = blockHitResult.method_17777().method_60913(blockHitResult.method_17784());
        class_1297 class_12972 = this.method_24921();
        class_1890.method_60124((class_3218)world, (class_1799)weaponStack, (class_1309)(class_12972 instanceof class_1309 ? (livingEntity = (class_1309)class_12972) : null), (class_1297)this, null, (class_243)vec3d, (class_2680)world.method_8320(blockHitResult.method_17777()), item -> this.method_5768());
    }

    public class_1799 method_59958() {
        return this.method_54759();
    }

    protected boolean method_34713(class_1657 player) {
        return super.method_34713(player) || this.method_7441() && this.method_34714((class_1297)player) && player.method_31548().method_7394(this.method_7445());
    }

    protected class_1799 method_57314() {
        return new class_1799((class_1935)AdventureItems.CONJURING_TRIDENT);
    }

    protected class_3414 method_7440() {
        return class_3417.field_15104;
    }

    public void method_5694(class_1657 player) {
        if (this.method_34714((class_1297)player) || this.method_24921() == null) {
            super.method_5694(player);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.dealtDamage = nbt.method_10577("DealtDamage");
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(this.method_54759()));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("DealtDamage", this.dealtDamage);
    }

    private byte getLoyalty(class_1799 stack) {
        byte by;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            by = (byte)class_3532.method_15340((int)class_1890.method_60169((class_3218)serverWorld, (class_1799)stack, (class_1297)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    public void method_7446() {
        byte i = (Byte)this.field_6011.method_12789(LOYALTY);
        if (this.field_7572 != class_1665.class_1666.field_7593 || i <= 0) {
            super.method_7446();
        }
    }

    protected float method_7436() {
        return 0.99f;
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }
}

