/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.j677.adventuresmod.block.AdventureBlocks;
import net.j677.adventuresmod.entity.custom.AbstractDepartedEntity;
import net.j677.adventuresmod.entity.custom.SpearEntity;
import net.j677.adventuresmod.item.AdventureItems;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1339;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1379;
import net.minecraft.class_1380;
import net.minecraft.class_1381;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_3988;
import net.minecraft.class_4255;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class DepartedEntity
extends AbstractDepartedEntity
implements class_1603 {
    private static final class_2940<String> VARIANT = class_2945.method_12791(DepartedEntity.class, (class_2941)class_2943.field_13326);
    static final Predicate<class_1267> DIFFICULTY_ALLOWS_DOOR_BREAKING_PREDICATE = difficulty -> difficulty == class_1267.field_5802 || difficulty == class_1267.field_5807;

    public DepartedEntity(class_1299<? extends DepartedEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 10;
    }

    public static class_5132.class_5133 createDepartedAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23723, 0.7).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23724, 2.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new BreakDoorGoal((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_4255((class_1308)this, false));
        this.field_6201.method_6277(3, (class_1352)new class_1380((class_1588)this, 0.5, 20, 20.0f));
        this.field_6201.method_6277(4, (class_1352)new SpearAttackGoal(this, 1.0, 30, 10.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.6));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{AbstractDepartedEntity.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)Variant.BLADE_MASTER.name);
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        if (this.getVariant() == Variant.LANCER) {
            this.method_5673(class_1304.field_6173, new class_1799((class_1935)AdventureItems.COBALT_SPEAR));
        }
        if (this.getVariant() == Variant.ARCHER) {
            this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        }
        if (this.getVariant() == Variant.WARRIOR) {
            this.method_5673(class_1304.field_6173, new class_1799((class_1935)AdventureItems.COBALT_AXE));
        }
        if (this.getVariant() == Variant.BLADE_MASTER) {
            this.method_5673(class_1304.field_6173, new class_1799((class_1935)AdventureItems.COBALT_SWORD));
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Variant", this.getVariant().method_15434());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Variant.fromName(nbt.method_10558("Variant")));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.name);
    }

    public Variant getVariant() {
        return Variant.fromName((String)this.field_6011.method_12789(VARIANT));
    }

    public static boolean canSpawn(class_1299<DepartedEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return DepartedEntity.method_20681(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) && !world.method_8320(pos.method_10074()).method_27852(AdventureBlocks.ALCHESHROOM_BLOCK);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_5819 random = world.method_8409();
        this.setVariant(DepartedEntity.getRandomVariant(world.method_8409()));
        this.method_5964(random, difficulty);
        this.method_5984(world, random, difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public static Variant getRandomVariant(class_5819 random) {
        int i = random.method_43048(50);
        if (i < 5) {
            return Variant.LANCER;
        }
        if (i < 25) {
            return Variant.ARCHER;
        }
        if (i < 35) {
            return Variant.WARRIOR;
        }
        return Variant.BLADE_MASTER;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (this.getVariant() == Variant.LANCER) {
            SpearEntity spearEntity = new SpearEntity(this.method_37908(), (class_1309)this, new class_1799((class_1935)AdventureItems.COBALT_SPEAR));
            double d = target.method_23317() - this.method_23317();
            double e = target.method_23323(0.3333333333333333) - spearEntity.method_23318();
            double f = target.method_23321() - this.method_23321();
            double g = Math.sqrt(d * d + f * f);
            spearEntity.method_7485(d, e + g * (double)0.2f, f, 1.6f, 14 - this.method_37908().method_8407().method_5461() * 4);
            this.method_5783(AdventureSounds.ENTITY_DEPARTED_SHOOT_SPEAR, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
            this.method_37908().method_8649((class_1297)spearEntity);
        }
        if (this.getVariant() == Variant.ARCHER) {
            class_1799 itemStack = this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102));
            class_1799 itemStack2 = this.method_18808(itemStack);
            class_1665 persistentProjectileEntity = this.createArrowProjectile(itemStack2, pullProgress, itemStack);
            double d = target.method_23317() - this.method_23317();
            double e = target.method_23323(0.3333333333333333) - persistentProjectileEntity.method_23318();
            double f = target.method_23321() - this.method_23321();
            double g = Math.sqrt(d * d + f * f);
            persistentProjectileEntity.method_7485(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.method_37908().method_8407().method_5461() * 4));
            this.method_5783(AdventureSounds.ENTITY_DEPARTED_SHOOT_BOW, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
            this.method_37908().method_8649((class_1297)persistentProjectileEntity);
        }
    }

    protected class_1665 createArrowProjectile(class_1799 arrow, float damageModifier, @Nullable class_1799 shotFrom) {
        return class_1675.method_18813((class_1309)this, (class_1799)arrow, (float)damageModifier, (class_1799)shotFrom);
    }

    public boolean method_25938(class_1811 weapon) {
        return weapon == class_1802.field_8102;
    }

    static class BreakDoorGoal
    extends class_1339 {
        public BreakDoorGoal(class_1308 mobEntity) {
            super(mobEntity, 6, DIFFICULTY_ALLOWS_DOOR_BREAKING_PREDICATE);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6266() {
            return super.method_6266();
        }

        public boolean method_6264() {
            DepartedEntity departedEntity = (DepartedEntity)this.field_6413;
            return departedEntity.field_5974.method_43048(BreakDoorGoal.method_38848((int)10)) == 0 && super.method_6264();
        }

        public void method_6269() {
            super.method_6269();
            this.field_6413.method_16826(0);
        }
    }

    static class SpearAttackGoal
    extends class_1381 {
        private final DepartedEntity departed;

        public SpearAttackGoal(class_1603 rangedAttackMob, double v, int i, float f) {
            super(rangedAttackMob, v, i, f);
            this.departed = (DepartedEntity)rangedAttackMob;
        }

        public boolean method_6264() {
            return super.method_6264() && this.departed.method_6047().method_31574(AdventureItems.COBALT_SPEAR);
        }

        public void method_6269() {
            super.method_6269();
            this.departed.method_19540(true);
            this.departed.method_6019(class_1268.field_5808);
        }

        public void method_6270() {
            super.method_6270();
            this.departed.method_6021();
            this.departed.method_19540(false);
        }
    }

    public static enum Variant implements class_3542
    {
        BLADE_MASTER("blade_master"),
        WARRIOR("warrior"),
        ARCHER("archer"),
        LANCER("lancer");

        public static final class_3542.class_7292<Variant> CODEC;
        final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static Variant fromName(String name) {
            return (Variant)CODEC.method_47920(name, (Enum)BLADE_MASTER);
        }

        static {
            CODEC = class_3542.method_28140(Variant::values);
        }
    }
}

