/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.j677.adventuresmod.util.AdventureTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1403;
import net.minecraft.class_1404;
import net.minecraft.class_1406;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1531;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4174;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7995;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DevourerEntity
extends class_1321
implements class_5354 {
    private static final class_2940<Integer> ANGER_TIME = class_2945.method_12791(DevourerEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DEVOURER_TYPE = class_2945.method_12791(DevourerEntity.class, (class_2941)class_2943.field_13327);
    public static final Predicate<class_1309> FOLLOW_TAMED_PREDICATE = entity -> {
        class_1299 entityType = entity.method_5864();
        return entityType == AdventureEntityTypes.MYTHICAN_COW || entityType == AdventureEntityTypes.CHIMERIC || entityType == AdventureEntityTypes.FOREST_FAI;
    };
    private int attackAnimationTick;
    private int remainingPersistentAngerTime;
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    @Nullable
    private UUID angryAt;

    public DevourerEntity(class_1299<? extends DevourerEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_6173(false, false);
        this.field_6194 = 5;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(4, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 2.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, this::method_29515));
        this.field_6185.method_6277(5, (class_1352)new class_1404((class_1321)this, class_1429.class, false, FOLLOW_TAMED_PREDICATE));
        this.field_6185.method_6277(8, (class_1352)new class_5398((class_1308)this, true));
    }

    public static class_5132.class_5133 createDevourerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23721, 4.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ANGER_TIME, (Object)0);
        builder.method_56912(DEVOURER_TYPE, (Object)DevourerType.VERMILION.id);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("DevourerType", this.getVariant().id);
        this.method_29517(nbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(DevourerType.byId(nbt.method_10550("DevourerType")));
        this.method_29512(this.method_37908(), nbt);
    }

    public static boolean canSpawn(class_1299<DevourerEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(AdventureTags.Blocks.MYTHICA_SPAWNABLE_ON) && DevourerEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    public boolean method_29515(class_1309 entity) {
        return !this.method_6181() && !this.method_6109();
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public int method_5978() {
        return this.method_6172() ? 20 : super.method_5978();
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.method_37908().field_9236) {
            this.method_24346(false);
        }
        return super.method_5643(source, amount);
    }

    protected void method_56996() {
        if (this.method_6181()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(50.0);
            this.method_6033(50.0f);
        } else {
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(30.0);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (!this.method_37908().field_9236 || this.method_6109() && this.method_6481(itemStack)) {
            if (this.method_6181()) {
                if (this.method_6481(itemStack) && this.method_6032() < this.method_6063()) {
                    itemStack.method_57008(1, (class_1309)player);
                    class_4174 foodComponent = (class_4174)itemStack.method_57824(class_9334.field_50075);
                    float f = foodComponent != null ? (float)foodComponent.comp_2491() : 1.0f;
                    this.method_6025(2.0f * f);
                    return class_1269.method_29236((boolean)this.method_37908().method_8608());
                }
                class_1269 actionResult = super.method_5992(player, hand);
                if (!actionResult.method_23665() && this.method_6171((class_1309)player)) {
                    this.method_24346(!this.method_24345());
                    this.field_6282 = false;
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    return class_1269.field_51370;
                }
                return actionResult;
            }
            if (itemStack.method_31573(AdventureTags.Items.DEVOURER_FOOD) && !this.method_29511() && this.method_6109()) {
                itemStack.method_57008(1, (class_1309)player);
                this.tryTame(player);
                return class_1269.field_5812;
            }
            return super.method_5992(player, hand);
        }
        boolean bl = this.method_6171((class_1309)player) || this.method_6181() || itemStack.method_31573(AdventureTags.Items.DEVOURER_FOOD) && !this.method_6181() && !this.method_29511();
        return bl ? class_1269.field_21466 : class_1269.field_5811;
    }

    private void tryTame(class_1657 player) {
        if (this.field_5974.method_43048(3) == 0) {
            this.method_6170(player);
            this.field_6189.method_6340();
            this.method_5980(null);
            this.method_24346(true);
            this.method_37908().method_8421((class_1297)this, (byte)7);
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)6);
        }
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(AdventureTags.Items.DEVOURER_FOOD);
    }

    public int method_5945() {
        return 8;
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER_TIME);
    }

    public void method_29514(int angerTime) {
        this.field_6011.method_12778(ANGER_TIME, (Object)angerTime);
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public DevourerEntity createChild(class_3218 serverWorld, class_1296 passiveEntity) {
        DevourerEntity devourerEntity = (DevourerEntity)AdventureEntityTypes.DEVOURER.method_5883((class_1937)serverWorld);
        if (devourerEntity != null && passiveEntity instanceof DevourerEntity) {
            DevourerEntity devourerEntity2 = (DevourerEntity)passiveEntity;
            if (this.field_5974.method_43056()) {
                devourerEntity.setVariant(this.getVariant());
            } else {
                devourerEntity.setVariant(devourerEntity2.getVariant());
            }
            if (this.method_6181()) {
                devourerEntity.method_6174(this.method_6139());
                devourerEntity.method_6173(true, true);
            }
        }
        return devourerEntity;
    }

    public boolean method_6121(class_1297 target) {
        boolean bl = super.method_6121(target);
        if (bl && target instanceof class_1309) {
            this.attackAnimationTick = 40;
        }
        return bl;
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean method_6474(class_1429 other) {
        if (other == this) {
            return false;
        }
        if (!this.method_6181()) {
            return false;
        }
        if (!(other instanceof DevourerEntity)) {
            return false;
        }
        DevourerEntity devourerEntity = (DevourerEntity)other;
        if (!devourerEntity.method_6181()) {
            return false;
        }
        return !devourerEntity.method_6172() && this.method_6181() && devourerEntity.method_6181() && this.method_6479() && devourerEntity.method_6479();
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        class_1321 tameableEntity;
        class_1496 abstractHorseEntity;
        if (target instanceof class_1548 || target instanceof class_1571 || target instanceof class_1531) {
            return false;
        }
        if (target instanceof class_1493) {
            class_1493 devourerEntity = (class_1493)target;
            return !devourerEntity.method_6181() || devourerEntity.method_35057() != owner;
        }
        if (target instanceof class_1657) {
            class_1657 playerEntity2;
            class_1657 playerEntity = (class_1657)target;
            if (owner instanceof class_1657 && !(playerEntity2 = (class_1657)owner).method_7256(playerEntity)) {
                return false;
            }
        }
        if (target instanceof class_1496 && (abstractHorseEntity = (class_1496)target).method_6727()) {
            return false;
        }
        return !(target instanceof class_1321) || !(tameableEntity = (class_1321)target).method_6181();
    }

    public boolean method_5931() {
        return !this.method_29511();
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.6f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    protected class_3414 method_5994() {
        return AdventureSounds.ENTITY_DEVOURER_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return AdventureSounds.ENTITY_DEVOURER_HURT;
    }

    protected class_3414 method_6002() {
        return AdventureSounds.ENTITY_DEVOURER_DEATH;
    }

    public void method_59928() {
        this.method_5783(AdventureSounds.ENTITY_DEVOURER_BITE, 1.0f, 1.0f);
    }

    public DevourerType getVariant() {
        return DevourerType.byId((Integer)this.field_6011.method_12789(DEVOURER_TYPE));
    }

    public void setVariant(DevourerType devourerType) {
        this.field_6011.method_12778(DEVOURER_TYPE, (Object)devourerType.id);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        DevourerType devourerType = DevourerEntity.getTypeFromPos((class_1936)world, this.method_24515());
        if (entityData instanceof DevourerData) {
            devourerType = ((DevourerData)((Object)entityData)).type;
        } else {
            entityData = new DevourerData(devourerType);
        }
        this.setVariant(devourerType);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    private static DevourerType getTypeFromPos(class_1936 world, class_2338 pos) {
        class_6880 registryEntry = world.method_23753(pos);
        int i = world.method_8409().method_43048(100);
        if (registryEntry.method_40220(AdventureTags.Biomes.SPAWNS_SPOTTED_VARIANT_MYTHICAN_ANIMALS)) {
            return i < 60 ? DevourerType.VERMILION : DevourerType.SPOTTED;
        }
        if (registryEntry.method_40220(AdventureTags.Biomes.SPAWNS_PAINTED_VARIANT_MYTHICAN_ANIMALS)) {
            return DevourerType.PAINTED;
        }
        if (registryEntry.method_40220(AdventureTags.Biomes.SPAWNS_ROSE_VARIANT_MYTHICAN_ANIMALS)) {
            return DevourerType.ROSE;
        }
        return DevourerType.VERMILION;
    }

    public static enum DevourerType implements class_3542
    {
        VERMILION(0, "vermilion"),
        ROSE(1, "rose"),
        SPOTTED(2, "spotted"),
        PAINTED(3, "painted");

        private static final IntFunction<DevourerType> BY_ID;
        public static final Codec<DevourerType> CODEC;
        final int id;
        private final String name;

        private DevourerType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static DevourerType byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = class_7995.method_47915(DevourerType::getId, (Object[])DevourerType.values(), (Object)((Object)VERMILION));
            CODEC = class_3542.method_28140(DevourerType::values);
        }
    }

    public static class DevourerData
    extends class_1296.class_4697 {
        public final DevourerType type;

        public DevourerData(DevourerType type) {
            super(0.0f);
            this.type = type;
        }
    }
}

