/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.IntFunction;
import net.j677.adventuresmod.config.AdventurersBeyondConfig;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.brain.conjurer.DrownedConjurerBrain;
import net.j677.adventuresmod.entity.custom.ConjuredTridentEntity;
import net.j677.adventuresmod.entity.custom.DrownedVanguardEntity;
import net.j677.adventuresmod.entity.custom.NecromancerSpellEntity;
import net.j677.adventuresmod.item.AdventureItems;
import net.j677.adventuresmod.sound.AdventureBossMusic;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.j677.adventuresmod.util.AdventureTrackedDataListener;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1409;
import net.minecraft.class_1412;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2770;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7995;
import net.minecraft.class_8103;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class DrownedConjurerEntity
extends class_1588 {
    private static final class_2940<State> STATE = class_2945.method_12791(DrownedConjurerEntity.class, AdventureTrackedDataListener.DROWNED_CONJURER_STATE);
    private static final class_2940<Boolean> AWAKENED = class_2945.method_12791(DrownedConjurerEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 awakenAnimationState = new class_7094();
    public final class_7094 dormantAnimationState = new class_7094();
    public final class_7094 castingAnimationState = new class_7094();
    public final class_7094 conjureDrownedAnimationState = new class_7094();
    public final class_7094 conjureTridentsAnimationState = new class_7094();
    public final class_7094 conjureWhirlpoolAnimationState = new class_7094();
    public final class_7094 conjureBarrageAnimationState = new class_7094();
    public final class_7094 stunnedAnimationState = new class_7094();
    public final class_7094 tridentLodgeAnimationState = new class_7094();
    boolean targetingUnderwater;
    protected final class_1412 waterNavigation;
    protected final class_1409 landNavigation;
    public final class_5819 random = class_5819.method_43047();
    public final class_3213 bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5791).method_5410(true);

    public DrownedConjurerEntity(class_1299<? extends DrownedConjurerEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6011.method_12778(STATE, (Object)this.getState());
        this.field_6207 = new ConjurerMoveControl(this);
        this.method_5941(class_7.field_18, 0.0f);
        this.waterNavigation = new class_1412((class_1308)this, world);
        this.landNavigation = new class_1409((class_1308)this, world);
        this.field_6194 = 250;
    }

    public static class_5132.class_5133 createConjurerAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, (double)AdventurersBeyondConfig.DROWNED_CONJURER_MAX_HEALTH).method_26868(class_5134.field_23724, 3.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_47761, 1.0).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23721, 3.5).method_26868(class_5134.field_23718, 2.0).method_26868(class_5134.field_23717, 35.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STATE, (Object)State.STANDING);
        builder.method_56912(AWAKENED, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("IsAwakened", this.isAwakened());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        this.setAwakened(nbt.method_10577("IsAwakened"));
    }

    public void setAwakened(boolean bl) {
        this.field_6011.method_12778(AWAKENED, (Object)bl);
    }

    public boolean isAwakened() {
        return (Boolean)this.field_6011.method_12789(AWAKENED);
    }

    public State getState() {
        return (State)((Object)this.field_6011.method_12789(STATE));
    }

    public DrownedConjurerEntity setState(State state) {
        this.field_6011.method_12778(STATE, (Object)state);
        return this;
    }

    public boolean isInState(State state) {
        return this.getState() == state;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public boolean method_5722(class_1297 other) {
        if (super.method_5722(other)) {
            return true;
        }
        return other instanceof DrownedVanguardEntity;
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
        player.field_13987.method_14364((class_2596)new class_2770(((class_3414)AdventureBossMusic.SHEAR_FLOW.method_27279().comp_349()).method_14833(), class_3419.field_15253));
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.isAwakened()) {
            DrownedConjurerBrain.setArenaCenterPos(this);
            this.startState(State.AWAKEN);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_5674(class_2940<?> data) {
        if (STATE.equals(data)) {
            State state = this.getState();
            this.stopAnimations();
            switch (state.ordinal()) {
                case 1: {
                    this.awakenAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 2: {
                    this.castingAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 3: {
                    this.conjureDrownedAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 5: {
                    this.conjureTridentsAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 4: {
                    this.conjureWhirlpoolAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 6: {
                    this.conjureBarrageAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 8: {
                    this.stunnedAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 9: {
                    this.tridentLodgeAnimationState.method_41324(this.field_6012);
                }
            }
            this.method_18382();
        }
        super.method_5674(data);
    }

    private void stopAnimations() {
        this.awakenAnimationState.method_41325();
        this.castingAnimationState.method_41325();
        this.conjureDrownedAnimationState.method_41325();
        this.conjureTridentsAnimationState.method_41325();
        this.conjureWhirlpoolAnimationState.method_41325();
        this.conjureBarrageAnimationState.method_41325();
        this.stunnedAnimationState.method_41325();
        this.tridentLodgeAnimationState.method_41325();
    }

    public void startState(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.setState(State.STANDING);
                break;
            }
            case 1: {
                this.setState(State.AWAKEN);
                break;
            }
            case 4: {
                this.setState(State.CONJURE_WHIRLPOOLS);
                break;
            }
            case 8: {
                this.setState(State.STUNNED);
                this.method_18868().method_24525(AdventureMemoryModuleTypes.STUNNED, (Object)class_3902.field_17274, 150L);
                break;
            }
            case 9: {
                this.setState(State.TRIDENT_LODGE);
            }
        }
    }

    protected class_4095.class_5303<DrownedConjurerEntity> method_28306() {
        return class_4095.method_28311(DrownedConjurerBrain.MEMORY_MODULES, DrownedConjurerBrain.SENSORS);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return DrownedConjurerBrain.create(this, (class_4095<DrownedConjurerEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<DrownedConjurerEntity> method_18868() {
        return super.method_18868();
    }

    public boolean isWithinShortRange(class_243 pos) {
        class_243 vec3d = this.method_24515().method_46558();
        return pos.method_55230(vec3d, 4.0, 10.0);
    }

    public Optional<class_1309> getHurtBy() {
        return this.method_18868().method_18904(class_4140.field_18451).map(class_1282::method_5529).filter(attacker -> attacker instanceof class_1309).map(livingAttacker -> (class_1309)livingAttacker);
    }

    protected void method_5958() {
        super.method_5958();
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        this.method_37908().method_16107().method_15396("drownedConjurerBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        DrownedConjurerBrain.tick(this);
        super.method_5958();
    }

    public void method_5773() {
        if (this.method_37908().method_8608()) {
            this.dormantAnimationState.method_45317(!this.isAwakened() && this.getState() != State.AWAKEN, this.field_6012);
        }
        super.method_5773();
    }

    protected void method_48565(float posDelta) {
        float f = Math.min(posDelta * 25.0f, 1.0f);
        this.field_42108.method_48568(f, 0.4f);
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public boolean method_5679(class_1282 damageSource) {
        return !this.isAwakened() && !damageSource.method_48789(class_8103.field_42242) || super.method_5679(damageSource);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 entity = source.method_5526();
        if (entity instanceof NecromancerSpellEntity || entity instanceof ConjuredTridentEntity) {
            return false;
        }
        if (source == this.method_48923().method_48809()) {
            return false;
        }
        if (!this.isInState(State.STUNNED) && !source.method_48789(class_8103.field_42242)) {
            if (amount > 5.0f) {
                return super.method_5643(source, 5.0f);
            }
            return super.method_5643(source, amount);
        }
        return super.method_5643(source, amount);
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5787() && this.method_5799() && this.isTargetingUnderwater()) {
            this.method_5724(0.01f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(movementInput);
        }
    }

    public boolean method_5810() {
        return this.isAwakened();
    }

    boolean isTargetingUnderwater() {
        if (this.targetingUnderwater) {
            return true;
        }
        class_1309 livingEntity = this.method_5968();
        return livingEntity != null && livingEntity.method_5799();
    }

    public void method_5790() {
        if (!this.method_37908().field_9236) {
            if (this.method_6034() && this.method_5799() && this.isTargetingUnderwater()) {
                this.field_6189 = this.waterNavigation;
                this.method_5796(true);
            } else {
                this.field_6189 = this.landNavigation;
                this.method_5796(false);
            }
        }
    }

    public boolean method_20232() {
        return this.method_5681();
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.bossBar.method_5410(true);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        super.method_6099(world, source, causedByPlayer);
        int i = 1 + this.random.method_43048(2);
        for (int j = 0; j < i; ++j) {
            class_1542 itemEntity = this.method_5706((class_1935)AdventureItems.NECROMANTIC_ROD);
            if (itemEntity == null) continue;
            itemEntity.method_5834(true);
            itemEntity.method_6976();
        }
        int k = 1 + this.random.method_43048(2);
        for (int j = 0; j < k; ++j) {
            class_1542 itemEntity = this.method_5706((class_1935)AdventureItems.CONJURING_COPPER);
            if (itemEntity == null) continue;
            itemEntity.method_5834(true);
            itemEntity.method_6976();
        }
        class_1542 itemEntity = this.method_5706((class_1935)AdventureItems.FORESIGHT_JEWEL);
        if (itemEntity != null) {
            itemEntity.method_5834(true);
            itemEntity.method_6976();
        }
    }

    protected class_3414 method_5994() {
        return AdventureSounds.ENTITY_DROWNED_CONJURER_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return AdventureSounds.ENTITY_DROWNED_CONJURER_HURT;
    }

    protected class_3414 method_6002() {
        return AdventureSounds.ENTITY_DROWNED_CONJURER_DEATH;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public void method_5982() {
    }

    public boolean method_5675() {
        return !this.method_5681();
    }

    public boolean method_6123() {
        return this.field_6261 > 0;
    }

    public void method_6078(class_1282 damageSource) {
        this.startState(State.STANDING);
        super.method_6078(damageSource);
    }

    public static enum State {
        STANDING(0),
        AWAKEN(1),
        CASTING(2),
        CONJURE_DROWNED(3),
        CONJURE_WHIRLPOOLS(4),
        CONJURE_TRIDENTS(5),
        CONJURE_BARRAGE(6),
        CONJURE_TEMPEST(7),
        STUNNED(8),
        TRIDENT_LODGE(9);

        public static final IntFunction<State> INDEX_TO_VALUE;
        public static final class_9139<ByteBuf, State> PACKET_CODEC;
        private final int index;

        private State(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        static {
            INDEX_TO_VALUE = class_7995.method_47914(State::getIndex, (Object[])State.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            PACKET_CODEC = class_9135.method_56375(INDEX_TO_VALUE, State::getIndex);
        }
    }

    static class ConjurerMoveControl
    extends class_1335 {
        private final DrownedConjurerEntity conjurer;

        public ConjurerMoveControl(DrownedConjurerEntity drownedConjurer) {
            super((class_1308)drownedConjurer);
            this.conjurer = drownedConjurer;
        }

        public void method_6240() {
            class_1309 livingentity = this.conjurer.method_5968();
            if (this.conjurer.isTargetingUnderwater() && this.conjurer.method_5799()) {
                if (livingentity != null && livingentity.method_23318() > this.conjurer.method_23318() || this.conjurer.targetingUnderwater) {
                    this.conjurer.method_18799(this.conjurer.method_18798().method_1031(0.0, 0.002, 0.0));
                }
                if (this.field_6374 != class_1335.class_1336.field_6378 || this.conjurer.method_5942().method_6357()) {
                    this.conjurer.method_6125(0.0f);
                    return;
                }
                double d = this.field_6370 - this.conjurer.method_23317();
                double e = this.field_6369 - this.conjurer.method_23318();
                double f = this.field_6367 - this.conjurer.method_23321();
                double g = Math.sqrt(d * d + e * e + f * f);
                e /= g;
                float h = (float)(class_3532.method_15349((double)f, (double)d) * 180.0 / 3.1415927410125732) - 90.0f;
                this.conjurer.method_36456(this.method_6238(this.conjurer.method_36454(), h, 90.0f));
                this.conjurer.field_6283 = this.conjurer.method_36454();
                float i = (float)(this.field_6372 * this.conjurer.method_45325(class_5134.field_23719));
                float j = class_3532.method_16439((float)0.125f, (float)this.conjurer.method_6029(), (float)i);
                this.conjurer.method_6125(j);
                this.conjurer.method_18799(this.conjurer.method_18798().method_1031((double)j * d * 0.005, (double)j * e * 0.1, (double)j * f * 0.005));
            } else {
                if (!this.conjurer.method_24828()) {
                    this.conjurer.method_18799(this.conjurer.method_18798().method_1031(0.0, -0.008, 0.0));
                }
                super.method_6240();
            }
        }
    }
}

