/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.entity.brain.ForestFaiBrain;
import net.j677.adventuresmod.item.AdventureItems;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.j677.adventuresmod.util.AdventureTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_4215;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5698;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_5716;
import net.minecraft.class_5819;
import net.minecraft.class_6067;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8514;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ForestFaiEntity
extends class_1314
implements class_6067,
class_8514 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_1856 DUPLICATION_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_27063});
    private static final class_2940<Boolean> HAS_ITEM = class_2945.method_12791(ForestFaiEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DANCING = class_2945.method_12791(ForestFaiEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CAN_DUPLICATE = class_2945.method_12791(ForestFaiEntity.class, (class_2941)class_2943.field_13323);
    private final class_1277 inventory = new class_1277(1);
    @Nullable
    private class_2338 jukeboxPos;
    private long duplicationCooldown;
    private float field_38935;
    private float field_38936;
    private float danceTicks;
    private float field_39473;
    private float field_39474;
    private final class_5715<class_8514.class_8516> gameEventHandler;
    private class_8514.class_8515 vibrationListenerData;
    private final class_8514.class_5719 vibrationCallback;
    private final class_5715<JukeboxEventListener> jukeboxEventHandler;
    protected static final ImmutableList<class_4149<? extends class_4148<? super ForestFaiEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_18469);
    protected static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_18449, (Object)class_4140.field_18446, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18451, (Object)class_4140.field_38394, (Object)class_4140.field_38395, (Object)class_4140.field_38396, (Object)class_4140.field_39408);

    public ForestFaiEntity(class_1299<? extends ForestFaiEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.vibrationCallback = new VibrationCallback();
        this.vibrationListenerData = new class_8514.class_8515();
        this.gameEventHandler = new class_5715((class_5714)new class_8514.class_8516((class_8514)this));
        this.jukeboxEventHandler = new class_5715((class_5714)new JukeboxEventListener(this.vibrationCallback.method_51300(), ((class_5712)class_5712.field_39485.comp_349()).comp_2193()));
    }

    public static class_5132.class_5133 createFaiAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23720, (double)0.1f).method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 48.0);
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(true);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    public static boolean canSpawn(class_1299<ForestFaiEntity> entityType, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(AdventureTags.Blocks.MYTHICA_SPAWNABLE_ON) && world.method_22335(pos, 0) > 10;
    }

    public boolean hasItem() {
        return (Boolean)this.field_6011.method_12789(HAS_ITEM);
    }

    public void setHasItem(boolean hasPayment) {
        this.field_6011.method_12778(HAS_ITEM, (Object)hasPayment);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.method_46399(nbt, (class_7225.class_7874)this.method_56673());
        nbt.method_10556("HasItem", this.hasItem());
        class_6903 registryOps = this.method_56673().method_57093((DynamicOps)class_2509.field_11560);
        class_8514.class_8515.field_44640.encodeStart((DynamicOps)registryOps, (Object)this.vibrationListenerData).resultOrPartial(string -> LOGGER.error("Failed to encode vibration listener for Forest Fai: '{}'", string)).ifPresent(nbtElement -> nbt.method_10566("listener", nbtElement));
        nbt.method_10544("DuplicationCooldown", this.duplicationCooldown);
        nbt.method_10556("CanDuplicate", this.canDuplicate());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_46400(nbt, (class_7225.class_7874)this.method_56673());
        this.setHasItem(nbt.method_10577("HasItem"));
        class_6903 registryOps = this.method_56673().method_57093((DynamicOps)class_2509.field_11560);
        if (nbt.method_10573("listener", 10)) {
            class_8514.class_8515.field_44640.parse((DynamicOps)registryOps, (Object)nbt.method_10562("listener")).resultOrPartial(string -> LOGGER.error("Failed to parse vibration listener for Forest Fai: '{}'", string)).ifPresent(listenerData -> {
                this.vibrationListenerData = listenerData;
            });
        }
        this.duplicationCooldown = nbt.method_10550("DuplicationCooldown");
        this.field_6011.method_12778(CAN_DUPLICATE, (Object)nbt.method_10577("CanDuplicate"));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_ITEM, (Object)false);
        builder.method_56912(DANCING, (Object)false);
        builder.method_56912(CAN_DUPLICATE, (Object)true);
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5787()) {
            if (this.method_5799()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)0.8f));
            } else if (this.method_5771()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.5));
            } else {
                this.method_5724(this.method_6029(), movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)0.91f));
            }
        }
        this.method_29242(false);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_12972;
            Optional optional = this.method_18868().method_18904(class_4140.field_38394);
            if (optional.isPresent() && playerEntity.method_5667().equals(optional.get())) {
                return false;
            }
        }
        return super.method_5643(source, amount);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    protected class_3414 method_5994() {
        return AdventureSounds.ENTITY_FOREST_FAI_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return AdventureSounds.ENTITY_FOREST_FAI_HURT;
    }

    protected class_3414 method_6002() {
        return AdventureSounds.ENTITY_FOREST_FAI_DEATH;
    }

    protected class_4095.class_5303<ForestFaiEntity> method_28306() {
        return class_4095.method_28311(MEMORY_MODULES, SENSORS);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return ForestFaiBrain.create((class_4095<ForestFaiEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<ForestFaiEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("faiBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("faiActivityUpdate");
        ForestFaiBrain.updateActivities(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236 && this.method_5805() && this.field_6012 % 10 == 0) {
            this.method_6025(1.0f);
        }
        if (this.isDancing() && this.shouldStopDancing() && this.field_6012 % 20 == 0) {
            this.setDancing(false);
            this.jukeboxPos = null;
        }
        if (!this.method_37908().field_9236 && this.method_5805() && this.hasItem() && this.field_6012 % 10 == 0) {
            class_1799 itemStack = this.method_5998(class_1268.field_5808);
            class_1293 statusEffects = ForestFaiEntity.getStatusEffectInstance(itemStack);
            for (class_1309 nearbyEntities : this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(12.0), class_1301.field_6155)) {
                if (!(nearbyEntities instanceof class_1657)) continue;
                class_1657 nearbyPlayers = (class_1657)nearbyEntities;
                if (statusEffects == null) continue;
                nearbyPlayers.method_6092(statusEffects);
            }
        }
        this.tickDuplicationCooldown();
    }

    @Nullable
    private static class_1293 getStatusEffectInstance(class_1799 itemStack) {
        class_1293 statusEffects = null;
        if (itemStack.method_31574(AdventureItems.BISMUTH)) {
            statusEffects = new class_1293(class_1294.field_5924, 200);
        } else if (itemStack.method_31574(AdventureItems.TOPAZ)) {
            statusEffects = new class_1293(class_1294.field_5910, 100);
        } else if (itemStack.method_31574(AdventureItems.TOURMALINE)) {
            statusEffects = new class_1293(class_1294.field_5904, 200);
        }
        return statusEffects;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            this.field_38936 = this.field_38935;
            this.field_38935 = this.isHoldingItem() ? class_3532.method_15363((float)(this.field_38935 + 1.0f), (float)0.0f, (float)5.0f) : class_3532.method_15363((float)(this.field_38935 - 1.0f), (float)0.0f, (float)5.0f);
            if (this.isDancing()) {
                this.danceTicks += 1.0f;
                this.field_39474 = this.field_39473;
                this.field_39473 = this.isSpinning() ? (this.field_39473 += 1.0f) : (this.field_39473 -= 1.0f);
                this.field_39473 = class_3532.method_15363((float)this.field_39473, (float)0.0f, (float)15.0f);
            } else {
                this.danceTicks = 0.0f;
                this.field_39473 = 0.0f;
                this.field_39474 = 0.0f;
            }
        } else if (this.method_52546()) {
            this.setDancing(false);
        }
    }

    public boolean isHoldingItem() {
        return !this.method_5998(class_1268.field_5808).method_7960();
    }

    public boolean method_18397(class_1799 stack) {
        return false;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1799 itemStack2 = this.method_5998(class_1268.field_5808);
        if (this.isDancing() && this.matchesDuplicationIngredient(itemStack) && this.canDuplicate()) {
            this.duplicate();
            this.method_37908().method_8421((class_1297)this, (byte)18);
            this.method_37908().method_43129(player, (class_1297)this, class_3417.field_26980, class_3419.field_15254, 2.0f, 1.0f);
            this.decrementStackUnlessInCreative(player, itemStack);
            return class_1269.field_5812;
        }
        if (itemStack2.method_7960() && !itemStack.method_7960()) {
            class_1799 itemStack3 = itemStack.method_46651(1);
            this.method_6122(class_1268.field_5808, itemStack3);
            this.decrementStackUnlessInCreative(player, itemStack);
            this.method_37908().method_43129(player, (class_1297)this, AdventureSounds.ENTITY_FOREST_FAI_ITEM_GIVEN, class_3419.field_15254, 2.0f, 1.0f);
            this.method_18868().method_18878(class_4140.field_38394, (Object)player.method_5667());
            this.setHasItem(true);
            return class_1269.field_5812;
        }
        if (!itemStack2.method_7960() && hand == class_1268.field_5808 && itemStack.method_7960()) {
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
            this.method_37908().method_43129(player, (class_1297)this, AdventureSounds.ENTITY_FOREST_FAI_ITEM_TAKEN, class_3419.field_15254, 2.0f, 1.0f);
            this.method_6104(class_1268.field_5808);
            for (class_1799 itemStack4 : this.method_35199().method_24514()) {
                class_4215.method_19949((class_1309)this, (class_1799)itemStack4, (class_243)this.method_19538());
            }
            this.method_18868().method_18875(class_4140.field_38394);
            this.setHasItem(false);
            player.method_7270(itemStack2);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public class_1277 method_35199() {
        return this.inventory;
    }

    protected void method_5949(class_1542 item) {
        class_6067.method_43544((class_1308)this, (class_6067)this, (class_1542)item);
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public boolean method_5776() {
        return !this.method_24828();
    }

    public void method_42147(BiConsumer<class_5715<?>, class_3218> callback) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            callback.accept(this.gameEventHandler, serverWorld);
            callback.accept(this.jukeboxEventHandler, serverWorld);
        }
    }

    public boolean isDancing() {
        return (Boolean)this.field_6011.method_12789(DANCING);
    }

    public void setDancing(boolean dancing) {
        if (!(this.method_37908().field_9236 || !this.method_6034() || dancing && this.method_52546())) {
            this.field_6011.method_12778(DANCING, (Object)dancing);
        }
    }

    private boolean shouldStopDancing() {
        return this.jukeboxPos == null || !this.jukeboxPos.method_19769((class_2374)this.method_19538(), (double)((class_5712)class_5712.field_39485.comp_349()).comp_2193()) || !this.method_37908().method_8320(this.jukeboxPos).method_27852(class_2246.field_10223);
    }

    public void updateJukeboxPos(class_2338 jukeboxPos, boolean playing) {
        if (playing) {
            if (!this.isDancing()) {
                this.jukeboxPos = jukeboxPos;
                this.setDancing(true);
            }
        } else if (jukeboxPos.equals((Object)this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDancing(false);
        }
    }

    public float method_43397(float f) {
        return class_3532.method_16439((float)f, (float)this.field_38936, (float)this.field_38935) / 5.0f;
    }

    public boolean isSpinning() {
        float f = this.danceTicks % 55.0f;
        return f < 15.0f;
    }

    public float method_44368(float f) {
        return class_3532.method_16439((float)f, (float)this.field_39474, (float)this.field_39473) / 15.0f;
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    protected boolean method_43689() {
        return false;
    }

    private void tickDuplicationCooldown() {
        if (this.duplicationCooldown > 0L) {
            --this.duplicationCooldown;
        }
        if (!this.method_37908().method_8608() && this.duplicationCooldown == 0L && !this.canDuplicate()) {
            this.field_6011.method_12778(CAN_DUPLICATE, (Object)true);
        }
    }

    private boolean matchesDuplicationIngredient(class_1799 stack) {
        return DUPLICATION_INGREDIENT.method_8093(stack);
    }

    private void duplicate() {
        ForestFaiEntity faiEntity = (ForestFaiEntity)AdventureEntityTypes.FOREST_FAI.method_5883(this.method_37908());
        if (faiEntity != null) {
            faiEntity.method_29495(this.method_19538());
            faiEntity.method_5971();
            faiEntity.startDuplicationCooldown();
            this.startDuplicationCooldown();
            this.method_37908().method_8649((class_1297)faiEntity);
        }
    }

    private void startDuplicationCooldown() {
        this.duplicationCooldown = 8000L;
        this.field_6011.method_12778(CAN_DUPLICATE, (Object)false);
    }

    private boolean canDuplicate() {
        return (Boolean)this.field_6011.method_12789(CAN_DUPLICATE);
    }

    private void decrementStackUnlessInCreative(class_1657 player, class_1799 stack) {
        stack.method_57008(1, (class_1309)player);
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)this.method_5751() * 0.6, (double)this.method_17681() * 0.1);
    }

    public void method_5711(byte status) {
        if (status == 18) {
            for (int i = 0; i < 3; ++i) {
                this.addHeartParticle();
            }
        } else {
            super.method_5711(status);
        }
    }

    private void addHeartParticle() {
        double d = this.field_5974.method_43059() * 0.02;
        double e = this.field_5974.method_43059() * 0.02;
        double f = this.field_5974.method_43059() * 0.02;
        this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
    }

    public class_8514.class_8515 method_51298() {
        return this.vibrationListenerData;
    }

    public class_8514.class_5719 method_51299() {
        return this.vibrationCallback;
    }

    class VibrationCallback
    implements class_8514.class_5719 {
        private static final int RANGE = 16;
        private final class_5716 positionSource;

        VibrationCallback() {
            this.positionSource = new class_5709((class_1297)ForestFaiEntity.this, ForestFaiEntity.this.method_5751());
        }

        public int method_49797() {
            return 16;
        }

        public class_5716 method_51300() {
            return this.positionSource;
        }

        public boolean method_32970(class_3218 world, class_2338 pos, class_6880<class_5712> event, class_5712.class_7397 emitter) {
            if (ForestFaiEntity.this.method_5987()) {
                return false;
            }
            Optional optional = ForestFaiEntity.this.method_18868().method_18904(class_4140.field_38395);
            if (optional.isEmpty()) {
                return true;
            }
            class_4208 globalPos = (class_4208)optional.get();
            return globalPos.comp_2207().equals(world.method_27983()) && globalPos.comp_2208().equals((Object)pos);
        }

        public void method_32969(class_3218 world, class_2338 pos, class_6880<class_5712> event, @Nullable class_1297 sourceEntity, @Nullable class_1297 entity, float distance) {
            if (event.method_55838((class_6880)class_5712.field_38425)) {
                ForestFaiBrain.rememberNoteBlock((class_1309)ForestFaiEntity.this, new class_2338((class_2382)pos));
            }
        }

        public class_6862<class_5712> method_42210() {
            return class_5698.field_39031;
        }
    }

    class JukeboxEventListener
    implements class_5714 {
        private final class_5716 positionSource;
        private final int range;

        public JukeboxEventListener(class_5716 positionSource, int range) {
            this.positionSource = positionSource;
            this.range = range;
        }

        public class_5716 method_32946() {
            return this.positionSource;
        }

        public int method_32948() {
            return this.range;
        }

        public boolean method_32947(class_3218 world, class_6880<class_5712> event, class_5712.class_7397 emitter, class_243 emitterPos) {
            if (event.method_55838((class_6880)class_5712.field_39485)) {
                ForestFaiEntity.this.updateJukeboxPos(class_2338.method_49638((class_2374)emitterPos), true);
                return true;
            }
            if (event.method_55838((class_6880)class_5712.field_39486)) {
                ForestFaiEntity.this.updateJukeboxPos(class_2338.method_49638((class_2374)emitterPos), false);
                return true;
            }
            return false;
        }
    }
}

