/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.UUID;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.entity.custom.RekindledEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public class IgniterEntity
extends class_1588
implements class_8046 {
    private int warmup;
    private int ticksLeft = 900;
    private boolean summoned;
    public class_7094 emergingAnimationState = new class_7094();
    @Nullable
    private class_1309 owner;
    @Nullable
    private UUID ownerUuid;
    private float delay;
    private static final class_2940<Boolean> LIT = class_2945.method_12791(IgniterEntity.class, (class_2941)class_2943.field_13323);

    public IgniterEntity(class_1299<? extends IgniterEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public IgniterEntity(class_1937 world, double x, double y, double z, float yaw, int warmup, class_1309 owner) {
        this(AdventureEntityTypes.IGNITER, world);
        this.warmup = warmup;
        this.setOwner(owner);
        this.method_36456(yaw * 57.295776f);
        this.method_5814(x, y, z);
        this.summoned = true;
        this.setLit(false);
    }

    public IgniterEntity(class_1937 world, double x, double y, double z, int warmup, class_1309 owner, float delay) {
        this(AdventureEntityTypes.IGNITER, world);
        this.warmup = warmup;
        this.setOwner(owner);
        this.method_5814(x, y, z);
        this.summoned = true;
        this.setLit(true);
        this.delay = delay;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1361((class_1308)this, RekindledEntity.class, 16.0f));
        this.field_6201.method_6277(1, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(2, (class_1352)new ShootFireballGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class_5132.class_5133 createIgniterAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23717, 24.0);
    }

    public void method_5674(class_2940<?> data) {
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.method_5667();
    }

    @Nullable
    public class_1309 getOwner() {
        class_1297 entity;
        if (this.owner == null && this.ownerUuid != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUuid)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LIT, (Object)false);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.delay = nbt.method_10583("Delay");
        this.warmup = nbt.method_10550("Warmup");
        this.setLit(nbt.method_10577("Lit"));
        if (nbt.method_25928("Owner")) {
            this.ownerUuid = nbt.method_25926("Owner");
        }
    }

    public boolean method_6054() {
        return false;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10548("Delay", this.delay);
        nbt.method_10569("Warmup", this.warmup);
        nbt.method_10556("Lit", this.isLit());
        if (this.ownerUuid != null) {
            nbt.method_25927("Owner", this.ownerUuid);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (--this.warmup < 0 && --this.ticksLeft < 0) {
            this.method_31472();
        }
    }

    public boolean isSummoned() {
        return this.summoned;
    }

    public boolean method_5722(class_1297 other) {
        if (super.method_5722(other)) {
            return true;
        }
        if (other instanceof RekindledEntity) {
            return true;
        }
        return other instanceof IgniterEntity;
    }

    public boolean isLit() {
        return (Boolean)this.field_6011.method_12789(LIT);
    }

    public void setLit(boolean lit) {
        this.field_6011.method_12778(LIT, (Object)lit);
    }

    public void method_6007() {
        if ((float)this.emergingAnimationState.method_43687() > 200.0f && this.method_37908().field_9236) {
            this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23322(0.5), this.method_23320() + 0.4, this.method_23325(0.5), 0.0, 0.0, 0.0);
        }
        if (this.isLit() && this.getOwner() != null) {
            double x = this.getOwner().method_23317() + (double)(10.0f * class_3532.method_15362((float)(0.02199115f * (float)this.field_6012 + this.delay)));
            double z = this.getOwner().method_23321() + (double)(10.0f * class_3532.method_15374((float)(0.02199115f * (float)this.field_6012 + this.delay)));
            this.method_5814(x, this.method_23318(), z);
        }
        super.method_6007();
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
    }

    public class_243 method_18798() {
        return class_243.field_1353;
    }

    public void method_18799(class_243 velocity) {
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5697(class_1297 entity) {
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new class_2604((class_1297)this, entityTrackerEntry, this.isSummoned() ? 1 : 0);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (packet.method_11166() == 1) {
            this.emergingAnimationState.method_41322(this.field_6012);
        }
    }

    public class_1309 getBeamTarget() {
        Iterator iterator = this.method_37908().method_8390(RekindledEntity.class, this.method_5829().method_1014(24.0), class_1301.field_6156).iterator();
        if (iterator.hasNext()) {
            RekindledEntity target = (RekindledEntity)((Object)iterator.next());
            return target;
        }
        return this.getOwner();
    }

    static class ShootFireballGoal
    extends class_1352 {
        private final IgniterEntity igniter;
        private int fireballsFired;
        private int fireballCooldown;
        private int targetNotVisibleTicks;

        public ShootFireballGoal(IgniterEntity igniter) {
            this.igniter = igniter;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.igniter.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.igniter.method_18395(livingEntity);
        }

        public void method_6269() {
            this.fireballsFired = 0;
        }

        public void method_6270() {
            this.targetNotVisibleTicks = 0;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            --this.fireballCooldown;
            class_1309 livingEntity = this.igniter.method_5968();
            if (livingEntity != null) {
                boolean bl = this.igniter.method_5985().method_6369((class_1297)livingEntity);
                this.targetNotVisibleTicks = bl ? 0 : ++this.targetNotVisibleTicks;
                double d = this.igniter.method_5858((class_1297)livingEntity);
                if (d < 4.0) {
                    if (!bl) {
                        return;
                    }
                    if (this.fireballCooldown <= 0) {
                        this.fireballCooldown = 20;
                    }
                } else if (d < this.getFollowRange() * this.getFollowRange() && bl) {
                    double e = livingEntity.method_23317() - this.igniter.method_23317();
                    double f = livingEntity.method_23323(0.5) - this.igniter.method_23323(0.5);
                    double g = livingEntity.method_23321() - this.igniter.method_23321();
                    if (this.fireballCooldown <= 0) {
                        ++this.fireballsFired;
                        if (this.fireballsFired == 1) {
                            this.fireballCooldown = 60;
                        } else if (this.fireballsFired <= 4) {
                            this.fireballCooldown = 6;
                        } else {
                            this.fireballCooldown = 140;
                            this.fireballsFired = 0;
                        }
                        if (this.fireballsFired > 1) {
                            double h = Math.sqrt(Math.sqrt(d)) * 0.5;
                            if (!this.igniter.method_5701()) {
                                this.igniter.method_37908().method_8444(null, 1018, this.igniter.method_24515(), 0);
                            }
                            for (int i = 0; i < 2; ++i) {
                                class_243 vec3d = new class_243(this.igniter.method_59922().method_43385(e, 2.297 * h), f, this.igniter.method_59922().method_43385(g, 2.297 * h));
                                class_1677 smallFireballEntity = new class_1677(this.igniter.method_37908(), (class_1309)this.igniter, vec3d.method_1029());
                                smallFireballEntity.method_5814(smallFireballEntity.method_23317(), this.igniter.method_23323(0.5) + 0.5, smallFireballEntity.method_23321());
                                this.igniter.method_37908().method_8649((class_1297)smallFireballEntity);
                            }
                        }
                    }
                    this.igniter.method_5988().method_6226((class_1297)livingEntity, 10.0f, 10.0f);
                }
                super.method_6268();
            }
        }

        private double getFollowRange() {
            return this.igniter.method_45325(class_5134.field_23717);
        }
    }
}

