/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.j677.adventuresmod.entity.brain.InflamedBrain;
import net.j677.adventuresmod.entity.custom.IgniterEntity;
import net.j677.adventuresmod.entity.custom.RekindledEntity;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.j677.adventuresmod.util.AdventureDamageTypes;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4837;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class InflamedEntity
extends class_5418 {
    protected static final ImmutableList<class_4149<? extends class_4148<? super InflamedEntity>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_18469, (Object)class_4149.field_25757);
    protected static final ImmutableList<class_4140<?>> MEMORY_MODULE_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_26389, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_22343, (Object)class_4140.field_25755, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object[])new class_4140[]{class_4140.field_22355, class_4140.field_22475, class_4140.field_18447, class_4140.field_18449, class_4140.field_22333, class_4140.field_25360});

    public InflamedEntity(class_1299<? extends class_5418> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 10;
    }

    public static class_5132.class_5133 createInflamedAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.35f).method_26868(class_5134.field_23721, 2.0);
    }

    public static boolean canSpawn(class_1299<InflamedEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return !world.method_8320(pos.method_10074()).method_27852(class_2246.field_10541);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.method_5964(world.method_8409(), difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public boolean method_5722(class_1297 other) {
        if (super.method_5722(other)) {
            return true;
        }
        if (other instanceof RekindledEntity) {
            return true;
        }
        return other instanceof IgniterEntity;
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
    }

    protected class_4095.class_5303<InflamedEntity> method_28306() {
        return class_4095.method_28311(MEMORY_MODULE_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return InflamedBrain.create(this, (class_4095<InflamedEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<InflamedEntity> method_18868() {
        return super.method_18868();
    }

    public boolean method_26952() {
        return false;
    }

    public boolean method_20820(class_1799 stack) {
        return stack.method_31574(class_1802.field_8825) && super.method_20820(stack);
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("inflamedBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        InflamedBrain.tick(this);
        InflamedBrain.playSoundRandomly(this);
        super.method_5958();
    }

    public class_4837 method_24705() {
        return this.method_6510() && this.method_30237() ? class_4837.field_25165 : class_4837.field_22386;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean bl = super.method_5643(source, amount);
        if (this.method_37908().field_9236) {
            return false;
        }
        if (source.method_49708(AdventureDamageTypes.DEBRIS) || source.method_49708(AdventureDamageTypes.INCINERATED)) {
            return false;
        }
        if (bl && source.method_5529() instanceof class_1309) {
            InflamedBrain.tryRevenge(this, (class_1309)source.method_5529());
        }
        return bl;
    }

    protected class_3414 method_5994() {
        return AdventureSounds.ENTITY_INFLAMED_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return AdventureSounds.ENTITY_INFLAMED_HURT;
    }

    protected class_3414 method_6002() {
        return AdventureSounds.ENTITY_INFLAMED_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(AdventureSounds.ENTITY_INFLAMED_STEP, 0.15f, 1.0f);
    }

    public void playAngrySound() {
        this.method_56078(AdventureSounds.ENTITY_INFLAMED_ANGRY);
    }

    protected void method_30238() {
        this.method_56078(AdventureSounds.ENTITY_INFLAMED_CONVERTED_TO_ZOMBIFIED);
    }
}

