/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import net.j677.adventuresmod.block.AdventureBlocks;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.util.AdventureTags;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1430;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5147;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;

public class MythicanCowEntity
extends class_1430
implements class_5147 {
    private static final class_2940<Boolean> SHEARED = class_2945.method_12791(MythicanCowEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> MYTHICAN_COW_TYPE = class_2945.method_12791(MythicanCowEntity.class, (class_2941)class_2943.field_13327);

    public MythicanCowEntity(class_1299<? extends MythicanCowEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SHEARED, (Object)false);
        builder.method_56912(MYTHICAN_COW_TYPE, (Object)Type.MOSSY.id);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Sheared", this.isSheared());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setSheared(nbt.method_10577("Sheared"));
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.field_6011.method_12778(SHEARED, (Object)sheared);
    }

    public Type getVariant() {
        return Type.byId((Integer)this.field_6011.method_12789(MYTHICAN_COW_TYPE));
    }

    public void setVariant(Type devourerType) {
        this.field_6011.method_12778(MYTHICAN_COW_TYPE, (Object)devourerType.id);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8868) && this.method_27072()) {
            this.method_6636(class_3419.field_15248);
            this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
            if (!this.method_37908().field_9236) {
                itemStack.method_7970(1, (class_1309)player, MythicanCowEntity.method_56079((class_1268)hand));
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(class_3419 shearedSoundCategory) {
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14705, shearedSoundCategory, 1.0f, 1.0f);
        this.dropShearedItems();
        this.setSheared(true);
    }

    private void dropShearedItems() {
        for (int i = 0; i < 5; ++i) {
            this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23323(1.0), this.method_23321(), new class_1799((class_1935)this.getVariant().flower.method_26204())));
        }
    }

    public boolean method_27072() {
        return !this.isSheared() && this.method_5805();
    }

    @Nullable
    public MythicanCowEntity createChild(class_3218 serverWorld, class_1296 passiveEntity) {
        MythicanCowEntity mythicanCowEntity = (MythicanCowEntity)AdventureEntityTypes.MYTHICAN_COW.method_5883((class_1937)serverWorld);
        if (mythicanCowEntity != null && passiveEntity instanceof MythicanCowEntity) {
            MythicanCowEntity mythicanCowEntity2 = (MythicanCowEntity)passiveEntity;
            if (this.field_5974.method_43056()) {
                mythicanCowEntity.setVariant(this.getVariant());
            } else {
                mythicanCowEntity.setVariant(mythicanCowEntity2.getVariant());
            }
        }
        return mythicanCowEntity;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        Type mythicanCowType = MythicanCowEntity.getTypeFromPos((class_1936)world, this.method_24515());
        if (entityData instanceof MythicanCowData) {
            mythicanCowType = ((MythicanCowData)((Object)entityData)).type;
        } else {
            entityData = new MythicanCowData(mythicanCowType);
        }
        this.setVariant(mythicanCowType);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    private static Type getTypeFromPos(class_1936 world, class_2338 pos) {
        class_6880 registryEntry = world.method_23753(pos);
        int i = world.method_8409().method_43048(100);
        if (registryEntry.method_40220(AdventureTags.Biomes.SPAWNS_ROSE_VARIANT_MYTHICAN_ANIMALS)) {
            return Type.ROSE;
        }
        if (registryEntry.method_40220(AdventureTags.Biomes.SPAWNS_UMBRA_VARIANT_MYTHICAN_ANIMALS)) {
            return Type.UMBRA;
        }
        return Type.MOSSY;
    }

    public static enum Type implements class_3542
    {
        MOSSY(0, "mossy", AdventureBlocks.AROMANA.method_9564()),
        ROSE(1, "rose", AdventureBlocks.BEWITCHED_VIOLET.method_9564()),
        UMBRA(2, "umbra", AdventureBlocks.SHROUDED_GLORY.method_9564());

        private static final IntFunction<Type> BY_ID;
        public static final Codec<Type> CODEC;
        final int id;
        private final String name;
        final class_2680 flower;

        private Type(int id, String name, class_2680 flower) {
            this.id = id;
            this.name = name;
            this.flower = flower;
        }

        public class_2680 getFlowerState() {
            return this.flower;
        }

        public String method_15434() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Type byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = class_7995.method_47915(Type::getId, (Object[])Type.values(), (Object)((Object)MOSSY));
            CODEC = class_3542.method_28140(Type::values);
        }
    }

    public static class MythicanCowData
    extends class_1296.class_4697 {
        public final Type type;

        public MythicanCowData(Type type) {
            super(0.05f);
            this.type = type;
        }
    }
}

