/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.List;
import net.j677.adventuresmod.entity.brain.AdventureSensorTypes;
import net.j677.adventuresmod.entity.brain.PiglinScavengerBrain;
import net.j677.adventuresmod.item.AdventureItems;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4837;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5996;
import net.minecraft.class_6067;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;

public class PiglinScavengerEntity
extends class_5418
implements class_3745,
class_6067 {
    private static final class_2940<Boolean> CHARGING = class_2945.method_12791(PiglinScavengerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DANCING = class_2945.method_12791(PiglinScavengerEntity.class, (class_2941)class_2943.field_13323);
    private final class_1277 inventory = new class_1277(8);
    private boolean cannotHunt;
    protected static final ImmutableList<class_4149<? extends class_4148<? super PiglinScavengerEntity>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_18469, AdventureSensorTypes.PIGLIN_SCAVENGER_SPECIFIC_SENSOR);
    protected static final ImmutableList<class_4140<?>> MEMORY_MODULE_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_26389, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_22343, (Object)class_4140.field_25755, (Object)class_4140.field_22332, (Object)class_4140.field_38397, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object[])new class_4140[]{class_4140.field_18445, class_4140.field_19293, class_4140.field_22355, class_4140.field_22475, class_4140.field_18447, class_4140.field_18449, class_4140.field_22333, class_4140.field_25361, class_4140.field_22357, class_4140.field_22334, class_4140.field_25813, class_4140.field_22473, class_4140.field_25814, class_4140.field_22337, class_4140.field_25159, class_4140.field_22336, class_4140.field_22356, class_4140.field_22347, class_4140.field_22348, class_4140.field_22339, class_4140.field_22342, class_4140.field_22349, class_4140.field_22350});

    public PiglinScavengerEntity(class_1299<? extends PiglinScavengerEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 10;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.cannotHunt) {
            nbt.method_10556("CannotHunt", true);
        }
        this.method_46399(nbt, (class_7225.class_7874)this.method_56673());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setCannotHunt(nbt.method_10577("CannotHunt"));
        this.method_46400(nbt, (class_7225.class_7874)this.method_56673());
    }

    @class_5996
    public class_1277 method_35199() {
        return this.inventory;
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        super.method_6099(world, source, causedByPlayer);
        this.inventory.method_24514().forEach(arg_0 -> ((PiglinScavengerEntity)this).method_5775(arg_0));
    }

    public class_1799 addItem(class_1799 stack) {
        return this.inventory.method_5491(stack);
    }

    public boolean canInsertIntoInventory(class_1799 stack) {
        return this.inventory.method_27070(stack);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CHARGING, (Object)false);
        builder.method_56912(DANCING, (Object)false);
    }

    public static class_5132.class_5133 createScavengerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.35f).method_26868(class_5134.field_23721, 6.0);
    }

    public static boolean canSpawn(class_1299<PiglinScavengerEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return !world.method_8320(pos.method_10074()).method_27852(class_2246.field_10541);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_5819 random = world.method_8409();
        if (spawnReason != class_3730.field_16474) {
            this.method_5673(class_1304.field_6173, this.makeInitialWeapon());
        }
        PiglinScavengerBrain.setHuntedRecently(this, world.method_8409());
        this.method_5964(random, difficulty);
        this.method_5984(world, random, difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected boolean method_23734() {
        return false;
    }

    public boolean method_5974(double distanceSquared) {
        return !this.method_5947();
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        if (this.method_30236()) {
            this.equipAtChance(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8862), random);
            this.equipAtChance(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8678), random);
            this.equipAtChance(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8416), random);
            this.equipAtChance(class_1304.field_6166, new class_1799((class_1935)class_1802.field_8753), random);
        }
    }

    private void equipAtChance(class_1304 slot, class_1799 stack, class_5819 random) {
        if (random.method_43057() < 0.1f) {
            this.method_5673(slot, stack);
        }
    }

    protected class_4095.class_5303<PiglinScavengerEntity> method_28306() {
        return class_4095.method_28311(MEMORY_MODULE_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return PiglinScavengerBrain.create(this, (class_4095<PiglinScavengerEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<PiglinScavengerEntity> method_18868() {
        return super.method_18868();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1269 actionResult = super.method_5992(player, hand);
        if (actionResult.method_23665()) {
            return actionResult;
        }
        if (!this.method_37908().field_9236) {
            return PiglinScavengerBrain.playerInteract(this, player, hand);
        }
        boolean bl = PiglinScavengerBrain.isWillingToTrade(this, player.method_5998(hand)) && this.method_24705() != class_4837.field_22385;
        return bl ? class_1269.field_5812 : class_1269.field_5811;
    }

    private void setCannotHunt(boolean cannotHunt) {
        this.cannotHunt = cannotHunt;
    }

    public boolean method_26952() {
        return !this.cannotHunt;
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("piglinBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        PiglinScavengerBrain.tickActivities(this);
        super.method_5958();
    }

    protected int method_6110() {
        return this.field_6194;
    }

    protected void method_24694(class_3218 world) {
        PiglinScavengerBrain.pickupItemWithOffHand(this);
        this.inventory.method_24514().forEach(arg_0 -> ((PiglinScavengerEntity)this).method_5775(arg_0));
        super.method_24694(world);
    }

    private class_1799 makeInitialWeapon() {
        return (double)this.field_5974.method_43057() < 0.5 ? new class_1799((class_1935)class_1802.field_8399) : new class_1799((class_1935)AdventureItems.CORRODED_MACHETE);
    }

    private boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(CHARGING);
    }

    public void method_7110(boolean charging) {
        this.field_6011.method_12778(CHARGING, (Object)charging);
    }

    public void method_24651() {
        this.field_6278 = 0;
    }

    public class_4837 method_24705() {
        if (this.isDancing()) {
            return class_4837.field_25166;
        }
        if (PiglinScavengerBrain.isGoldenItem(this.method_6079())) {
            return class_4837.field_22385;
        }
        if (this.method_6510() && this.method_30237()) {
            return class_4837.field_25165;
        }
        if (this.isCharging()) {
            return class_4837.field_22384;
        }
        return this.method_6510() && this.method_24518(class_1802.field_8399) ? class_4837.field_22383 : class_4837.field_22386;
    }

    public boolean isDancing() {
        return (Boolean)this.field_6011.method_12789(DANCING);
    }

    public void setDancing(boolean dancing) {
        this.field_6011.method_12778(DANCING, (Object)dancing);
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean bl = super.method_5643(source, amount);
        if (this.method_37908().field_9236) {
            return false;
        }
        if (bl && source.method_5529() instanceof class_1309) {
            PiglinScavengerBrain.onAttacked(this, (class_1309)source.method_5529());
        }
        return bl;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.method_24654((class_1309)this, 1.6f);
    }

    public boolean method_25938(class_1811 weapon) {
        return weapon == class_1802.field_8399;
    }

    public void equipToMainHand(class_1799 stack) {
        this.method_24834(class_1304.field_6173, stack);
    }

    public void equipToOffHand(class_1799 stack) {
        if (stack.method_31574(PiglinScavengerBrain.BARTERING_ITEM)) {
            this.method_5673(class_1304.field_6171, stack);
            this.method_25939(class_1304.field_6171);
        } else {
            this.method_24834(class_1304.field_6171, stack);
        }
    }

    public boolean method_20820(class_1799 stack) {
        return this.method_37908().method_8450().method_8355(class_1928.field_19388) && this.method_5936() && PiglinScavengerBrain.canGather(this, stack);
    }

    public boolean canEquipStack(class_1799 stack) {
        class_1304 equipmentSlot = this.method_32326(stack);
        class_1799 itemStack = this.method_6118(equipmentSlot);
        return this.method_5955(stack, itemStack);
    }

    protected boolean method_5955(class_1799 newStack, class_1799 oldStack) {
        boolean bl2;
        if (class_1890.method_60142((class_1799)oldStack, (class_9331)class_9701.field_51656)) {
            return false;
        }
        boolean bl = PiglinScavengerBrain.isGoldenItem(newStack) || newStack.method_31574(class_1802.field_8399);
        boolean bl3 = bl2 = PiglinScavengerBrain.isGoldenItem(oldStack) || oldStack.method_31574(class_1802.field_8399);
        if (bl && !bl2) {
            return true;
        }
        if (!bl && bl2) {
            return false;
        }
        return (!this.method_30236() || newStack.method_31574(class_1802.field_8399) || !oldStack.method_31574(class_1802.field_8399)) && super.method_5955(newStack, oldStack);
    }

    protected void method_5949(class_1542 item) {
        this.method_29499(item);
        PiglinScavengerBrain.loot(this, item);
    }

    public boolean method_5873(class_1297 entity, boolean force) {
        if (this.method_6109() && entity.method_5864() == class_1299.field_21973) {
            entity = this.getTopMostPassenger(entity, 3);
        }
        return super.method_5873(entity, force);
    }

    private class_1297 getTopMostPassenger(class_1297 entity, int maxLevel) {
        List list = entity.method_5685();
        return maxLevel != 1 && !list.isEmpty() ? this.getTopMostPassenger((class_1297)list.get(0), maxLevel - 1) : entity;
    }

    protected class_3414 method_5994() {
        return this.method_37908().field_9236 ? null : (class_3414)PiglinScavengerBrain.getCurrentActivitySound(this).orElse(null);
    }

    protected class_3414 method_6011(class_1282 source) {
        return AdventureSounds.ENTITY_PIGLIN_SCAVENGER_HURT;
    }

    protected class_3414 method_6002() {
        return AdventureSounds.ENTITY_PIGLIN_SCAVENGER_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(AdventureSounds.ENTITY_PIGLIN_SCAVENGER_STEP, 0.15f, 1.0f);
    }

    protected void method_30238() {
        this.method_56078(AdventureSounds.ENTITY_PIGLIN_SCAVENGER_CONVERTED_TO_ZOMBIFIED);
    }
}

