/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import net.j677.adventuresmod.config.AdventurersBeyondConfig;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.brain.rekindled.RekindledBrain;
import net.j677.adventuresmod.entity.custom.IgniterEntity;
import net.j677.adventuresmod.item.AdventureItems;
import net.j677.adventuresmod.particle.AdventureParticles;
import net.j677.adventuresmod.sound.AdventureBossMusic;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.j677.adventuresmod.util.AdventureTrackedDataListener;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1890;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4051;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_4582;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.minecraft.class_7995;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class RekindledEntity
extends class_1588
implements class_4582 {
    private int rekindledDeathTime;
    private int deathAnimationTick;
    public class_7094 deathAnimationState = new class_7094();
    public class_7094 emergingAnimationState = new class_7094();
    public final class_4051 closeIgniterPredicate = class_4051.method_36626().method_18418(24.0).method_18424().method_36627();
    private static final class_2940<State> STATE = class_2945.method_12791(RekindledEntity.class, AdventureTrackedDataListener.REKINDLED_STATE);
    private static final class_2940<Integer> OVERHEAT = class_2945.method_12791(RekindledEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> REPAIRED = class_2945.method_12791(RekindledEntity.class, (class_2941)class_2943.field_13323);
    public final class_3213 bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5791).method_5410(true);

    public RekindledEntity(class_1299<? extends RekindledEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6011.method_12778(STATE, (Object)this.getState());
        this.field_6194 = 450;
    }

    public static class_5132.class_5133 createRekindledAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, (double)AdventurersBeyondConfig.REKINDLED_MAX_HEALTH).method_26868(class_5134.field_23724, 5.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STATE, (Object)State.IDLE);
        builder.method_56912(OVERHEAT, (Object)0);
        builder.method_56912(REPAIRED, (Object)false);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return RekindledBrain.create(this, (class_4095<RekindledEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<RekindledEntity> method_18868() {
        return super.method_18868();
    }

    protected class_4095.class_5303<RekindledEntity> method_28306() {
        return class_4095.method_28311(RekindledBrain.MEMORY_MODULES, RekindledBrain.SENSORS);
    }

    protected class_3414 method_5994() {
        return AdventureSounds.ENTITY_REKINDLED_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return AdventureSounds.ENTITY_REKINDLED_HURT;
    }

    protected class_3414 method_6002() {
        return AdventureSounds.ENTITY_REKINDLED_DEATH;
    }

    public State getState() {
        return (State)((Object)this.field_6011.method_12789(STATE));
    }

    public RekindledEntity setState(State state) {
        this.field_6011.method_12778(STATE, (Object)state);
        return this;
    }

    public boolean isInState(State state) {
        return this.getState() == state;
    }

    public void startState(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.setState(State.EMERGING);
                break;
            }
            case 1: {
                this.setState(State.IDLE);
                break;
            }
            case 2: {
                this.setOverheat(1);
                this.knockbackEntities();
                this.setState(State.REPAIRING);
                this.summonIgniters(0.0f);
                this.summonIgniters(1.5707964f);
                this.summonIgniters((float)Math.PI);
                this.summonIgniters(4.712389f);
                this.setRepaired(true);
                break;
            }
            case 3: {
                this.setOverheat(0);
                RekindledBrain.spawnReinforcements(this);
                this.setState(State.OVERHEATED);
                this.method_18868().method_24525(AdventureMemoryModuleTypes.OVERHEATED, (Object)class_3902.field_17274, 120L);
            }
        }
    }

    public int getOverheat() {
        return (Integer)this.field_6011.method_12789(OVERHEAT);
    }

    public void setOverheat(int overheat) {
        this.field_6011.method_12778(OVERHEAT, (Object)overheat);
    }

    public void addOverheat(int overheat) {
        this.setOverheat(this.getOverheat() + overheat);
    }

    public boolean canOverheat() {
        return this.getOverheat() == 3;
    }

    public boolean canAttack() {
        return this.isInState(State.IDLE) && !this.canOverheat();
    }

    public boolean hasRepaired() {
        return (Boolean)this.field_6011.method_12789(REPAIRED);
    }

    public void setRepaired(boolean b) {
        this.field_6011.method_12778(REPAIRED, (Object)b);
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new class_2604((class_1297)this, entityTrackerEntry, this.isInState(State.EMERGING) ? 1 : 0);
    }

    protected void dropItems() {
        int i = 1 + this.field_5974.method_43048(2);
        for (int j = 0; j < i; ++j) {
            class_1542 itemEntity = this.method_5706((class_1935)AdventureItems.MAGMA_TEAR);
            if (itemEntity == null) continue;
            itemEntity.method_5834(true);
            itemEntity.method_6976();
        }
        class_1542 itemEntity = this.method_5706((class_1935)AdventureItems.ASPIRATION_JEWEL);
        if (itemEntity != null) {
            itemEntity.method_5834(true);
            itemEntity.method_6976();
        }
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (packet.method_11166() == 1) {
            this.setState(State.EMERGING);
        }
    }

    public boolean method_5679(class_1282 damageSource) {
        return !this.isOverheated() && !damageSource.method_48789(class_8103.field_42242) || super.method_5679(damageSource);
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean bl = source.method_5529() instanceof class_1657;
        if (source.method_49708(class_8111.field_42325) && bl) {
            this.startState(State.OVERHEATED);
            return false;
        }
        if (this.method_5679(source)) {
            if (!this.method_29504() && bl) {
                this.method_56078(AdventureSounds.ENTITY_REKINDLED_DEFLECT);
            }
            return false;
        }
        return super.method_5643(source, amount);
    }

    boolean isEmerging() {
        return this.getState() == State.EMERGING;
    }

    boolean isOverheated() {
        return this.getState() == State.OVERHEATED;
    }

    public void method_5982() {
    }

    public boolean method_30948() {
        return this.method_5805();
    }

    protected void method_5958() {
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        if (this.rekindledDeathTime >= 0 && this.rekindledDeathTime <= 65 && this.deathAnimationTick > 0) {
            --this.deathAnimationTick;
        }
        this.method_37908().method_16107().method_15396("rekindledBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15405("rekindledActivityUpdate");
        RekindledBrain.updateActivities(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
        if (this.method_6032() <= this.method_6063() / 2.0f && !this.hasRepaired()) {
            this.startState(State.REPAIRING);
        }
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public boolean method_5973(class_1299<?> type) {
        return type == class_1299.field_6097 || type == class_1299.field_6147;
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_59664();
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        if (nbt.method_10577("IsRepairing")) {
            this.setState(State.REPAIRING);
        }
        this.setRepaired(nbt.method_10577("HasRepaired"));
        this.setOverheat(nbt.method_10550("Overheat"));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasRepaired", this.hasRepaired());
        nbt.method_10556("IsRepairing", this.isInState(State.REPAIRING));
        nbt.method_10569("Overheat", this.getOverheat());
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
        player.field_13987.method_14364((class_2596)new class_2770(((class_3414)AdventureBossMusic.COGDANCE.method_27279().comp_349()).method_14833(), class_3419.field_15253));
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (spawnReason == class_3730.field_16461) {
            this.setState(State.EMERGING);
            this.method_18868().method_24525(class_4140.field_38112, (Object)class_3902.field_17274, (long)RekindledBrain.EMERGE_DURATION);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
    }

    public class_243 method_18798() {
        return class_243.field_1353;
    }

    public void method_18799(class_243 velocity) {
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5697(class_1297 entity) {
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.deathAnimationState.method_45317(this.method_29504(), this.field_6012);
            if (Objects.requireNonNull(this.getState()) == State.EMERGING) {
                this.addDigParticles(this.emergingAnimationState);
            } else if (Objects.requireNonNull(this.getState()) != State.OVERHEATED && !this.method_29504()) {
                this.addSmokeParticles();
            }
            if (this.isInState(State.OVERHEATED)) {
                this.addOverheatParticles();
            }
        } else {
            int i = this.method_37908().method_18466(IgniterEntity.class, this.closeIgniterPredicate, (class_1309)this, this.method_5829().method_1014(24.0)).stream().filter(IgniterEntity::isLit).toList().size();
            if (i > 0 && this.isInState(State.REPAIRING)) {
                if (this.field_6012 % 10 == 0 && this.method_6032() <= this.method_6063() / 2.0f + 70.0f) {
                    this.method_6025(2.0f);
                }
            } else if (i == 0 && this.isInState(State.REPAIRING)) {
                this.startState(State.OVERHEATED);
            }
        }
    }

    private void addDigParticles(class_7094 animationState) {
        if ((float)animationState.method_43687() < 4500.0f) {
            class_5819 random = this.method_59922();
            class_2680 blockState = this.method_25936();
            if (blockState.method_26217() != class_2464.field_11455) {
                for (int i = 0; i < 30; ++i) {
                    double d = this.method_23317() + (double)class_3532.method_32750((class_5819)random, (float)-3.2f, (float)3.2f);
                    double e = this.method_23318();
                    double f = this.method_23321() + (double)class_3532.method_32750((class_5819)random, (float)-3.2f, (float)3.2f);
                    this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), d, e, f, 0.0, 0.5, 0.0);
                }
            }
        }
    }

    private void addSmokeParticles() {
        for (int i = 0; i < 3; ++i) {
            this.method_37908().method_8494((class_2394)class_2398.field_11237, this.method_23317() + (double)this.method_58149().method_10165() + 0.95, this.method_23318() + 9.7, this.method_23321(), 0.0, 0.2, 0.0);
            this.method_37908().method_8494((class_2394)class_2398.field_11237, this.method_23317() + (double)this.method_58149().method_10165() - 2.95, this.method_23318() + 10.0, this.method_23321(), 0.0, 0.2, 0.0);
        }
    }

    public void addPreAttackParticles() {
        for (int i = 0; i < 30; ++i) {
            double d = (double)(2.0f * this.field_5974.method_43057() - 1.0f) * 0.65;
            double e = (double)(2.0f * this.field_5974.method_43057() - 1.0f) * 0.65;
            double f = this.method_23317() + 0.5 + d;
            double g = this.method_23318() + 10.1 + (double)this.field_5974.method_43057() * 0.8;
            double h = this.method_23321() + 0.5 + e;
            this.method_37908().method_8406((class_2394)class_2398.field_47493, f, g, h, 0.0, 0.0, 0.0);
        }
    }

    private void addOverheatParticles() {
        for (int i = 0; i < 3; ++i) {
            this.method_37908().method_8494((class_2394)class_2398.field_11237, this.method_23317() + 2.7, this.method_23318() + 1.0, this.method_23325(0.2), 0.0, 0.2, 0.0);
            this.method_37908().method_8494((class_2394)class_2398.field_11237, this.method_23317() - 2.7, this.method_23318() + 1.0, this.method_23325(0.2), 0.0, 0.2, 0.0);
            this.method_37908().method_8494((class_2394)class_2398.field_11237, this.method_23322(0.4), this.method_23318() + 1.0, this.method_23321() + 1.7, 0.0, 0.2, 0.0);
            this.method_37908().method_8494((class_2394)class_2398.field_11237, this.method_23322(0.4), this.method_23318() + 1.0, this.method_23321() - 1.7, 0.0, 0.2, 0.0);
        }
    }

    public void method_5674(class_2940<?> data) {
        if (STATE.equals(data) && Objects.requireNonNull(this.getState()) == State.EMERGING) {
            this.emergingAnimationState.method_41322(this.field_6012);
        }
        super.method_5674(data);
    }

    public boolean method_5659(class_1927 explosion) {
        return this.isEmerging();
    }

    protected void method_6108() {
        ++this.rekindledDeathTime;
        ++this.deathAnimationTick;
        this.addDigParticles(this.deathAnimationState);
        float f = (this.field_5974.method_43057() - 0.5f) * 3.0f;
        float g = (this.field_5974.method_43057() - 0.5f) * 8.0f;
        float h = (this.field_5974.method_43057() - 0.5f) * 3.0f;
        this.method_37908().method_8406((class_2394)class_2398.field_11236, this.method_23317() + (double)f, this.method_23318() + 0.5 + (double)g, this.method_23321() + (double)h, 0.0, 0.0, 0.0);
        if (this.rekindledDeathTime == 80 && this.method_37908() instanceof class_3218) {
            this.method_5650(class_1297.class_5529.field_26998);
            this.method_32876((class_6880)class_5712.field_37676);
            this.dropItems();
        }
    }

    public Optional<class_1309> getHurtBy() {
        return this.method_18868().method_18904(class_4140.field_18451).map(class_1282::method_5529).filter(attacker -> attacker instanceof class_1309).map(livingAttacker -> (class_1309)livingAttacker);
    }

    public void summonIgniters(float f) {
        this.method_37908().method_8649((class_1297)new IgniterEntity(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), 3, (class_1309)this, f));
        this.method_37908().method_32888((class_6880)class_5712.field_28738, new class_243(this.method_23317(), this.method_23318(), this.method_23321()), class_5712.class_7397.method_43285((class_1297)this));
    }

    public void knockbackEntities() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_1309 target : this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(4.0), class_1301.field_6156)) {
                if (target instanceof IgniterEntity || target instanceof RekindledEntity) continue;
                double f = target.method_23317() - this.method_23317();
                double g = target.method_23321() - this.method_23321();
                double h = Math.max(f * f + g * g, 0.1);
                target.method_5762(f / h * 12.0, (double)0.3f, g / h * 12.0);
                class_1282 damageSource = this.method_48923().method_48812((class_1309)this);
                target.method_5643(damageSource, 3.0f);
                class_1890.method_60107((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource);
            }
            serverWorld.method_14199((class_2394)AdventureParticles.EXPLOSION_DUST, this.method_23317(), this.method_23318() + 0.2, this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean method_6872() {
        return this.isInState(State.REPAIRING);
    }

    public static enum State {
        EMERGING(0),
        IDLE(1),
        REPAIRING(2),
        OVERHEATED(3);

        public static final IntFunction<State> INDEX_TO_VALUE;
        public static final class_9139<ByteBuf, State> PACKET_CODEC;
        private final int index;

        private State(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        static {
            INDEX_TO_VALUE = class_7995.method_47914(State::getIndex, (Object[])State.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            PACKET_CODEC = class_9135.method_56375(INDEX_TO_VALUE, State::getIndex);
        }
    }
}

