/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.j677.adventuresmod.config.AdventurersBeyondConfig;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.j677.adventuresmod.entity.custom.RunestoneShardEntity;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5362;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8046;
import net.minecraft.class_9749;
import org.jetbrains.annotations.Nullable;

public class RunestoneCrystalEntity
extends class_1297
implements class_8046 {
    private static final class_2940<Boolean> IS_VOLATILE = class_2945.method_12791(RunestoneCrystalEntity.class, (class_2941)class_2943.field_13323);
    public static final class_5362 EXPLOSION_BEHAVIOR = new class_9749(false, true, Optional.empty(), class_7923.field_41175.method_40266(class_3481.field_49051).map(Function.identity()));
    private int warmup;
    private boolean startedAttack;
    private int ticksLeft = 30;
    private boolean playingAnimation;
    @Nullable
    private class_1309 owner;
    @Nullable
    private UUID ownerUuid;

    public RunestoneCrystalEntity(class_1299<? extends RunestoneCrystalEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public RunestoneCrystalEntity(class_1937 world, double x, double y, double z, float yaw, int warmup, class_1309 owner, boolean isVolatile) {
        this(AdventureEntityTypes.RUNESTONE_CRYSTAL, world);
        this.warmup = warmup;
        this.setOwner(owner);
        this.method_36456(yaw * 57.295776f);
        this.method_5814(x, y, z);
        this.setVolatile(isVolatile);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(IS_VOLATILE, (Object)false);
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.method_5667();
    }

    @Nullable
    public class_1309 getOwner() {
        class_1297 entity;
        if (this.owner == null && this.ownerUuid != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUuid)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    public void setVolatile(boolean isVolatile) {
        this.field_6011.method_12778(IS_VOLATILE, (Object)isVolatile);
    }

    public boolean isVolatile() {
        return (Boolean)this.field_6011.method_12789(IS_VOLATILE);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    protected void method_5749(class_2487 nbt) {
        this.warmup = nbt.method_10550("Warmup");
        if (nbt.method_25928("Owner")) {
            this.ownerUuid = nbt.method_25926("Owner");
        }
        this.setVolatile(nbt.method_10577("IsVolatile"));
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10569("Warmup", this.warmup);
        if (this.ownerUuid != null) {
            nbt.method_25927("Owner", this.ownerUuid);
        }
        nbt.method_10556("IsVolatile", this.isVolatile());
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            if (this.playingAnimation) {
                --this.ticksLeft;
                if (this.ticksLeft == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d = this.method_23317() + (this.field_5974.method_43058() * 2.0 - 1.0) * (double)this.method_17681() * 0.5;
                        double e = this.method_23318() + 0.05 + this.field_5974.method_43058();
                        double f = this.method_23321() + (this.field_5974.method_43058() * 2.0 - 1.0) * (double)this.method_17681() * 0.5;
                        double g = (this.field_5974.method_43058() * 2.0 - 1.0) * 0.3;
                        double h = 0.3 + this.field_5974.method_43058() * 0.3;
                        double j = (this.field_5974.method_43058() * 2.0 - 1.0) * 0.3;
                        this.method_37908().method_8406((class_2394)class_2398.field_11207, d, e + 1.0, f, g, h, j);
                    }
                }
            }
        } else if (--this.warmup < 0) {
            if (this.warmup == -8) {
                for (class_1309 livingEntity : this.method_37908().method_18467(class_1309.class, this.method_5829().method_1009(0.2, 0.0, 0.2))) {
                    this.damage(livingEntity);
                }
            }
            if (!this.startedAttack) {
                this.method_37908().method_8421((class_1297)this, (byte)4);
                this.startedAttack = true;
            }
            if (--this.ticksLeft < 0) {
                if (this.isVolatile()) {
                    this.method_37908().method_8454((class_1297)this, this.method_48923().method_48831(), EXPLOSION_BEHAVIOR, this.method_23317(), this.method_23318(), this.method_23321(), 2.0f, false, class_1937.class_7867.field_51779, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880)class_3417.field_15152);
                    for (int i = 0; i < 12; ++i) {
                        RunestoneShardEntity projectile = new RunestoneShardEntity(this.method_37908(), this.getOwner());
                        float b0 = class_3532.method_15344((class_5819)this.method_59922(), (float)5.0f, (float)10.0f);
                        float b1 = class_3532.method_15344((class_5819)this.method_59922(), (float)1.0f, (float)8.0f);
                        double b2 = (double)class_3532.method_15344((class_5819)this.method_59922(), (float)0.0f, (float)2.0f) * Math.PI;
                        double x = b1 * class_3532.method_15362((float)((float)b2));
                        double z = b1 * class_3532.method_15374((float)((float)b2));
                        double y = (double)class_3532.method_27285((float)b0) / 10.0;
                        projectile.method_5814(this.method_23317(), this.method_23318() + 2.0, this.method_23321());
                        projectile.method_7485(x, y, z, 0.7f, 14 - this.method_37908().method_8407().method_5461() * 4);
                        this.method_37908().method_8649((class_1297)projectile);
                    }
                    this.method_31472();
                }
                this.method_31472();
            }
        }
    }

    private void damage(class_1309 target) {
        class_1309 livingEntity = this.getOwner();
        if (target.method_5805() && !target.method_5655() && target != livingEntity) {
            if (livingEntity == null) {
                target.method_5643(this.method_48923().method_48831(), 6.0f);
            } else {
                class_1937 class_19372;
                if (livingEntity.method_5722((class_1297)target)) {
                    return;
                }
                class_1282 damageSource = this.method_48923().method_48815((class_1297)this, (class_1297)livingEntity);
                if (target.method_5643(damageSource, AdventurersBeyondConfig.RUNESTONE_CRYSTAL_DAMAGE) && (class_19372 = this.method_37908()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_1890.method_60107((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource);
                }
            }
        }
    }

    public void method_5711(byte status) {
        super.method_5711(status);
        if (status == 4) {
            this.playingAnimation = true;
            if (!this.method_5701()) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_26979, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float tickDelta) {
        if (!this.playingAnimation) {
            return 0.0f;
        }
        int i = this.ticksLeft - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - tickDelta) / 20.0f;
    }
}

