/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import net.j677.adventuresmod.config.AdventurersBeyondConfig;
import net.j677.adventuresmod.entity.brain.golem.RunestoneGolemBrain;
import net.j677.adventuresmod.entity.custom.BlightCrystalEntity;
import net.j677.adventuresmod.item.AdventureItems;
import net.j677.adventuresmod.particle.AdventureParticles;
import net.j677.adventuresmod.sound.AdventureBossMusic;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.j677.adventuresmod.util.AdventureTrackedDataListener;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1427;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1665;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_4582;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7995;
import net.minecraft.class_8103;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class RunestoneGolemEntity
extends class_1427
implements class_1569,
class_4582 {
    public int ticksSinceDeath;
    public final class_4051 closeCrystalPredicate = class_4051.method_36626().method_18418(35.0).method_18424().method_36627();
    private static final class_2940<State> STATE = class_2945.method_12791(RunestoneGolemEntity.class, AdventureTrackedDataListener.RUNESTONE_GOLEM_STATE);
    private static final class_2940<Boolean> IS_PHASE2 = class_2945.method_12791(RunestoneGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_PLAYING_DEATH_ANIMATION = class_2945.method_12791(RunestoneGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_DONE_FAKE_DEATH = class_2945.method_12791(RunestoneGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_CRYSTALS = class_2945.method_12791(RunestoneGolemEntity.class, (class_2941)class_2943.field_13323);
    public final class_3213 bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5791).method_5410(true);
    public class_7094 heavyAttackAnimationState = new class_7094();
    public class_7094 stompAttackAnimationState = new class_7094();
    public class_7094 runicAttackStartAnimationState = new class_7094();
    public class_7094 runicAttackStopAnimationState = new class_7094();
    public class_7094 fakeDeathAnimationState = new class_7094();
    public class_7094 deathAnimationsState = new class_7094();

    public RunestoneGolemEntity(class_1299<? extends RunestoneGolemEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 450;
        this.field_6011.method_12778(STATE, (Object)this.getState());
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_36432, -1.0f);
        this.method_5941(class_7.field_43351, -1.0f);
    }

    public static class_5132.class_5133 createRunestoneGolemAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, (double)AdventurersBeyondConfig.RUNESTONE_GOLEM_MAX_HEALTH).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23723, (double)0.7f).method_26868(class_5134.field_23721, (double)AdventurersBeyondConfig.RUNESTONE_GOLEM_ATTACK_DAMAGE).method_26868(class_5134.field_23718, 2.0).method_26868(class_5134.field_23717, 40.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(STATE, (Object)State.IDLING);
        builder.method_56912(IS_PHASE2, (Object)false);
        builder.method_56912(IS_PLAYING_DEATH_ANIMATION, (Object)false);
        builder.method_56912(HAS_DONE_FAKE_DEATH, (Object)false);
        builder.method_56912(HAS_CRYSTALS, (Object)false);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return RunestoneGolemBrain.create(this, (class_4095<RunestoneGolemEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<RunestoneGolemEntity> method_18868() {
        return super.method_18868();
    }

    protected class_4095.class_5303<RunestoneGolemEntity> method_28306() {
        return class_4095.method_28311(RunestoneGolemBrain.MEMORY_MODULES, RunestoneGolemBrain.SENSORS);
    }

    public void setSecondPhase(boolean phase2) {
        this.field_6011.method_12778(IS_PHASE2, (Object)phase2);
    }

    public boolean isInSecondPhase() {
        return (Boolean)this.field_6011.method_12789(IS_PHASE2);
    }

    public void setIsPlayingDeathAnim(boolean bl) {
        this.field_6011.method_12778(IS_PLAYING_DEATH_ANIMATION, (Object)bl);
    }

    public boolean isPlayingDeathAnim() {
        return (Boolean)this.field_6011.method_12789(IS_PLAYING_DEATH_ANIMATION);
    }

    public void setHasDoneFakeDeathAnimation(boolean bl) {
        this.field_6011.method_12778(HAS_DONE_FAKE_DEATH, (Object)bl);
    }

    public boolean hasDoneFakeDeathAnimation() {
        return (Boolean)this.field_6011.method_12789(HAS_DONE_FAKE_DEATH);
    }

    public void setHasCrystals(boolean hasCrystals) {
        this.field_6011.method_12778(HAS_CRYSTALS, (Object)hasCrystals);
    }

    public boolean hasCrystals() {
        return (Boolean)this.field_6011.method_12789(HAS_CRYSTALS);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("GolemDeathTime", this.ticksSinceDeath);
        nbt.method_10582("State", this.getState().method_15434());
        nbt.method_10556("IsInSecondPhase", this.isInSecondPhase());
        nbt.method_10556("hasCrystals", this.hasCrystals());
        nbt.method_10556("HasDoneFakeDeathAnimation", this.hasDoneFakeDeathAnimation());
        nbt.method_10556("IsPlayingDeathAnim", this.isPlayingDeathAnim());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        if (nbt.method_10545("GolemDeathTime")) {
            this.ticksSinceDeath = nbt.method_10550("GolemDeathTime");
        }
        this.setState(State.fromName(nbt.method_10558("State")));
        this.setSecondPhase(nbt.method_10577("IsInSecondPhase"));
        this.setHasCrystals(nbt.method_10577("hasCrystals"));
        this.setHasDoneFakeDeathAnimation(nbt.method_10577("HasDoneFakeDeathAnimation"));
        this.setIsPlayingDeathAnim(nbt.method_10577("IsPlayingDeathAnim"));
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
        player.field_13987.method_14364((class_2596)new class_2770(((class_3414)AdventureBossMusic.HAYWIRE.method_27279().comp_349()).method_14833(), class_3419.field_15253));
    }

    public State getState() {
        return (State)((Object)this.field_6011.method_12789(STATE));
    }

    public RunestoneGolemEntity setState(State state) {
        this.field_6011.method_12778(STATE, (Object)state);
        return this;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.bossBar.method_5410(true);
        RunestoneGolemBrain.setArenaCenterPos(this);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void knockbackEntities() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_1309 target : this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(4.0), class_1301.field_6156)) {
                if (target instanceof BlightCrystalEntity || target instanceof RunestoneGolemEntity) continue;
                double f = target.method_23317() - this.method_23317();
                double g = target.method_23321() - this.method_23321();
                double h = Math.max(f * f + g * g, 0.1);
                target.method_5762(f / h * 8.0, (double)0.3f, g / h * 8.0);
                class_1282 damageSource = this.method_48923().method_48812((class_1309)this);
                target.method_5643(damageSource, 1.0f);
                class_1890.method_60107((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource);
            }
            serverWorld.method_14199((class_2394)AdventureParticles.EXPLOSION_DUST, this.method_23317(), this.method_23318() + 0.2, this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void method_5674(class_2940<?> data) {
        if (STATE.equals(data)) {
            State state = this.getState();
            this.stopAnimations();
            switch (state.ordinal()) {
                case 1: {
                    this.stompAttackAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 2: {
                    this.heavyAttackAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 3: {
                    this.runicAttackStartAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 4: {
                    this.runicAttackStopAnimationState.method_41324(this.field_6012);
                    break;
                }
                case 5: {
                    this.fakeDeathAnimationState.method_41324(this.field_6012);
                }
            }
            this.method_18382();
        }
        super.method_5674(data);
    }

    private void stopAnimations() {
        this.stompAttackAnimationState.method_41325();
        this.heavyAttackAnimationState.method_41325();
        this.runicAttackStartAnimationState.method_41325();
        this.runicAttackStopAnimationState.method_41325();
        this.fakeDeathAnimationState.method_41325();
    }

    public void startState(State state) {
        switch (state.ordinal()) {
            case 0: {
                this.setState(State.IDLING);
                break;
            }
            case 1: {
                this.setState(State.STOMP_ATTACK);
                break;
            }
            case 2: {
                this.setState(State.HEAVY_ATTACK);
                break;
            }
            case 3: {
                this.setState(State.RUNIC_ATTACK_START);
                break;
            }
            case 4: {
                this.setState(State.RUNIC_ATTACK_STOP);
                break;
            }
            case 5: {
                this.setState(State.FAKE_DEATH);
            }
        }
    }

    protected void method_5712(class_2338 pos, class_2680 blockState) {
        this.method_5783(class_3417.field_15233, 0.15f, 1.0f);
    }

    protected class_3414 method_5994() {
        return AdventureSounds.ENTITY_RUNESTONE_GOLEM_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return AdventureSounds.ENTITY_RUNESTONE_GOLEM_HURT;
    }

    protected class_3414 method_6002() {
        return AdventureSounds.ENTITY_RUNESTONE_GOLEM_DEATH;
    }

    public void method_5982() {
    }

    protected void method_5958() {
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        this.method_37908().method_16107().method_15396("runestoneGolemBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        RunestoneGolemBrain.tick(this);
        if (this.hasDoneFakeDeathAnimation()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.25);
            if (this.getRemainingCrystals() > 0 && this.field_6012 % 20 == 0) {
                this.method_6025(this.getRemainingCrystals());
            }
        }
        super.method_5958();
    }

    public int getRemainingCrystals() {
        return this.method_37908().method_18466(BlightCrystalEntity.class, this.closeCrystalPredicate, (class_1309)this, this.method_5829().method_1014(35.0)).size();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public boolean method_5679(class_1282 damageSource) {
        return this.isPlayingDeathAnim() && !damageSource.method_48789(class_8103.field_42242) || super.method_5679(damageSource);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 entity = source.method_5526();
        if (entity instanceof class_1665) {
            return false;
        }
        if (!source.method_48789(class_8103.field_42242)) {
            if (this.getRemainingCrystals() > 0) {
                return super.method_5643(source, (float)(6 - this.getRemainingCrystals()));
            }
            return super.method_5643(source, amount);
        }
        return super.method_5643(source, amount);
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        super.method_6099(world, source, causedByPlayer);
        int i = 1 + this.field_5974.method_43048(2);
        for (int j = 0; j < i; ++j) {
            class_1542 itemEntity = this.method_5706((class_1935)AdventureItems.RUNESTONE_SLATE);
            if (itemEntity == null) continue;
            itemEntity.method_5834(true);
            itemEntity.method_6976();
        }
    }

    public Optional<class_1309> getHurtBy() {
        return this.method_18868().method_18904(class_4140.field_18451).map(class_1282::method_5529).filter(attacker -> attacker instanceof class_1309).map(livingAttacker -> (class_1309)livingAttacker);
    }

    public void method_6078(class_1282 damageSource) {
        if (!this.isInSecondPhase() && !damageSource.method_48789(class_8103.field_42242)) {
            this.method_6033(5.0f);
            this.setSecondPhase(true);
        } else {
            this.field_6213 = -30;
            this.deathAnimationsState.method_41322(this.field_6012);
            this.startState(State.IDLING);
            super.method_6078(damageSource);
        }
    }

    protected void method_6108() {
        ++this.ticksSinceDeath;
        if (this.ticksSinceDeath == 60 && this.method_37908() instanceof class_3218) {
            this.method_5650(class_1297.class_5529.field_26998);
            this.method_32876((class_6880)class_5712.field_37676);
        }
    }

    public boolean method_6872() {
        return this.getRemainingCrystals() > 0;
    }

    public void placeCrystalsAtLocations(RunestoneGolemEntity golem, double x, double z, double maxY, double y) {
        this.spawnCrystals(golem, x + 8.0, z + 8.0, maxY, y);
        this.spawnCrystals(golem, x + 8.0, z - 8.0, maxY, y);
        this.spawnCrystals(golem, x - 8.0, z + 8.0, maxY, y);
        this.spawnCrystals(golem, x - 8.0, z - 8.0, maxY, y);
    }

    private void spawnCrystals(RunestoneGolemEntity golem, double x, double z, double maxY, double y) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        boolean bl = false;
        double d = 0.0;
        do {
            class_2680 blockState2;
            class_265 voxelShape;
            class_2338 blockPos2 = blockPos.method_10074();
            class_2680 blockState = golem.method_37908().method_8320(blockPos2);
            if (!blockState.method_26206((class_1922)golem.method_37908(), blockPos2, class_2350.field_11036)) continue;
            if (!golem.method_37908().method_22347(blockPos) && !(voxelShape = (blockState2 = golem.method_37908().method_8320(blockPos)).method_26220((class_1922)golem.method_37908(), blockPos)).method_1110()) {
                d = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)maxY) - 1);
        if (bl) {
            golem.method_37908().method_8649((class_1297)new BlightCrystalEntity(golem.method_37908(), x, (double)blockPos.method_10264() + d, z, (class_1309)golem));
        }
    }

    public static enum State implements class_3542
    {
        IDLING("idling", 0),
        STOMP_ATTACK("stomp_attack", 1),
        HEAVY_ATTACK("heavy_attack", 2),
        RUNIC_ATTACK_START("runic_attack_start", 3),
        RUNIC_ATTACK_STOP("runic_attack_stop", 4),
        FAKE_DEATH("fake_death", 5);

        private static final class_3542.class_7292<State> CODEC;
        public static final IntFunction<State> INDEX_TO_VALUE;
        public static final class_9139<ByteBuf, State> PACKET_CODEC;
        private final String name;
        private final int index;

        private State(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public static State fromName(String name) {
            return (State)CODEC.method_47920(name, (Enum)IDLING);
        }

        public String method_15434() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        static {
            CODEC = class_3542.method_28140(State::values);
            INDEX_TO_VALUE = class_7995.method_47914(State::getIndex, (Object[])State.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            PACKET_CODEC = class_9135.method_56375(INDEX_TO_VALUE, State::getIndex);
        }
    }
}

