/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.function.IntFunction;
import net.j677.adventuresmod.entity.brain.AdventureMemoryModuleTypes;
import net.j677.adventuresmod.entity.brain.AdventureSensorTypes;
import net.j677.adventuresmod.entity.brain.SlablingBrain;
import net.j677.adventuresmod.sound.AdventureSounds;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1427;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5996;
import net.minecraft.class_6067;
import net.minecraft.class_7225;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;

public class SlablingEntity
extends class_1427
implements class_6067 {
    private static final class_2940<Byte> PERSONALITY = class_2945.method_12791(SlablingEntity.class, (class_2941)class_2943.field_13319);
    private final class_1277 inventory = new class_1277(8);
    protected static final ImmutableList<class_4149<? extends class_4148<? super SlablingEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_18469, AdventureSensorTypes.SLABLING_SPECIFIC_SENSOR);
    protected static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18444, (Object)class_4140.field_22332, (Object)class_4140.field_38397, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_22355, (Object)class_4140.field_22475, (Object[])new class_4140[]{class_4140.field_18447, class_4140.field_18449, class_4140.field_22357, class_4140.field_22334, class_4140.field_25813, class_4140.field_22473, class_4140.field_25814, class_4140.field_22349, AdventureMemoryModuleTypes.NEAREST_VISIBLE_SLABLINGS});

    public SlablingEntity(class_1299<? extends SlablingEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5952(true);
    }

    public static class_5132.class_5133 createSlablingAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 12.0).method_26868(class_5134.field_23719, (double)0.35f).method_26868(class_5134.field_23723, (double)0.9f).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 18.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PERSONALITY, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Personality", this.getPersonality().method_15434());
        this.method_46399(nbt, (class_7225.class_7874)this.method_56673());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setPersonality(Personality.byName(nbt.method_10558("Personality")));
        this.method_46400(nbt, (class_7225.class_7874)this.method_56673());
    }

    @class_5996
    public class_1277 method_35199() {
        return this.inventory;
    }

    public class_1799 addItem(class_1799 stack) {
        return this.inventory.method_5491(stack);
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        super.method_6099(world, source, causedByPlayer);
        this.inventory.method_24514().forEach(arg_0 -> ((SlablingEntity)this).method_5775(arg_0));
    }

    public boolean method_5974(double distanceSquared) {
        return !this.method_5947();
    }

    protected class_4095.class_5303<SlablingEntity> method_28306() {
        return class_4095.method_28311(MEMORY_MODULES, SENSORS);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return SlablingBrain.create((class_4095<SlablingEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<SlablingEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("slablingBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        SlablingBrain.updateActivities(this);
        super.method_5958();
    }

    public static boolean canSpawn(class_1299<SlablingEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return random.method_43048(3) != 0;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1269 actionResult = super.method_5992(player, hand);
        if (actionResult.method_23665()) {
            return actionResult;
        }
        if (!this.method_37908().field_9236) {
            return SlablingBrain.playerInteract(this, player, hand);
        }
        boolean bl = SlablingBrain.isWillingToTrade(this, player.method_5998(hand)) && this.getActivity() != SlablingActivity.ADMIRING_ITEM;
        return bl ? class_1269.field_5812 : class_1269.field_5811;
    }

    public SlablingActivity getActivity() {
        if (SlablingBrain.isLovedItem(this.method_6079())) {
            return SlablingActivity.ADMIRING_ITEM;
        }
        return SlablingActivity.DEFAULT;
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean bl = super.method_5643(source, amount);
        if (this.method_37908().field_9236) {
            return false;
        }
        if (bl && source.method_5529() instanceof class_1309) {
            SlablingBrain.onAttacked(this, (class_1309)source.method_5529());
        }
        return bl;
    }

    public void equipToOffHand(class_1799 stack) {
        if (stack.method_31574(SlablingBrain.BARTERING_ITEM)) {
            this.method_5673(class_1304.field_6171, stack);
            this.method_25939(class_1304.field_6171);
        }
    }

    public boolean method_20820(class_1799 stack) {
        return this.method_37908().method_8450().method_8355(class_1928.field_19388) && this.method_5936() && SlablingBrain.canGather(this, stack);
    }

    protected void method_5949(class_1542 item) {
        this.method_29499(item);
        SlablingBrain.loot(this, item);
    }

    public Personality getPersonality() {
        return Personality.byId(((Byte)this.field_6011.method_12789(PERSONALITY)).byteValue());
    }

    public void setPersonality(Personality personality) {
        if (personality.getId() > 6) {
            personality = Personality.createRandom(this.field_5974);
        }
        this.field_6011.method_12778(PERSONALITY, (Object)((byte)personality.getId()));
    }

    public boolean isTired() {
        return this.getPersonality() == Personality.TIRED;
    }

    public boolean isPlayful() {
        return this.getPersonality() == Personality.PLAYFUL;
    }

    public boolean isSad() {
        return this.getPersonality() == Personality.SAD;
    }

    public boolean isChaotic() {
        return this.getPersonality() == Personality.CHAOTIC;
    }

    public void resetAttributes() {
        if (this.isTired()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192((double)0.27f);
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(9.0);
        }
        if (this.isSad()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.25);
        }
        if (this.isChaotic()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(15.0);
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192((double)0.4f);
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_5819 random = world.method_8409();
        this.setPersonality(Personality.createRandom(random));
        this.resetAttributes();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected class_3414 method_5994() {
        return AdventureSounds.ENTITY_SLABLING_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return AdventureSounds.ENTITY_SLABLING_HURT;
    }

    protected class_3414 method_6002() {
        return AdventureSounds.ENTITY_SLABLING_DEATH;
    }

    public static enum Personality implements class_3542
    {
        NORMAL(0, "normal"),
        ANGRY(1, "angry"),
        CHAOTIC(2, "chaotic"),
        PLAYFUL(3, "playful"),
        SAD(4, "sad"),
        TIRED(5, "tired"),
        CURIOUS(6, "curious"),
        SCARED(7, "scared");

        public static final class_3542.class_7292<Personality> CODEC;
        private static final IntFunction<Personality> BY_ID;
        private final int id;
        private final String name;

        private Personality(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String method_15434() {
            return this.name;
        }

        public static Personality byId(int id) {
            return BY_ID.apply(id);
        }

        public static Personality byName(String name) {
            return (Personality)CODEC.method_47920(name, (Enum)NORMAL);
        }

        public static Personality createRandom(class_5819 random) {
            int i = random.method_43048(10);
            if (i == 0) {
                return ANGRY;
            }
            if (i == 1) {
                return CHAOTIC;
            }
            if (i == 2) {
                return PLAYFUL;
            }
            if (i == 4) {
                return TIRED;
            }
            if (i == 5) {
                return CURIOUS;
            }
            if (i == 6) {
                return SCARED;
            }
            return i == 7 ? SAD : NORMAL;
        }

        static {
            CODEC = class_3542.method_28140(Personality::values);
            BY_ID = class_7995.method_47914(Personality::getId, (Object[])Personality.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        }
    }

    public static enum SlablingActivity {
        ADMIRING_ITEM,
        DEFAULT;

    }
}

