/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.entity.custom;

import java.util.List;
import java.util.UUID;
import net.j677.adventuresmod.entity.AdventureEntityTypes;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public class WhirlpoolEntity
extends class_1297
implements class_8046 {
    private static final class_2940<Float> RADIUS = class_2945.method_12791(WhirlpoolEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> WAITING = class_2945.method_12791(WhirlpoolEntity.class, (class_2941)class_2943.field_13323);
    private int duration = 600;
    private int waitTime = 20;
    private float dealtDamage;
    @Nullable
    private class_1309 owner;
    @Nullable
    private UUID ownerUuid;
    private float radiusOnSummon;
    private float radiusGrowth;
    private float animRadius;

    public WhirlpoolEntity(class_1299<? extends WhirlpoolEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5960 = true;
    }

    public WhirlpoolEntity(class_1937 world, double x, double y, double z, float dealtDamage) {
        this(AdventureEntityTypes.WHIRLPOOL, world);
        this.dealtDamage = dealtDamage;
        this.method_5814(x, y, z);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(RADIUS, (Object)Float.valueOf(3.0f));
        builder.method_56912(WAITING, (Object)false);
    }

    public void setRadius(float radius) {
        if (!this.method_37908().field_9236) {
            this.method_5841().method_12778(RADIUS, (Object)Float.valueOf(class_3532.method_15363((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    public float getRadius() {
        return ((Float)this.method_5841().method_12789(RADIUS)).floatValue();
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.method_5667();
    }

    @Nullable
    public class_1309 getOwner() {
        class_1297 entity;
        if (this.owner == null && this.ownerUuid != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUuid)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    protected void method_5749(class_2487 nbt) {
        this.field_6012 = nbt.method_10550("Age");
        this.duration = nbt.method_10550("Duration");
        this.waitTime = nbt.method_10550("WaitTime");
        this.radiusOnSummon = nbt.method_10583("RadiusOnSummon");
        this.radiusGrowth = nbt.method_10583("RadiusPerTick");
        this.animRadius = nbt.method_10583("AnimationsRadius");
        this.setRadius(nbt.method_10583("Radius"));
        if (nbt.method_25928("Owner")) {
            this.ownerUuid = nbt.method_25926("Owner");
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10569("Age", this.field_6012);
        nbt.method_10569("Duration", this.duration);
        nbt.method_10569("WaitTime", this.waitTime);
        nbt.method_10548("RadiusOnSummon", this.radiusOnSummon);
        nbt.method_10548("RadiusPerTick", this.radiusGrowth);
        nbt.method_10548("AnimationRadius", this.animRadius);
        nbt.method_10548("Radius", this.getRadius());
        if (this.ownerUuid != null) {
            nbt.method_25927("Owner", this.ownerUuid);
        }
    }

    public void method_5773() {
        super.method_5773();
        boolean bl = this.isWaiting();
        float f = this.getRadius();
        for (class_1657 target : this.method_37908().method_8390(class_1657.class, this.method_5829().method_1009(20.0, 0.0, 20.0), class_1301.field_6156)) {
            double vecZ;
            double vecX;
            double v;
            double z;
            double x;
            if (target == this.getOwner()) continue;
            if (this.method_5739((class_1297)target) > 5.0f) {
                x = target.method_23317() - this.method_19538().method_10216();
                z = target.method_23321() - this.method_19538().method_10215();
                v = Math.pow(x, 2.0) + Math.pow(z, 2.0);
                vecX = -2.0 * x / (Math.pow((double)class_3532.method_15355((float)((float)v)) / 2.0, 4.0) + 1.0);
                vecZ = -2.0 * z / (Math.pow((double)class_3532.method_15355((float)((float)v)) / 2.0, 4.0) + 1.0);
                target.method_5762(vecX, 0.0, vecZ);
                continue;
            }
            x = target.method_23317() - this.method_19538().method_10216();
            z = target.method_23321() - this.method_19538().method_10215();
            v = Math.pow(z, 2.0) + Math.pow(x, 2.0);
            vecX = -2.0 * x / (Math.pow((double)class_3532.method_15355((float)((float)v)) / 2.0, 4.0) + 1.0);
            vecZ = -2.0 * z / (Math.pow((double)class_3532.method_15355((float)((float)v)) / 2.0, 4.0) + 1.0);
            double spinX = -2.0 * z / (Math.pow((double)class_3532.method_15355((float)((float)v)) / 2.0, 3.0) + 1.0);
            double spinZ = 2.0 * x / (Math.pow((double)class_3532.method_15355((float)((float)v)) / 2.0, 3.0) + 1.0);
            target.method_18800(spinX - vecX / 1.75, 0.3, spinZ - vecZ / 1.75);
        }
        if (this.method_37908().field_9236) {
            if (bl && this.field_5974.method_43056()) {
                return;
            }
            float g = f;
            float k = class_3532.method_15355((float)0.5f) * g;
            this.setRadiusAnimation(k);
        } else {
            List list;
            boolean bl2;
            if (this.field_6012 >= this.waitTime + this.duration) {
                float discardTime = this.getRadiusGrowth();
                this.setRadiusGrowth(discardTime -= 1.0f);
                if (this.getRadius() <= 0.0f) {
                    this.method_31472();
                    return;
                }
            }
            boolean bl3 = bl2 = this.field_6012 < this.waitTime;
            if (bl != bl2) {
                this.setWaiting(bl2);
            }
            if (bl2) {
                return;
            }
            if (this.radiusGrowth != 0.0f) {
                if ((f += this.radiusGrowth) < 0.5f) {
                    float discardTime = this.getRadiusGrowth();
                    this.setRadiusGrowth(discardTime -= 1.0f);
                    if (this.getRadius() <= 0.0f) {
                        this.method_31472();
                        return;
                    }
                }
                this.setRadius(f);
            }
            if (this.field_6012 % 5 == 0 && !(list = this.method_37908().method_18467(class_1309.class, this.method_5829())).isEmpty()) {
                for (class_1309 livingEntity : list) {
                    double n;
                    double m = livingEntity.method_23317() - this.method_23317();
                    double o = m * m + (n = livingEntity.method_23321() - this.method_23321()) * n;
                    if (!(o <= (double)(f * f)) || this.radiusOnSummon == 0.0f) continue;
                    if ((f += this.radiusOnSummon) < 0.5f) {
                        this.method_31472();
                        return;
                    }
                    this.setRadius(f);
                }
            }
        }
    }

    public float getRadiusOnSummon() {
        return this.radiusOnSummon;
    }

    public void setRadiusOnSummon(float radiusOnUse) {
        this.radiusOnSummon = radiusOnUse;
    }

    public float getRadiusGrowth() {
        return this.radiusGrowth;
    }

    public void setRadiusGrowth(float radiusGrowth) {
        this.radiusGrowth = radiusGrowth;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    protected void setWaiting(boolean waiting) {
        this.method_5841().method_12778(WAITING, (Object)waiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.method_5841().method_12789(WAITING);
    }

    public float getRadiusAnimation() {
        return this.animRadius;
    }

    public void setRadiusAnimation(float animRadius) {
        this.animRadius = animRadius;
    }

    private void damage(class_1309 target) {
        class_1309 livingEntity = this.getOwner();
        if (target.method_5805() && !target.method_5655() && target != livingEntity) {
            if (livingEntity == null) {
                target.method_5643(this.method_48923().method_48831(), this.dealtDamage);
            } else {
                class_1937 class_19372;
                if (livingEntity.method_5722((class_1297)target)) {
                    return;
                }
                class_1282 damageSource = this.method_48923().method_48815((class_1297)this, (class_1297)livingEntity);
                if (target.method_5643(damageSource, this.dealtDamage) && (class_19372 = this.method_37908()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_1890.method_60107((class_3218)serverWorld, (class_1297)target, (class_1282)damageSource);
                }
            }
        }
    }

    public void setVelocity(double x, double y, double z, float power, float uncertainty) {
        class_243 vec3d = this.calculateVelocity(x, y, z, power, uncertainty);
        this.method_18799(vec3d);
        this.field_6007 = true;
    }

    public class_243 calculateVelocity(double x, double y, double z, float power, float uncertainty) {
        return new class_243(x, y, z).method_1029().method_1031(this.field_5974.method_43385(0.0, 0.0172275 * (double)uncertainty), this.field_5974.method_43385(0.0, 0.0172275 * (double)uncertainty), this.field_5974.method_43385(0.0, 0.0172275 * (double)uncertainty)).method_1021((double)power);
    }

    public void method_5674(class_2940<?> data) {
        if (RADIUS.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18384((float)(this.getRadius() * 2.0f), (float)(this.getRadius() * 2.0f));
    }
}

