/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.screen;

import com.mojang.serialization.Codec;
import java.net.URI;
import net.j677.adventuresmod.item.AdventureItems;
import net.j677.adventuresmod.screen.CategoryWidget;
import net.j677.adventuresmod.screen.ChapterWidget;
import net.j677.adventuresmod.screen.SocialWidget;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3542;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class GuideBookScreen
extends class_437 {
    public static final class_2960 BOOK_LOCATION = class_2960.method_60655((String)"adventuresmod", (String)"textures/gui/guide/book.png");
    public static final class_2960 MAIN_PAGE = class_2960.method_60655((String)"adventuresmod", (String)"textures/gui/guide/main.png");
    private static final class_2960 BLUESKY_ICON = class_2960.method_60655((String)"adventuresmod", (String)"widgets/bluesky");
    private static final class_2960 CURSEFORGE_ICON = class_2960.method_60655((String)"adventuresmod", (String)"widgets/curseforge");
    private static final class_2960 DISCORD_ICON = class_2960.method_60655((String)"adventuresmod", (String)"widgets/discord");
    private static final class_2960 MODRINTH_ICON = class_2960.method_60655((String)"adventuresmod", (String)"widgets/modrinth");
    private static final class_2960 TWITCH_ICON = class_2960.method_60655((String)"adventuresmod", (String)"widgets/twitch");
    private static final class_2960 WIKI_ICON = class_2960.method_60655((String)"adventuresmod", (String)"widgets/wiki");
    private static final class_2960 YOUTUBE_ICON = class_2960.method_60655((String)"adventuresmod", (String)"widgets/youtube");
    public static final URI BLUESKY = URI.create("https://bsky.app/profile/j677themage.bsky.social");
    public static final URI CURSEFORGE = URI.create("https://www.curseforge.com/minecraft/mc-mods/adventurers-beyond");
    public static final URI DISCORD = URI.create("https://discord.com/invite/aXR5b8SmEe");
    public static final URI MODRINTH = URI.create("https://modrinth.com/mod/adventurers-beyond");
    public static final URI TWITCH = URI.create("https://www.twitch.tv/j677themage");
    public static final URI WIKI = URI.create("https://github.com/J677TheMage/Adventurers-Beyond-Wiki/wiki");
    public static final URI YOUTUBE = URI.create("https://www.youtube.com/@J677TheMage");
    private CategoryWidget overworldCategoryWidget;
    private CategoryWidget netherCategoryWidget;
    private CategoryWidget endCategoryWidget;
    private CategoryWidget mythicaCategoryWidget;
    protected int imageWidth = 322;
    protected int imageHeight = 214;
    private int chapterIndex;

    public GuideBookScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.adventuresmod.guidebook"));
    }

    protected void method_25426() {
        this.initChapters();
        this.initSocials();
        this.initPages();
    }

    protected void initChapters() {
        int i = (this.field_22789 - 256) / 2;
        int j = (this.field_22790 - 256) / 2;
        this.addChapter(i - 4, j + 55, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.overworld"), Chapter.OVERWORLD);
        this.addChapter(i - 4, j + 79, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.the_nether"), Chapter.THE_NETHER);
        this.addChapter(i - 4, j + 103, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.the_end"), Chapter.THE_END);
        this.addChapter(i - 4, j + 127, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.mythica"), Chapter.MYTHICA);
        this.addChapter(i - 4, j + 151, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.empty"), Chapter.EMPTY);
    }

    protected void initSocials() {
        int i = (this.field_22789 - 256) / 2;
        int j = (this.field_22790 - 256) / 2;
        this.addSocial(i + 3, j + 178, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.discord"), DISCORD, DISCORD_ICON);
        this.addSocial(i + 29, j + 178, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.curseforge"), CURSEFORGE, CURSEFORGE_ICON);
        this.addSocial(i + 55, j + 178, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.modrinth"), MODRINTH, MODRINTH_ICON);
        this.addSocial(i + 81, j + 178, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.wiki"), WIKI, WIKI_ICON);
        this.addSocial(i + 16, j + 201, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.bluesky"), BLUESKY, BLUESKY_ICON);
        this.addSocial(i + 42, j + 201, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.twitch"), TWITCH, TWITCH_ICON);
        this.addSocial(i + 68, j + 201, (class_2561)class_2561.method_43471((String)"widget.adventuresmod.youtube"), YOUTUBE, YOUTUBE_ICON);
    }

    public void addChapter(int x, int y, class_2561 text, Chapter chapter) {
        ChapterWidget chapterWidget = new ChapterWidget(x, y, text, chapter, this);
        this.method_37063((class_364)chapterWidget);
    }

    public void addSocial(int x, int y, class_2561 text, URI url, class_2960 textureId) {
        SocialWidget socialWidget = new SocialWidget(x, y, text, url, textureId, this);
        this.method_37063((class_364)socialWidget);
    }

    protected void initPages() {
        int i = (this.field_22789 - 256) / 2;
        int j = (this.field_22790 - 256) / 2;
        this.addOverworldCategory(i + 147, j + 55, (class_2561)class_2561.method_43471((String)"screen.adventuresmod.guidebook.amber"), "amber", AdventureItems.AMBER.method_8389().method_7854());
        this.addNetherCategory(i + 147, j + 78, (class_2561)class_2561.method_43471((String)"screen.adventuresmod.guidebook.moltarium"), "moltarium", AdventureItems.MOLTARIUM_INGOT.method_8389().method_7854());
        this.addEndCategory(i + 147, j + 78, (class_2561)class_2561.method_43471((String)"screen.adventuresmod.guidebook.voidarium"), "voidarium", AdventureItems.VOIDARIUM_INGOT.method_8389().method_7854());
        this.addMythicaCategory(i + 147, j + 78, (class_2561)class_2561.method_43471((String)"screen.adventuresmod.guidebook.mythril"), "mythril", AdventureItems.MYTHRIL_INGOT.method_8389().method_7854());
        this.updatePages();
    }

    public void addOverworldCategory(int x, int y, class_2561 id, String pageId, class_1799 pageIcon) {
        this.overworldCategoryWidget = (CategoryWidget)this.method_37063((class_364)new CategoryWidget(x, y, id, pageId, pageIcon, this.field_22787));
    }

    public void addNetherCategory(int x, int y, class_2561 id, String pageId, class_1799 pageIcon) {
        this.netherCategoryWidget = (CategoryWidget)this.method_37063((class_364)new CategoryWidget(x, y, id, pageId, pageIcon, this.field_22787));
    }

    public void addEndCategory(int x, int y, class_2561 id, String pageId, class_1799 pageIcon) {
        this.endCategoryWidget = (CategoryWidget)this.method_37063((class_364)new CategoryWidget(x, y, id, pageId, pageIcon, this.field_22787));
    }

    public void addMythicaCategory(int x, int y, class_2561 id, String pageId, class_1799 pageIcon) {
        this.mythicaCategoryWidget = (CategoryWidget)this.method_37063((class_364)new CategoryWidget(x, y, id, pageId, pageIcon, this.field_22787));
    }

    public void updatePages() {
        this.overworldCategoryWidget.field_22764 = this.chapterIndex == 0;
        this.netherCategoryWidget.field_22764 = this.chapterIndex == 1;
        this.endCategoryWidget.field_22764 = this.chapterIndex == 2;
        this.mythicaCategoryWidget.field_22764 = this.chapterIndex == 3;
    }

    public void setChapterIndex(int chapterIndex) {
        this.chapterIndex = chapterIndex;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_52752(context);
        int i = (this.field_22789 - this.imageWidth) / 2;
        int j = (this.field_22790 - this.imageHeight) / 2;
        context.method_25291(BOOK_LOCATION, i, j, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
        context.method_25291(MAIN_PAGE, i, j, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
    }

    public static enum Chapter implements class_3542
    {
        OVERWORLD("overworld", 0),
        THE_NETHER("the_nether", 1),
        THE_END("the_end", 2),
        MYTHICA("mythica", 3),
        REGONIA("regonia", 4),
        EMPTY("empty", 5);

        public static final Codec<Chapter> CODEC;
        private final String modelType;
        private final int index;

        private Chapter(String modelType, int index) {
            this.modelType = modelType;
            this.index = index;
        }

        public String method_15434() {
            return this.modelType;
        }

        public int getIndex() {
            return this.index;
        }

        static {
            CODEC = class_3542.method_28140(Chapter::values);
        }
    }
}

