/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.util;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2629;
import net.minecraft.class_3222;

public class AdventureBossBar
extends class_1259 {
    private final Set<class_3222> players = Sets.newHashSet();
    private final Set<class_3222> unmodifiablePlayers = Collections.unmodifiableSet(this.players);
    private boolean visible = true;

    public AdventureBossBar(UUID uuid, class_2561 name, class_1259.class_1260 color, class_1259.class_1261 style, Texture texture) {
        super(uuid, name, color, style);
    }

    public void method_5408(float percent) {
        if (percent != this.field_5774) {
            super.method_5408(percent);
            this.sendPacket(class_2629::method_34094);
        }
    }

    public void method_5416(class_1259.class_1260 color) {
        if (color != this.field_5778) {
            super.method_5416(color);
            this.sendPacket(class_2629::method_34097);
        }
    }

    public void method_5409(class_1259.class_1261 style) {
        if (style != this.field_5779) {
            super.method_5409(style);
            this.sendPacket(class_2629::method_34097);
        }
    }

    public class_1259 method_5406(boolean darkenSky) {
        if (darkenSky != this.field_5776) {
            super.method_5406(darkenSky);
            this.sendPacket(class_2629::method_34098);
        }
        return this;
    }

    public class_1259 method_5410(boolean dragonMusic) {
        if (dragonMusic != this.field_5775) {
            super.method_5410(dragonMusic);
            this.sendPacket(class_2629::method_34098);
        }
        return this;
    }

    public class_1259 method_5411(boolean thickenFog) {
        if (thickenFog != this.field_5773) {
            super.method_5411(thickenFog);
            this.sendPacket(class_2629::method_34098);
        }
        return this;
    }

    public void method_5413(class_2561 name) {
        if (!Objects.equal((Object)name, (Object)this.field_5777)) {
            super.method_5413(name);
            this.sendPacket(class_2629::method_34096);
        }
    }

    private void sendPacket(Function<class_1259, class_2629> bossBarToPacketFunction) {
        if (this.visible) {
            class_2629 bossBarS2CPacket = bossBarToPacketFunction.apply(this);
            for (class_3222 serverPlayerEntity : this.players) {
                serverPlayerEntity.field_13987.method_14364((class_2596)bossBarS2CPacket);
            }
        }
    }

    public void addPlayer(class_3222 player) {
        if (this.players.add(player) && this.visible) {
            player.field_13987.method_14364((class_2596)class_2629.method_34089((class_1259)this));
        }
    }

    public void removePlayer(class_3222 player) {
        if (this.players.remove(player) && this.visible) {
            player.field_13987.method_14364((class_2596)class_2629.method_34090((UUID)this.method_5407()));
        }
    }

    public void clearPlayers() {
        if (!this.players.isEmpty()) {
            for (class_3222 serverPlayerEntity : Lists.newArrayList(this.players)) {
                this.removePlayer(serverPlayerEntity);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (visible != this.visible) {
            this.visible = visible;
            for (class_3222 serverPlayerEntity : this.players) {
                serverPlayerEntity.field_13987.method_14364((class_2596)(visible ? class_2629.method_34089((class_1259)this) : class_2629.method_34090((UUID)this.method_5407())));
            }
        }
    }

    public Collection<class_3222> getPlayers() {
        return this.unmodifiablePlayers;
    }

    public static enum Texture {
        REKINDLED("rekindled"),
        CONJURER("conjurer"),
        RUNESTONE("runestone");

        private final String name;

        private Texture(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Texture byName(String name) {
            for (Texture texture : Texture.values()) {
                if (!texture.name.equals(name)) continue;
                return texture;
            }
            return REKINDLED;
        }
    }
}

