/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.world.feature.features;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import net.j677.adventuresmod.block.AdventureBlocks;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5156;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.Nullable;

public class BarrenrockColumnsFeature
extends class_3031<class_5156> {
    private static final ImmutableList<class_2248> CANNOT_REPLACE_BLOCKS = ImmutableList.of((Object)AdventureBlocks.ERRATICA, (Object)class_2246.field_9987, (Object)class_2246.field_10462, (Object)class_2246.field_10540, (Object)AdventureBlocks.OBSIDIAN_BRICKS, (Object)AdventureBlocks.END_GRASS_BLOCK, (Object)AdventureBlocks.END_GRASS, (Object)AdventureBlocks.VACANT_ELORA, (Object)AdventureBlocks.CORRUPTED_ELORA, (Object)class_2246.field_10286, (Object)class_2246.field_10175, (Object)class_2246.field_9992, (Object[])new class_2248[]{class_2246.field_10034, class_2246.field_10260});

    public BarrenrockColumnsFeature(Codec<class_5156> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_5156> context) {
        class_2338 blockPos = context.method_33655();
        class_5281 structureWorldAccess = context.method_33652();
        class_5819 random = context.method_33654();
        class_5156 basaltColumnsFeatureConfig = (class_5156)context.method_33656();
        if (!BarrenrockColumnsFeature.canPlaceAt((class_1936)structureWorldAccess, blockPos.method_25503())) {
            return false;
        }
        int j = basaltColumnsFeatureConfig.method_30394().method_35008(random);
        boolean bl = random.method_43057() < 0.9f;
        int k = Math.min(j, bl ? 5 : 8);
        int l = bl ? 50 : 15;
        boolean bl2 = false;
        for (class_2338 blockPos2 : class_2338.method_27156((class_5819)random, (int)l, (int)(blockPos.method_10263() - k), (int)blockPos.method_10264(), (int)(blockPos.method_10260() - k), (int)(blockPos.method_10263() + k), (int)blockPos.method_10264(), (int)(blockPos.method_10260() + k))) {
            int m = j - blockPos2.method_19455((class_2382)blockPos);
            if (m < 0) continue;
            bl2 |= this.placeBarrenrockColumn((class_1936)structureWorldAccess, blockPos2, m, basaltColumnsFeatureConfig.method_30391().method_35008(random));
        }
        return bl2;
    }

    private boolean placeBarrenrockColumn(class_1936 world, class_2338 pos, int height, int reach) {
        boolean bl = false;
        block0: for (class_2338 blockPos : class_2338.method_10094((int)(pos.method_10263() - reach), (int)pos.method_10264(), (int)(pos.method_10260() - reach), (int)(pos.method_10263() + reach), (int)pos.method_10264(), (int)(pos.method_10260() + reach))) {
            int i = blockPos.method_19455((class_2382)pos);
            class_2338 blockPos2 = BarrenrockColumnsFeature.isAirOrErratica(world, blockPos) ? BarrenrockColumnsFeature.moveDownToGround(world, blockPos.method_25503(), i) : BarrenrockColumnsFeature.moveUpToAir(world, blockPos.method_25503(), i);
            if (blockPos2 == null) continue;
            class_2338.class_2339 mutable = blockPos2.method_25503();
            for (int j = height - i / 2; j >= 0; --j) {
                if (BarrenrockColumnsFeature.isAirOrErratica(world, (class_2338)mutable)) {
                    this.method_13153((class_1945)world, (class_2338)mutable, AdventureBlocks.BARRENROCK.method_9564());
                    mutable.method_10098(class_2350.field_11036);
                    bl = true;
                    continue;
                }
                if (!world.method_8320((class_2338)mutable).method_27852(AdventureBlocks.BARRENROCK)) continue block0;
                mutable.method_10098(class_2350.field_11036);
            }
        }
        return bl;
    }

    @Nullable
    private static class_2338 moveDownToGround(class_1936 world, class_2338.class_2339 mutablePos, int distance) {
        while (mutablePos.method_10264() > world.method_31607() + 1 && distance > 0) {
            --distance;
            if (BarrenrockColumnsFeature.canPlaceAt(world, mutablePos)) {
                return mutablePos;
            }
            mutablePos.method_10098(class_2350.field_11033);
        }
        return null;
    }

    private static boolean canPlaceAt(class_1936 world, class_2338.class_2339 mutablePos) {
        if (!BarrenrockColumnsFeature.isAirOrErratica(world, (class_2338)mutablePos)) {
            return false;
        }
        class_2680 blockState = world.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11033));
        mutablePos.method_10098(class_2350.field_11036);
        return !blockState.method_26215() && !CANNOT_REPLACE_BLOCKS.contains((Object)blockState.method_26204());
    }

    @Nullable
    private static class_2338 moveUpToAir(class_1936 world, class_2338.class_2339 mutablePos, int distance) {
        while (mutablePos.method_10264() < world.method_31600() && distance > 0) {
            --distance;
            class_2680 blockState = world.method_8320((class_2338)mutablePos);
            if (CANNOT_REPLACE_BLOCKS.contains((Object)blockState.method_26204())) {
                return null;
            }
            if (blockState.method_26215()) {
                return mutablePos;
            }
            mutablePos.method_10098(class_2350.field_11036);
        }
        return null;
    }

    private static boolean isAirOrErratica(class_1936 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26215() || blockState.method_27852(AdventureBlocks.ERRATICA);
    }
}

