/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.world.feature.tree.placers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.j677.adventuresmod.world.feature.tree.placers.AdventureTrunkPlacerTypes;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4970;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class OrchestralTrunkPlacer
extends class_5141 {
    public static final MapCodec<OrchestralTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> OrchestralTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, OrchestralTrunkPlacer::new));
    private final class_5819 random = class_5819.method_43047();

    public OrchestralTrunkPlacer(int i, int j, int k) {
        super(i, j, k);
    }

    protected class_5142<?> method_28903() {
        return AdventureTrunkPlacerTypes.ORCHESTRAL_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        ArrayList list = Lists.newArrayList();
        this.generateLog(world, replacer, startPos, random, list, config, height);
        return list;
    }

    public void generateLog(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_2338 pos, class_5819 random, List<class_4647.class_5208> list, class_4643 config, int size) {
        this.method_35375(world, replacer, random, pos, config);
        this.generateLog(world, replacer, pos, random, pos, list, config, size, 0);
    }

    private void generateLog(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_2338 pos, class_5819 random, class_2338 rootPos, List<class_4647.class_5208> list, class_4643 config, int size, int layer) {
        int i = random.method_43048(4) + 1;
        if (layer == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            class_2338 blockPos = pos.method_10086(j + 1);
            this.method_35375(world, replacer, random, blockPos, config);
            this.method_35375(world, replacer, random, blockPos.method_10074(), config);
        }
        boolean bl = false;
        if (layer < 4) {
            int k = random.method_43048(4);
            if (layer == 0) {
                ++k;
            }
            for (int l = 0; l < k; ++l) {
                class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
                class_2338 blockPos2 = pos.method_10086(i).method_10093(direction);
                if (Math.abs(blockPos2.method_10263() - rootPos.method_10263()) >= size || Math.abs(blockPos2.method_10260() - rootPos.method_10260()) >= size || !world.method_16358(blockPos2, class_4970.class_4971::method_26215) || !world.method_16358(blockPos2.method_10074(), class_4970.class_4971::method_26215) || !OrchestralTrunkPlacer.isSurroundedByAir(world, blockPos2, direction.method_10153())) continue;
                bl = true;
                this.method_35375(world, replacer, random, blockPos2, config);
                this.method_35375(world, replacer, random, blockPos2.method_10093(direction.method_10153()), config);
                this.generateLog(world, replacer, blockPos2, random, rootPos, list, config, size, layer + 1);
            }
        }
        if (!bl) {
            list.add(new class_4647.class_5208(pos.method_10086(i), 1, false));
        }
    }

    private static boolean isSurroundedByAir(class_3746 world, class_2338 pos, @Nullable class_2350 exceptDirection) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (direction == exceptDirection || world.method_16358(pos.method_10093(direction), class_4970.class_4971::method_26215)) continue;
            return false;
        }
        return true;
    }
}

