/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.world.portal;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.j677.adventuresmod.block.AdventureBlocks;
import net.j677.adventuresmod.block.custom.MythicaPortalBlock;
import net.j677.adventuresmod.util.AdventureTags;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class MythicaPortal {
    private static final class_4970.class_4973 IS_VALID_FRAME_BLOCK = (state, world, pos) -> state.method_26164(AdventureTags.Blocks.MYTHIC_PORTAL_FRAME_BLOCKS);
    private final class_1936 world;
    private final class_2350.class_2351 axis;
    private final class_2350 negativeDir;
    private int foundPortalBlocks;
    @Nullable
    private class_2338 lowerCorner;
    private int height;
    private final int width;

    public static Optional<MythicaPortal> getNewPortal(class_1936 world, class_2338 pos, class_2350.class_2351 axis) {
        return MythicaPortal.getOrEmpty(world, pos, areaHelper -> areaHelper.isValid() && areaHelper.foundPortalBlocks == 0, axis);
    }

    public static Optional<MythicaPortal> getOrEmpty(class_1936 world, class_2338 pos, Predicate<MythicaPortal> validator, class_2350.class_2351 axis) {
        Optional<MythicaPortal> optional = Optional.of(new MythicaPortal(world, pos, axis)).filter(validator);
        if (optional.isPresent()) {
            return optional;
        }
        class_2350.class_2351 axis2 = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        return Optional.of(new MythicaPortal(world, pos, axis2)).filter(validator);
    }

    public MythicaPortal(class_1936 world, @Nullable class_2338 pos, class_2350.class_2351 axis) {
        this.world = world;
        this.axis = axis;
        class_2350 class_23502 = this.negativeDir = axis == class_2350.class_2351.field_11048 ? class_2350.field_11039 : class_2350.field_11035;
        if (pos != null) {
            this.lowerCorner = this.getLowerCorner(pos);
        }
        if (this.lowerCorner == null) {
            this.lowerCorner = pos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.getWidth();
            if (this.width > 0) {
                this.height = this.getHeight();
            }
        }
    }

    @Nullable
    private class_2338 getLowerCorner(class_2338 pos) {
        int i = Math.max(this.world.method_31607(), pos.method_10264() - 21);
        while (pos.method_10264() > i && MythicaPortal.validStateInsidePortal(this.world.method_8320(pos.method_10074()))) {
            pos = pos.method_10074();
        }
        class_2350 direction = this.negativeDir.method_10153();
        int j = this.getWidth(pos, direction) - 1;
        return j < 0 ? null : pos.method_10079(direction, j);
    }

    private int getWidth() {
        int i = this.getWidth(this.lowerCorner, this.negativeDir);
        return i >= 3 && i <= 21 ? i : 0;
    }

    private int getWidth(class_2338 pos, class_2350 direction) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i <= 21; ++i) {
            mutable.method_10101((class_2382)pos).method_10104(direction, i);
            class_2680 blockState = this.world.method_8320((class_2338)mutable);
            if (!MythicaPortal.validStateInsidePortal(blockState)) {
                if (!IS_VALID_FRAME_BLOCK.test(blockState, (class_1922)this.world, (class_2338)mutable)) break;
                return i;
            }
            class_2680 blockState2 = this.world.method_8320((class_2338)mutable.method_10098(class_2350.field_11033));
            if (!IS_VALID_FRAME_BLOCK.test(blockState2, (class_1922)this.world, (class_2338)mutable)) break;
        }
        return 0;
    }

    private int getHeight() {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int i = this.getPotentialHeight(mutable);
        return i >= 3 && i <= 21 && this.isHorizontalFrameValid(mutable, i) ? i : 0;
    }

    private boolean isHorizontalFrameValid(class_2338.class_2339 pos, int height) {
        for (int i = 0; i < this.width; ++i) {
            class_2338.class_2339 mutable = pos.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, height).method_10104(this.negativeDir, i);
            if (IS_VALID_FRAME_BLOCK.test(this.world.method_8320((class_2338)mutable), (class_1922)this.world, (class_2338)mutable)) continue;
            return false;
        }
        return true;
    }

    private int getPotentialHeight(class_2338.class_2339 pos) {
        for (int i = 0; i < 21; ++i) {
            pos.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, -1);
            if (!IS_VALID_FRAME_BLOCK.test(this.world.method_8320((class_2338)pos), (class_1922)this.world, (class_2338)pos)) {
                return i;
            }
            pos.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, this.width);
            if (!IS_VALID_FRAME_BLOCK.test(this.world.method_8320((class_2338)pos), (class_1922)this.world, (class_2338)pos)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                pos.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, j);
                class_2680 blockState = this.world.method_8320((class_2338)pos);
                if (!MythicaPortal.validStateInsidePortal(blockState)) {
                    return i;
                }
                if (!blockState.method_27852(AdventureBlocks.MYTHIC_PORTAL)) continue;
                ++this.foundPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean validStateInsidePortal(class_2680 state) {
        return state.method_26215() || state.method_27852(AdventureBlocks.MYTHIC_PORTAL);
    }

    public boolean isValid() {
        return this.lowerCorner != null && this.width >= 3 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortal() {
        class_2680 blockState = (class_2680)AdventureBlocks.MYTHIC_PORTAL.method_9564().method_11657(MythicaPortalBlock.AXIS, (Comparable)this.axis);
        class_2338.method_10097((class_2338)Objects.requireNonNull(this.lowerCorner), (class_2338)this.lowerCorner.method_10079(class_2350.field_11036, this.height - 1).method_10079(this.negativeDir, this.width - 1)).forEach(pos -> this.world.method_8652(pos, blockState, 18));
    }

    public boolean wasAlreadyValid() {
        return this.isValid() && this.foundPortalBlocks == this.width * this.height;
    }

    public static class_243 findOpenPosition(class_243 fallback, class_3218 world, class_1297 entity, class_4048 dimensions) {
        if (!(dimensions.comp_2185() > 4.0f) && !(dimensions.comp_2186() > 4.0f)) {
            double d = (double)dimensions.comp_2186() / 2.0;
            class_243 vec3d = fallback.method_1031(0.0, d, 0.0);
            class_265 voxelShape = class_259.method_1078((class_238)class_238.method_30048((class_243)vec3d, (double)dimensions.comp_2185(), (double)0.0, (double)dimensions.comp_2185()).method_1012(0.0, 1.0, 0.0).method_1014(1.0E-6));
            Optional optional = world.method_33594(entity, voxelShape, vec3d, (double)dimensions.comp_2185(), (double)dimensions.comp_2186(), (double)dimensions.comp_2185());
            Optional<class_243> optional2 = optional.map(pos -> pos.method_1023(0.0, d, 0.0));
            return optional2.orElse(fallback);
        }
        return fallback;
    }
}

