/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.world.portal;

import java.util.Comparator;
import java.util.Optional;
import net.j677.adventuresmod.block.AdventureBlocks;
import net.j677.adventuresmod.block.custom.MythicaPortalBlock;
import net.j677.adventuresmod.util.AdventurePoi;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_4538;
import net.minecraft.class_5459;

public class MythicaPortalForcer {
    private final class_3218 world;

    public MythicaPortalForcer(class_3218 world) {
        this.world = world;
    }

    public Optional<class_2338> getPortalPos(class_2338 pos, class_2784 worldBorder) {
        class_4153 pointOfInterestStorage = this.world.method_19494();
        int i = 128;
        pointOfInterestStorage.method_22439((class_4538)this.world, pos, i);
        return pointOfInterestStorage.method_22383(poiType -> ((class_4158)poiType.comp_349()).equals((Object)AdventurePoi.MYTHICA_PORTAL), pos, i, class_4153.class_4155.field_18489).map(class_4156::method_19141).filter(arg_0 -> ((class_2784)worldBorder).method_11952(arg_0)).filter(blockPos -> this.world.method_8320(blockPos).method_28498((class_2769)class_2741.field_12529)).min(Comparator.comparingDouble(blockPos2 -> blockPos2.method_10262((class_2382)pos)).thenComparingInt(class_2382::method_10264));
    }

    public Optional<class_5459.class_5460> createPortal(class_2338 pos, class_2350.class_2351 axis) {
        int n;
        int m;
        class_2350 direction = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        double d = -1.0;
        class_2338 blockPos = null;
        double e = -1.0;
        class_2338 blockPos2 = null;
        class_2784 worldBorder = this.world.method_8621();
        int i = Math.min(this.world.method_31600(), this.world.method_31607() + this.world.method_32819()) - 1;
        class_2338.class_2339 mutable = pos.method_25503();
        for (class_2338.class_2339 mutable2 : class_2338.method_30512((class_2338)pos, (int)16, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
            int k = Math.min(i, this.world.method_8624(class_2902.class_2903.field_13197, mutable2.method_10263(), mutable2.method_10260()));
            if (!worldBorder.method_11952((class_2338)mutable2) || !worldBorder.method_11952((class_2338)mutable2.method_10104(direction, 1))) continue;
            mutable2.method_10104(direction.method_10153(), 1);
            for (int l = k; l >= this.world.method_31607(); --l) {
                mutable2.method_33098(l);
                if (!this.isBlockStateValid(mutable2)) continue;
                m = l;
                while (l > this.world.method_31607() && this.isBlockStateValid(mutable2.method_10098(class_2350.field_11033))) {
                    --l;
                }
                if (l + 4 > i || (n = m - l) > 0 && n < 3) continue;
                mutable2.method_33098(l);
                if (!this.isValidPortalPos((class_2338)mutable2, mutable, direction, 0)) continue;
                double f = pos.method_10262((class_2382)mutable2);
                if (this.isValidPortalPos((class_2338)mutable2, mutable, direction, -1) && this.isValidPortalPos((class_2338)mutable2, mutable, direction, 1) && (d == -1.0 || d > f)) {
                    d = f;
                    blockPos = mutable2.method_10062();
                }
                if (d != -1.0 || e != -1.0 && !(e > f)) continue;
                e = f;
                blockPos2 = mutable2.method_10062();
            }
        }
        if (d == -1.0 && e != -1.0) {
            blockPos = blockPos2;
            d = e;
        }
        if (d == -1.0) {
            int p = i - 9;
            int o = Math.max(this.world.method_31607() - -1, 70);
            if (p < o) {
                return Optional.empty();
            }
            blockPos = new class_2338(pos.method_10263() - direction.method_10148(), class_3532.method_15340((int)pos.method_10264(), (int)o, (int)p), pos.method_10260() - direction.method_10165()).method_10062();
            blockPos = worldBorder.method_61117(blockPos);
            class_2350 direction2 = direction.method_10170();
            for (int lx = -1; lx < 3; ++lx) {
                for (m = 0; m < 3; ++m) {
                    for (n = -1; n < 3; ++n) {
                        class_2680 blockState = n < 0 ? AdventureBlocks.MYTHIC_PORTAL_FRAME.method_9564() : class_2246.field_10124.method_9564();
                        mutable.method_25504((class_2382)blockPos, m * direction.method_10148() + lx * direction2.method_10148(), n, m * direction.method_10165() + lx * direction2.method_10165());
                        this.world.method_8501((class_2338)mutable, blockState);
                    }
                }
            }
        }
        for (int o = -1; o < 4; ++o) {
            for (int p = -1; p < 4; ++p) {
                if (o != -1 && o != 3 && p != -1 && p != 3) continue;
                mutable.method_25504(blockPos, o * direction.method_10148(), p, o * direction.method_10165());
                this.world.method_8652((class_2338)mutable, AdventureBlocks.MYTHIC_PORTAL_FRAME.method_9564(), 3);
            }
        }
        class_2680 blockState2 = (class_2680)AdventureBlocks.MYTHIC_PORTAL.method_9564().method_11657(MythicaPortalBlock.AXIS, (Comparable)axis);
        for (int px = 0; px < 3; ++px) {
            for (int k = 0; k < 3; ++k) {
                mutable.method_25504(blockPos, px * direction.method_10148(), k, px * direction.method_10165());
                this.world.method_8652((class_2338)mutable, blockState2, 18);
            }
        }
        return Optional.of(new class_5459.class_5460(blockPos.method_10062(), 3, 3));
    }

    private boolean isBlockStateValid(class_2338.class_2339 pos) {
        class_2680 blockState = this.world.method_8320((class_2338)pos);
        return blockState.method_45474() && blockState.method_26227().method_15769();
    }

    private boolean isValidPortalPos(class_2338 pos, class_2338.class_2339 temp, class_2350 portalDirection, int distanceOrthogonalToPortal) {
        class_2350 direction = portalDirection.method_10170();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                temp.method_25504((class_2382)pos, portalDirection.method_10148() * i + direction.method_10148() * distanceOrthogonalToPortal, j, portalDirection.method_10165() * i + direction.method_10165() * distanceOrthogonalToPortal);
                if (j < 0 && !this.world.method_8320((class_2338)temp).method_51367()) {
                    return false;
                }
                if (j < 0 || this.isBlockStateValid(temp)) continue;
                return false;
            }
        }
        return true;
    }
}

