/*
 * Decompiled with CFR 0.152.
 */
package net.j677.adventuresmod.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.j677.adventuresmod.world.structure.AdventureStructureTypes;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5819;
import net.minecraft.class_5847;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_8889;
import net.minecraft.class_8891;
import net.minecraft.class_9778;
import net.minecraft.class_9822;

public class HeightJigsawStructure
extends class_3195 {
    public static final class_9778 DEFAULT_DIMENSION_PADDING = class_9778.field_51953;
    public static final class_9822 DEFAULT_LIQUID_SETTINGS = class_9822.field_52238;
    public static final MapCodec<HeightJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HeightJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.intRange((int)-4046, (int)4046).fieldOf("discardY").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.list((Codec)class_8889.field_46825).optionalFieldOf("pool_aliases", List.of()).forGetter(structure -> structure.poolAliasBindings), (App)class_9778.field_51952.optionalFieldOf("dimension_padding", (Object)DEFAULT_DIMENSION_PADDING).forGetter(structure -> structure.dimensionPadding), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)DEFAULT_LIQUID_SETTINGS).forGetter(jigsawStructure -> jigsawStructure.liquidSettings)).apply((Applicative)instance, HeightJigsawStructure::new)).validate(HeightJigsawStructure::validate);
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final int discardY;
    private final class_6122 startHeight;
    private final boolean useExpansionHack;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final List<class_8889> poolAliasBindings;
    private final class_9778 dimensionPadding;
    private final class_9822 liquidSettings;

    private static DataResult<HeightJigsawStructure> validate(HeightJigsawStructure structure) {
        int i = switch (structure.method_42701()) {
            default -> throw new MatchException(null, null);
            case class_5847.field_28922 -> 0;
            case class_5847.field_28923, class_5847.field_38431, class_5847.field_38432, class_5847.field_51413 -> 12;
        };
        return structure.maxDistanceFromCenter + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)((Object)structure));
    }

    public HeightJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, int discardY, class_6122 startHeight, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, List<class_8889> poolAliasBindings, class_9778 dimensionPadding, class_9822 liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.discardY = discardY;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.poolAliasBindings = poolAliasBindings;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        int i = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), i, chunkPos.method_8328());
        class_2470 blockRotation = class_2470.method_16548((class_5819)context.comp_566());
        class_2338 blockPos2 = this.method_42382(context, blockRotation);
        return blockPos2.method_10264() < this.discardY ? Optional.empty() : class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (class_8891)class_8891.create(this.poolAliasBindings, (class_2338)blockPos, (long)context.comp_567()), (class_9778)this.dimensionPadding, (class_9822)this.liquidSettings);
    }

    public class_7151<?> method_41618() {
        return AdventureStructureTypes.HEIGHT_JIGSAW;
    }
}

