/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.mc.quick.update;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import eu.ha3.mc.quick.update.Reporter;
import eu.ha3.mc.quick.update.TargettedVersion;
import eu.ha3.mc.quick.update.UpdaterConfig;
import eu.ha3.mc.quick.update.Versions;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateChecker {
    private static final Logger LOGGER = LogManager.getLogger((String)"UpdateChecker");
    private static final Gson GSON = new Gson();
    private final TargettedVersion currentVersion;
    private final String server;
    private final Reporter reporter;
    private final UpdaterConfig config;
    private boolean started;
    private CompletableFuture<Optional<Versions>> cachedResult = CompletableFuture.completedFuture(Optional.empty());

    public UpdateChecker(UpdaterConfig config, String modid, String server, Reporter reporter) {
        this.config = config;
        this.currentVersion = new TargettedVersion(modid);
        this.server = server;
        this.reporter = reporter;
    }

    public Optional<Versions> getLast() {
        return this.cachedResult.getNow(Optional.empty());
    }

    public Optional<Versions> getNewer() {
        return this.getLast().filter(versions -> versions.latest().version().compareTo((Object)this.currentVersion.version()) > 0);
    }

    public void attempt() {
        if (this.started || !this.config.enabled) {
            return;
        }
        this.started = true;
        this.checkNow().thenAccept(o -> o.ifPresent(versions -> {
            TargettedVersion latest = versions.latest();
            LOGGER.info("Server responded version: " + String.valueOf(latest) + ", we are " + String.valueOf(this.currentVersion));
            if (latest.version().compareTo((Object)this.currentVersion.version()) > 0 && this.config.shouldReport(latest)) {
                this.reporter.report(latest, this.currentVersion);
            }
        }));
    }

    public CompletableFuture<Optional<Versions>> checkNow() {
        this.cachedResult = CompletableFuture.supplyAsync(() -> {
            Optional<Versions> optional;
            InputStreamReader reader = new InputStreamReader(URI.create(this.server + "?t=" + System.currentTimeMillis()).toURL().openStream());
            try {
                optional = Optional.of(new Versions((JsonObject)GSON.fromJson((Reader)reader, JsonObject.class)));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ((Reader)reader).close();
            return optional;
        }, (Executor)class_156.method_27958()).exceptionally(e -> {
            LOGGER.error("Error occured whilst checking for updates", e);
            return null;
        });
        return this.cachedResult;
    }
}

