/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.stream.JsonWriter;
import com.minelittlepony.common.util.GamePaths;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2498;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_338;

public interface BlockReport {
    public static CompletableFuture<?> execute(Reportable reportable, String baseName, boolean full) {
        class_310 client = class_310.method_1551();
        class_338 hud = client.field_1705.method_1743();
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                Path loc = BlockReport.getUniqueFileName(GamePaths.getGameDirectory().resolve("presencefootsteps"), baseName, ".json");
                Files.createDirectories(loc.getParent(), new FileAttribute[0]);
                try (JsonObjectWriter writer = JsonObjectWriter.of(new JsonWriter((Writer)Files.newBufferedWriter(loc, new OpenOption[0])));){
                    reportable.writeToReport(full, writer, (Map<String, class_2498>)new Object2ObjectOpenHashMap());
                }
                return loc;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate report", e);
            }
        }, (Executor)class_156.method_27958()).thenAcceptAsync(loc -> hud.method_1812((class_2561)class_2561.method_43469((String)"pf.report.save", (Object[])new Object[]{class_2561.method_43470((String)loc.getFileName().toString()).method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11746, loc.toString())).method_27706(class_124.field_1073))}).method_27694(s -> s.method_10977(class_124.field_1060))), (Executor)client)).exceptionallyAsync(e -> {
            hud.method_1812((class_2561)class_2561.method_43469((String)"pf.report.error", (Object[])new Object[]{e.getMessage()}).method_27694(s -> s.method_10977(class_124.field_1061)));
            return null;
        }, (Executor)client);
    }

    private static Path getUniqueFileName(Path directory, String baseName, String ext) {
        Path loc = null;
        int counter = 0;
        while (loc == null || Files.exists(loc, new LinkOption[0])) {
            loc = directory.resolve(baseName + (String)(counter == 0 ? "" : "_" + counter) + ext);
            ++counter;
        }
        return loc;
    }

    public static interface Reportable {
        public void writeToReport(boolean var1, JsonObjectWriter var2, Map<String, class_2498> var3) throws IOException;
    }
}

