/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3532;
import net.minecraft.class_745;

public class MotionTracker {
    private double lastX;
    private double lastY;
    private double lastZ;
    protected double motionX;
    protected double motionY;
    protected double motionZ;
    protected float distanceTraveled;
    protected double fallDistance;
    private final TerrestrialStepSoundGenerator generator;

    public MotionTracker(TerrestrialStepSoundGenerator generator) {
        this.generator = generator;
    }

    public double getMotionX() {
        return this.motionX;
    }

    public double getMotionY() {
        return this.motionY;
    }

    public double getMotionZ() {
        return this.motionZ;
    }

    public double getHorizontalSpeed() {
        return this.motionX * this.motionX + this.motionZ * this.motionZ;
    }

    public boolean isStationary() {
        return this.motionX == 0.0 && this.motionZ == 0.0;
    }

    public float getDistanceTraveled() {
        return this.distanceTraveled;
    }

    public double getFallDistance() {
        return this.fallDistance;
    }

    public void simulateMotionData(class_1309 ply) {
        if (PlayerUtil.isClientPlayer((class_1297)ply)) {
            this.motionX = ply.method_18798().field_1352;
            this.motionY = ply.method_18798().field_1351;
            this.motionZ = ply.method_18798().field_1350;
            this.distanceTraveled = ply.field_5994;
            this.fallDistance = ply.field_6017;
        } else {
            this.motionX = ply.method_23317() - this.lastX;
            this.lastX = ply.method_23317();
            this.motionY = ply.method_23318() - this.lastY;
            if (ply.method_24828()) {
                this.motionY += 0.0784000015258789;
            }
            this.lastY = ply.method_23318();
            this.motionZ = ply.method_23321() - this.lastZ;
            this.lastZ = ply.method_23321();
        }
        if (ply instanceof class_745) {
            class_745 other = (class_745)ply;
            if (ply.method_37908().method_8510() % 1L == 0L) {
                this.distanceTraveled = this.motionX != 0.0 || this.motionZ != 0.0 ? (float)((double)this.distanceTraveled + Math.sqrt(Math.pow(this.motionX, 2.0) + Math.pow(this.motionY, 2.0) + Math.pow(this.motionZ, 2.0)) * 0.8) : (float)((double)this.distanceTraveled + Math.sqrt(Math.pow(this.motionX, 2.0) + Math.pow(this.motionZ, 2.0)) * 0.8);
                if (ply.method_24828() || ply.method_5765() || other.method_31549().field_7479 || this.motionY > 0.0) {
                    this.fallDistance = 0.0;
                } else if (this.motionY < 0.0) {
                    this.fallDistance -= this.motionY;
                }
            }
        }
        if (!(ply instanceof class_1657)) {
            this.distanceTraveled += (float)Math.sqrt(this.getHorizontalSpeed()) * 0.6f;
        }
    }

    public State pickState(class_1309 ply, State walk, State run) {
        if (ply instanceof class_1657 && !PlayerUtil.isClientPlayer((class_1297)ply)) {
            if (ply.method_5624()) {
                return run;
            }
            return walk;
        }
        return this.getHorizontalSpeed() > (double)this.generator.engine.getIsolator().variator().SPEED_TO_RUN ? run : walk;
    }

    public float getSpeedScalingRatio(class_1309 entity) {
        Variator variator = this.generator.engine.getIsolator().variator();
        variator.RUNNING_RAMPUP_BEGIN = 0.011f;
        variator.RUNNING_RAMPUP_END = 0.022f;
        double relativeSpeed = this.getHorizontalSpeed() + this.getMotionY() * this.getMotionY() - (double)variator.RUNNING_RAMPUP_BEGIN;
        double maxSpeed = variator.RUNNING_RAMPUP_END - variator.RUNNING_RAMPUP_BEGIN;
        return (float)class_3532.method_15350((double)(relativeSpeed / maxSpeed), (double)0.0, (double)1.0);
    }
}

