/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;

public interface ResourceUtils {
    public static boolean forEach(class_2960 id, class_3300 manager, Consumer<Reader> consumer) {
        return manager.method_14489(id).stream().mapToInt(res -> {
            int n;
            InputStreamReader stream = new InputStreamReader(res.method_14482());
            try {
                consumer.accept(stream);
                n = 1;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    PresenceFootsteps.logger.error("Error encountered loading resource " + String.valueOf(id) + " from pack" + res.method_14480(), (Throwable)e);
                    return 0;
                }
            }
            ((Reader)stream).close();
            return n;
        }).sum() > 0;
    }

    public static <T> Stream<T> load(class_2960 id, class_3300 manager, Function<JsonObject, T> reader) {
        return ResourceUtils.load(id, manager.method_14489(id).stream(), reader);
    }

    public static <T> Stream<T> load(class_2960 id, Stream<class_3298> resources, Function<JsonObject, T> reader) {
        return resources.map(res -> {
            Object r;
            JsonReader stream = new JsonReader((Reader)new InputStreamReader(res.method_14482()));
            try {
                r = reader.apply(Streams.parse((JsonReader)stream).getAsJsonObject());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    PresenceFootsteps.logger.error("Error encountered loading resource " + String.valueOf(id) + " from pack" + res.method_14480(), (Throwable)e);
                    return null;
                }
            }
            stream.close();
            return r;
        }).filter(Objects::nonNull);
    }

    public static <T> Map<class_2960, T> loadAll(class_2960 directory, class_3300 manager, Codec<T> codec) {
        HashMap results = new HashMap();
        class_4309.method_51148((class_3300)manager, (class_7654)class_7654.method_45114((String)directory.method_12832()), (DynamicOps)JsonOps.INSTANCE, codec, results);
        return results;
    }

    public static <T, K, V> Map<K, V> loadDir(class_7654 finder, class_3300 manager, Function<JsonObject, T> reader, Function<class_2960, @Nullable K> keyMapper, Function<Stream<T>, @Nullable V> valueMapper) {
        return Map.ofEntries((Map.Entry[])finder.method_45116(manager).entrySet().stream().map(entry -> {
            Object k = keyMapper.apply((class_2960)entry.getKey());
            if (k == null) {
                return null;
            }
            Object v = valueMapper.apply(ResourceUtils.load((class_2960)entry.getKey(), ((List)entry.getValue()).stream(), reader));
            return v == null ? null : Map.entry(k, v);
        }).filter(Objects::nonNull).toArray(Map.Entry[]::new));
    }
}

