/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import com.google.gson.GsonBuilder;
import com.minelittlepony.common.util.settings.Config;
import com.minelittlepony.common.util.settings.HeirarchicalJsonConfigAdapter;
import com.minelittlepony.common.util.settings.Setting;
import com.minelittlepony.common.util.settings.ToStringAdapter;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.config.EntitySelector;
import eu.ha3.presencefootsteps.config.VolumeOption;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_129;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7923;

public class PFConfig
extends Config {
    private final Setting<Boolean> disabled = this.value("client", "disabled", false).addComment("Disables all functionality of the mod");
    private final Setting<Integer> volume = this.value("volume", "volume", 70).addComment("Sets the global footsteps volume on a value between 0% and 100%").addComment("Default: 70");
    public final Setting<Integer> runningVolumeIncrease = this.value("volume", "runningVolumeIncrease", 0).addComment("Controls how much the footsteps sound changes when running on a percentage range between -100% to +100%").addComment("Default: 0");
    public VolumeOption clientPlayerVolume = new VolumeOption(this, (Setting<Integer>)this.value("volume", "clientPlayerVolume", 100).addComment("Sets the volume of your own footsteps on a value between 0% and 100%").addComment("Default: 100"));
    public VolumeOption otherPlayerVolume = new VolumeOption(this, (Setting<Integer>)this.value("volume", "otherPlayerVolume", 100).addComment("Sets the volume of other players' footsteps on a value between 0% and 100%").addComment("Default: 100"));
    public VolumeOption hostileEntitiesVolume = new VolumeOption(this, (Setting<Integer>)this.value("volume", "hostileEntitiesVolume", 100).addComment("Sets the volume of hostile mob's footsteps on a value between 0% and 100%").addComment("Default: 100"));
    public VolumeOption passiveEntitiesVolume = new VolumeOption(this, (Setting<Integer>)this.value("volume", "passiveEntitiesVolume", 100).addComment("Sets the volume of passive and friendly mob's footsteps on a value between 0% and 100%").addComment("Default: 100"));
    public VolumeOption wetSoundsVolume = new VolumeOption(this, (Setting<Integer>)this.value("volume", "wetSoundsVolume", 50).addComment("Sets the volume of sounds generated by walking on wet surfaces during rain or thunderstorms").addComment("Default: 50"));
    public VolumeOption foliageSoundsVolume = new VolumeOption(this, (Setting<Integer>)this.value("volume", "foliageSoundsVolume", 100).addComment("Sets the volume of sounds generated due to walking through foliage and brush").addComment("Default: 50"));
    private final Setting<Integer> maxSteppingEntities = this.value("performance", "maxSteppingEntities", 50).addComment("Controls the maximum number of entities the mod can generate footsteps for in a single frame").addComment("Default: 50");
    private final Setting<Boolean> multiplayer = this.value("sound", "multiplayer", true).addComment("Sets whether footsteps should be generated for other players when in multiplayer");
    private final Setting<Boolean> global = this.value("sound", "global", true).addComment("Sets whether footsteps should be generated for other (non-player) mobs");
    private final Setting<Boolean> footwear = this.value("sound", "footwear", true).addComment("When enabled, special footstep sounds will be generated matching the boots you are wearing.").addComment("Note not all types of boots are supported. Modded boots may sound strange or not work.");
    private final Setting<Boolean> visualiser = this.value("debug", "visualiser", false).addComment("Enables a visualiser to show where sound/material checks are occuring");
    private final Setting<Boolean> exclusive = this.value("sound", "exclusive", false).addComment("Sets whether to block vanilla footstep sounds when generating sounds for other entities or players");
    private final Setting<Locomotion> stance = this.value("client", "stance", (Object)Locomotion.NONE).addComment("Sets the player's own stance (type of footsteps to generate").addComment("Options:").addComment("  NONE (determined by whether Mine Little Pony is installed)").addComment("  BIPED (always two-legged)").addComment("  QUADRUPED (always four-legged)").addComment("  FLYING (always four-legged + wings)").addComment("  FLYING_BIPED (always two-legged + wings)").addComment("Default: NONE");
    private final Setting<EntitySelector> targetEntities = this.value("client", "targetEntities", EntitySelector.ALL).addComment("Controls which group of entities to generate footsteps for").addComment("Options: ALL, PLAYERS_AND_HOSTILES, PLAYERS_ONLY").addComment("Default: ALL");
    public final Setting<Set<class_2960>> ignoredEntityTypes = this.value("compatibility", "ignoredEntityTypes", () -> new HashSet<class_2960>(Set.of(class_2960.method_60656((String)"ghast"), class_2960.method_60656((String)"happy_ghast"), class_2960.method_60656((String)"phantom"))), class_2960.class).addComment("A list of entity type for any types of mobs that should never produce footsteps. Usually should be any flying 'bird' mobs.").addComment("Default: minecraft:ghast, minecraft:happy_ghast, minecraft:phantom");
    private final transient PresenceFootsteps pf;

    public PFConfig(Path file, PresenceFootsteps pf) {
        super((Config.Adapter)new HeirarchicalJsonConfigAdapter(new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new ToStringAdapter(class_2960::toString, class_2960::method_60654))), file);
        this.pf = pf;
    }

    public boolean toggleMultiplayer() {
        this.multiplayer.set((Object)((Boolean)this.multiplayer.get() == false ? 1 : 0));
        this.save();
        return (Boolean)this.multiplayer.get();
    }

    public boolean isIgnoredForFootsteps(class_1299<?> type) {
        return ((Set)this.ignoredEntityTypes.get()).contains(class_7923.field_41177.method_10221(type));
    }

    public EntitySelector cycleTargetSelector() {
        this.targetEntities.set((Object)EntitySelector.VALUES[(this.getEntitySelector().ordinal() + 1) % EntitySelector.VALUES.length]);
        this.save();
        return (EntitySelector)this.targetEntities.get();
    }

    public Locomotion setLocomotion(Locomotion loco) {
        if (loco != this.getLocomotion()) {
            this.stance.set((Object)loco);
            this.save();
            this.pf.getEngine().reload();
        }
        return loco;
    }

    public boolean isVisualiserRunning() {
        return (Boolean)this.visualiser.get();
    }

    public Locomotion getLocomotion() {
        return this.stance.get() == null ? Locomotion.NONE : (Locomotion)((Object)this.stance.get());
    }

    public EntitySelector getEntitySelector() {
        return this.targetEntities.get() == null ? EntitySelector.ALL : (EntitySelector)this.targetEntities.get();
    }

    public boolean getEnabledFootwear() {
        return (Boolean)this.footwear.get();
    }

    public boolean toggleFootwear() {
        this.footwear.set((Object)((Boolean)this.footwear.get() == false ? 1 : 0));
        this.save();
        return (Boolean)this.footwear.get();
    }

    public boolean isExclusiveMode() {
        return (Boolean)this.exclusive.get();
    }

    public boolean toggleExclusiveMode() {
        this.exclusive.set((Object)((Boolean)this.exclusive.get() == false ? 1 : 0));
        this.save();
        return (Boolean)this.exclusive.get();
    }

    public boolean getEnabledMP() {
        return (Boolean)this.multiplayer.get();
    }

    public int getMaxSteppingEntities() {
        return Math.max(1, (Integer)this.maxSteppingEntities.get());
    }

    public boolean toggleDisabled() {
        this.disabled.set((Object)((Boolean)this.disabled.get() == false ? 1 : 0));
        this.save();
        this.pf.onEnabledStateChange((Boolean)this.disabled.get() == false);
        return (Boolean)this.disabled.get();
    }

    public boolean setDisabled(boolean disabled) {
        if (disabled != (Boolean)this.disabled.get()) {
            this.toggleDisabled();
        }
        return disabled;
    }

    public boolean getDisabled() {
        return (Boolean)this.disabled.get();
    }

    public boolean getEnabled() {
        return (Boolean)this.disabled.get() == false && this.getGlobalVolume() > 0;
    }

    public int getGlobalVolume() {
        return class_3532.method_15340((int)((Integer)this.volume.get()), (int)0, (int)100);
    }

    public int getRunningVolumeIncrease() {
        return class_3532.method_15340((int)((Integer)this.runningVolumeIncrease.get()), (int)-100, (int)100);
    }

    public float setGlobalVolume(float volume) {
        int vvolume = PFConfig.volumeScaleToInt(volume);
        if ((Integer)this.volume.get() != vvolume) {
            boolean wasEnabled = this.getEnabled();
            this.volume.set((Object)vvolume);
            this.save();
            if (this.getEnabled() != wasEnabled) {
                this.pf.onEnabledStateChange(this.getEnabled());
            }
        }
        return this.getGlobalVolume();
    }

    public float setRunningVolumeIncrease(float volume) {
        this.runningVolumeIncrease.set((Object)(volume > 97.0f ? 100 : (volume < -97.0f ? -100 : (int)volume)));
        this.save();
        return this.getRunningVolumeIncrease();
    }

    public void populateCrashReport(class_129 section) {
        section.method_578("Disabled", (Object)this.getDisabled());
        section.method_578("Global Volume", this.volume.get());
        section.method_578("User's Selected Stance", (Object)this.getLocomotion());
        section.method_578("Target Selector", (Object)this.getEntitySelector());
        section.method_578("Enabled Global", this.global.get());
        section.method_578("Enabled Multiplayer", this.multiplayer.get());
    }

    private static int volumeScaleToInt(float volume) {
        return volume > 97.0f ? 100 : (volume < 3.0f ? 0 : (int)volume);
    }
}

