/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancientforgemastery.network;

import java.util.function.Supplier;
import net.mcreator.ancientforgemastery.AncientForgemasteryMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AncientForgemasteryModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        AncientForgemasteryMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Material_1 = message.data.Material_1;
                    variables.Material_2 = message.data.Material_2;
                    variables.RC_ON = message.data.RC_ON;
                    variables.SOV_ON = message.data.SOV_ON;
                    variables.EW_DURATION = message.data.EW_DURATION;
                    variables.Player_Team = message.data.Player_Team;
                    variables.EW_Wardling_Count = message.data.EW_Wardling_Count;
                    variables.RC_COOLDOWN = message.data.RC_COOLDOWN;
                    variables.EW_COOLDOWN = message.data.EW_COOLDOWN;
                    variables.EW_Shielding = message.data.EW_Shielding;
                    variables.EW_ON_WARDLET = message.data.EW_ON_WARDLET;
                    variables.EW_ON_WARDLING = message.data.EW_ON_WARDLING;
                    variables.PLAYER_TEAM = message.data.PLAYER_TEAM;
                    variables.GG_Holder = message.data.GG_Holder;
                    variables.WL_Shielding = message.data.WL_Shielding;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Material_1 = 0.0;
        public double Material_2 = 0.0;
        public boolean RC_ON = false;
        public boolean SOV_ON = true;
        public double EW_DURATION = 0.0;
        public String Player_Team = "\"\"";
        public double EW_Wardling_Count = 0.0;
        public double RC_COOLDOWN = 0.0;
        public double EW_COOLDOWN = 0.0;
        public boolean EW_Shielding = false;
        public boolean EW_ON_WARDLET = false;
        public boolean EW_ON_WARDLING = false;
        public String PLAYER_TEAM = "\"\"";
        public boolean GG_Holder = false;
        public boolean WL_Shielding = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                AncientForgemasteryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Material_1", this.Material_1);
            nbt.m_128347_("Material_2", this.Material_2);
            nbt.m_128379_("RC_ON", this.RC_ON);
            nbt.m_128379_("SOV_ON", this.SOV_ON);
            nbt.m_128347_("EW_DURATION", this.EW_DURATION);
            nbt.m_128359_("Player_Team", this.Player_Team);
            nbt.m_128347_("EW_Wardling_Count", this.EW_Wardling_Count);
            nbt.m_128347_("RC_COOLDOWN", this.RC_COOLDOWN);
            nbt.m_128347_("EW_COOLDOWN", this.EW_COOLDOWN);
            nbt.m_128379_("EW_Shielding", this.EW_Shielding);
            nbt.m_128379_("EW_ON_WARDLET", this.EW_ON_WARDLET);
            nbt.m_128379_("EW_ON_WARDLING", this.EW_ON_WARDLING);
            nbt.m_128359_("PLAYER_TEAM", this.PLAYER_TEAM);
            nbt.m_128379_("GG_Holder", this.GG_Holder);
            nbt.m_128379_("WL_Shielding", this.WL_Shielding);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Material_1 = nbt.m_128459_("Material_1");
            this.Material_2 = nbt.m_128459_("Material_2");
            this.RC_ON = nbt.m_128471_("RC_ON");
            this.SOV_ON = nbt.m_128471_("SOV_ON");
            this.EW_DURATION = nbt.m_128459_("EW_DURATION");
            this.Player_Team = nbt.m_128461_("Player_Team");
            this.EW_Wardling_Count = nbt.m_128459_("EW_Wardling_Count");
            this.RC_COOLDOWN = nbt.m_128459_("RC_COOLDOWN");
            this.EW_COOLDOWN = nbt.m_128459_("EW_COOLDOWN");
            this.EW_Shielding = nbt.m_128471_("EW_Shielding");
            this.EW_ON_WARDLET = nbt.m_128471_("EW_ON_WARDLET");
            this.EW_ON_WARDLING = nbt.m_128471_("EW_ON_WARDLING");
            this.PLAYER_TEAM = nbt.m_128461_("PLAYER_TEAM");
            this.GG_Holder = nbt.m_128471_("GG_Holder");
            this.WL_Shielding = nbt.m_128471_("WL_Shielding");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("ancient_forgemastery", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Material_1 = original.Material_1;
            clone.Material_2 = original.Material_2;
            clone.EW_DURATION = original.EW_DURATION;
            clone.EW_Shielding = original.EW_Shielding;
            clone.PLAYER_TEAM = original.PLAYER_TEAM;
            clone.WL_Shielding = original.WL_Shielding;
            if (!event.isWasDeath()) {
                clone.RC_ON = original.RC_ON;
                clone.SOV_ON = original.SOV_ON;
                clone.Player_Team = original.Player_Team;
                clone.EW_Wardling_Count = original.EW_Wardling_Count;
                clone.RC_COOLDOWN = original.RC_COOLDOWN;
                clone.EW_COOLDOWN = original.EW_COOLDOWN;
                clone.EW_ON_WARDLET = original.EW_ON_WARDLET;
                clone.EW_ON_WARDLING = original.EW_ON_WARDLING;
                clone.GG_Holder = original.GG_Holder;
            }
        }
    }
}

