/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancientforgemastery;

import java.util.UUID;
import net.mcreator.ancientforgemastery.entity.WardletEntity;
import net.mcreator.ancientforgemastery.init.AncientForgemasteryModItems;
import net.mcreator.ancientforgemastery.network.AncientForgemasteryModVariables;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ancient_forgemastery", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EWUnequip {
    private static final UUID EW_UUID = UUID.fromString("f59a2dcf-8fa6-4dda-ba42-cd49e7ba06d7");
    private static final String SUPPRESS_KEY = "af:suppressWardOffhandEquipSound";

    private static void setSuppressIfHoldingWard(Player p) {
        if (p.m_21206_().m_41720_() == AncientForgemasteryModItems.ECHOING_WARD.get()) {
            p.getPersistentData().m_128379_(SUPPRESS_KEY, true);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        EWUnequip.setSuppressIfHoldingWard(e.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        EWUnequip.setSuppressIfHoldingWard(e.getEntity());
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EquipmentSlot slot = event.getSlot();
        ItemStack oldStack = event.getFrom();
        ItemStack newStack = event.getTo();
        if (slot == EquipmentSlot.OFFHAND) {
            AttributeModifier mod;
            AttributeInstance armorAttr;
            boolean isNowHolding;
            boolean wasNotHolding = oldStack.m_41720_() != AncientForgemasteryModItems.ECHOING_WARD.get();
            boolean bl = isNowHolding = newStack.m_41720_() == AncientForgemasteryModItems.ECHOING_WARD.get();
            if (wasNotHolding && isNowHolding) {
                boolean suppress = player.getPersistentData().m_128471_(SUPPRESS_KEY);
                if (suppress) {
                    player.getPersistentData().m_128473_(SUPPRESS_KEY);
                } else {
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11677_, SoundSource.PLAYERS, 1.0f, 1.5f);
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12404_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            if (oldStack.m_41720_() == AncientForgemasteryModItems.ECHOING_WARD.get() && newStack.m_41720_() != AncientForgemasteryModItems.ECHOING_WARD.get() && (armorAttr = player.m_21051_(Attributes.f_22284_)) != null && (mod = armorAttr.m_22111_(EW_UUID)) != null) {
                armorAttr.m_22130_(mod);
            }
        } else if (slot == EquipmentSlot.MAINHAND) {
            boolean newHasActiveTag;
            boolean hadWardlets = ((AncientForgemasteryModVariables.PlayerVariables)player.getCapability(AncientForgemasteryModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new AncientForgemasteryModVariables.PlayerVariables())).EW_ON_WARDLET;
            if (!hadWardlets) {
                return;
            }
            boolean bl = newHasActiveTag = newStack.m_41720_() == AncientForgemasteryModItems.ECHOING_WARD.get() && newStack.m_41782_() && newStack.m_41783_().m_128471_("af:ew_on");
            if (newHasActiveTag) {
                return;
            }
            Level world = player.m_9236_();
            if (!world.m_5776_() && world instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)world;
                String playerId = player.m_20149_();
                AABB box = player.m_20191_().m_82400_(64.0);
                world.m_6443_(WardletEntity.class, box, w -> playerId.equals(w.getPersistentData().m_128461_("af:wardian"))).forEach(ward -> {
                    CommandSourceStack src = new CommandSourceStack(CommandSource.f_80164_, ward.m_20182_(), ward.m_20155_(), server, 4, ward.m_7755_().getString(), ward.m_5446_(), server.m_7654_(), (Entity)ward);
                    server.m_7654_().m_129892_().m_230957_(src, "particle dust_color_transition 0.16 0.87 0.92 1 0.01 0.25 0.31 ~ ~0.3 ~ 0.3 0.2 0.3 0.5 20");
                    server.m_5594_(null, BlockPos.m_274561_((double)ward.m_20185_(), (double)ward.m_20186_(), (double)ward.m_20189_()), SoundEvents.f_12404_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ward.m_146870_();
                    if (ward instanceof LivingEntity) {
                        WardletEntity le = ward;
                        le.m_21153_(0.0f);
                    }
                    player.getCapability(AncientForgemasteryModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(cap -> {
                        cap.EW_ON_WARDLET = false;
                        cap.syncPlayerVariables((Entity)player);
                    });
                    int cd = Math.toIntExact(Math.round(((AncientForgemasteryModVariables.PlayerVariables)player.getCapability(AncientForgemasteryModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new AncientForgemasteryModVariables.PlayerVariables())).EW_COOLDOWN));
                    player.m_36335_().m_41524_((Item)AncientForgemasteryModItems.ECHOING_WARD.get(), cd);
                    server.m_5594_(null, player.m_20183_(), SoundEvents.f_215774_, SoundSource.PLAYERS, 1.0f, 1.0f);
                });
            }
        }
    }
}

