/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancientforgemastery;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="ancient_forgemastery", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class WolfFurDrop {
    private static final int THROTTLE_TICKS = 10;
    private static final float DROP_CHANCE = 1.0f;
    private static final int RECENTLY_WET_LEN = 100;
    private static final int PENDING_DELAY_MIN = 20;
    private static final int PENDING_WINDOW_SPAN = 10;
    private static final int COOLDOWN_MIN = 6000;
    private static final int COOLDOWN_MAX = 12000;
    private static final String TAG_RECENTLY_WET = "af_recentlyWetTicks";
    private static final String TAG_WET_CYCLE_USED = "af_wetCycleUsed";
    private static final String TAG_NEXT_ALLOWED_TIME = "af_nextShakeAllowedGameTime";
    private static final String TAG_PENDING_START_TIME = "af_pendingWindowStartGameTime";
    private static final String TAG_PENDING_END_TIME = "af_pendingWindowEndGameTime";
    private static final ResourceLocation DROP_ITEM_ID = new ResourceLocation("ancient_forgemastery", "wolf_fur");

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent e) {
        boolean shouldArm;
        long nextAllowed;
        LivingEntity ent = e.getEntity();
        if (!(ent instanceof Wolf)) {
            return;
        }
        Wolf wolf = (Wolf)ent;
        Level level = ent.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (wolf.f_19797_ % 10 != 0) {
            return;
        }
        if (!wolf.m_6084_() || wolf.m_213877_()) {
            return;
        }
        if (wolf.m_6162_()) {
            return;
        }
        CompoundTag data = wolf.getPersistentData();
        long now = level2.m_46467_();
        boolean cooldownReady = now >= (nextAllowed = data.m_128454_(TAG_NEXT_ALLOWED_TIME));
        boolean inWaterRainBubble = wolf.m_20071_();
        BlockPos headPos = BlockPos.m_274561_((double)wolf.m_20185_(), (double)wolf.m_20188_(), (double)wolf.m_20189_());
        boolean rainingAtHead = level2.m_46758_(headPos);
        boolean onGround = wolf.m_20096_();
        int recentlyWet = data.m_128451_(TAG_RECENTLY_WET);
        boolean wetCycleUsed = data.m_128471_(TAG_WET_CYCLE_USED);
        if (inWaterRainBubble) {
            recentlyWet = 100;
            wetCycleUsed = false;
            data.m_128356_(TAG_PENDING_START_TIME, 0L);
            data.m_128356_(TAG_PENDING_END_TIME, 0L);
        } else if (recentlyWet > 0) {
            recentlyWet = Math.max(0, recentlyWet - 10);
        }
        long pendingStart = data.m_128454_(TAG_PENDING_START_TIME);
        long pendingEnd = data.m_128454_(TAG_PENDING_END_TIME);
        boolean hasPending = pendingStart > 0L;
        boolean bl = shouldArm = !inWaterRainBubble && recentlyWet > 0 && !rainingAtHead && !wetCycleUsed && cooldownReady && onGround && !hasPending;
        if (shouldArm) {
            long start = now + 20L;
            long end = start + 10L;
            data.m_128356_(TAG_PENDING_START_TIME, start);
            data.m_128356_(TAG_PENDING_END_TIME, end);
            pendingStart = start;
            pendingEnd = end;
            hasPending = true;
        }
        if (hasPending) {
            if (inWaterRainBubble) {
                data.m_128356_(TAG_PENDING_START_TIME, 0L);
                data.m_128356_(TAG_PENDING_END_TIME, 0L);
            } else if (now > pendingEnd) {
                data.m_128356_(TAG_PENDING_START_TIME, 0L);
                data.m_128356_(TAG_PENDING_END_TIME, 0L);
            } else if (now >= pendingStart && now <= pendingEnd) {
                boolean confirmOk;
                boolean bl2 = confirmOk = !inWaterRainBubble && recentlyWet > 0 && !rainingAtHead && onGround && cooldownReady;
                if (confirmOk) {
                    Item item;
                    if (wolf.m_217043_().m_188501_() < 1.0f && (item = (Item)ForgeRegistries.ITEMS.getValue(DROP_ITEM_ID)) != null) {
                        ItemStack stack = new ItemStack((ItemLike)item, 1);
                        ItemEntity drop = new ItemEntity((Level)level2, wolf.m_20185_(), wolf.m_20186_() + 0.5, wolf.m_20189_(), stack);
                        drop.m_32060_();
                        level2.m_7967_((Entity)drop);
                    }
                    wetCycleUsed = true;
                    int range = 6000;
                    int cd = 6000 + (range > 0 ? wolf.m_217043_().m_188503_(range + 1) : 0);
                    data.m_128356_(TAG_NEXT_ALLOWED_TIME, now + (long)cd);
                    data.m_128356_(TAG_PENDING_START_TIME, 0L);
                    data.m_128356_(TAG_PENDING_END_TIME, 0L);
                }
            }
        }
        data.m_128405_(TAG_RECENTLY_WET, recentlyWet);
        data.m_128379_(TAG_WET_CYCLE_USED, wetCycleUsed);
    }
}

