/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancientforgemastery;

import java.util.EnumSet;
import net.mcreator.ancientforgemastery.init.AncientForgemasteryModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ancient_forgemastery")
public class HHSkeletonFlee {
    private static final float AVOID_RADIUS = 12.0f;
    private static final double WALK_SPEED = 1.0;
    private static final double SPRINT_SPEED = 1.35;

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof AbstractSkeleton)) {
            return;
        }
        AbstractSkeleton sk = (AbstractSkeleton)entity;
        AbstractSkeleton mob = sk;
        if (!HHSkeletonFlee.hasGoal(mob.f_21345_, FleeHelmetWearerGoal.class)) {
            mob.f_21345_.m_25352_(3, (Goal)new FleeHelmetWearerGoal((PathfinderMob)mob, 12.0f, 1.0, 1.35));
        }
    }

    private static boolean hasGoal(GoalSelector selector, Class<? extends Goal> type) {
        for (WrappedGoal w : selector.m_148105_()) {
            if (!type.isInstance(w.m_26015_())) continue;
            return true;
        }
        return false;
    }

    private static boolean isWearingHowlingHelmet(Player p) {
        ItemStack helm = (ItemStack)p.m_150109_().f_35975_.get(3);
        return !helm.m_41619_() && helm.m_41720_() == AncientForgemasteryModItems.HOWLING_HELMET.get();
    }

    public static class FleeHelmetWearerGoal
    extends Goal {
        private final PathfinderMob mob;
        private final float avoidRadius;
        private final double walkSpeed;
        private final double sprintSpeed;
        private Player toAvoid;
        private Path path;

        public FleeHelmetWearerGoal(PathfinderMob mob, float avoidRadius, double walkSpeed, double sprintSpeed) {
            this.mob = mob;
            this.avoidRadius = avoidRadius;
            this.walkSpeed = walkSpeed;
            this.sprintSpeed = sprintSpeed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Level level = this.mob.m_9236_();
            Player nearest = null;
            double best = Double.MAX_VALUE;
            for (Player p : level.m_45976_(Player.class, this.mob.m_20191_().m_82400_((double)this.avoidRadius))) {
                double d;
                if (!HHSkeletonFlee.isWearingHowlingHelmet(p) || !((d = this.mob.m_20280_((Entity)p)) < best)) continue;
                best = d;
                nearest = p;
            }
            if (nearest == null) {
                return false;
            }
            Vec3 away = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)nearest.m_20182_());
            if (away == null) {
                return false;
            }
            if (nearest.m_20238_(away) < nearest.m_20280_((Entity)this.mob)) {
                return false;
            }
            Path pth = this.mob.m_21573_().m_7864_(BlockPos.m_274446_((Position)away), 0);
            if (pth == null) {
                return false;
            }
            this.toAvoid = nearest;
            this.path = pth;
            return true;
        }

        public boolean m_8045_() {
            return this.toAvoid != null && this.toAvoid.m_6084_() && HHSkeletonFlee.isWearingHowlingHelmet(this.toAvoid) && !this.mob.m_21573_().m_26571_() && this.mob.m_20270_((Entity)this.toAvoid) < this.avoidRadius + 2.0f;
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.walkSpeed);
        }

        public void m_8041_() {
            this.toAvoid = null;
        }

        public void m_8037_() {
            if (this.toAvoid == null) {
                return;
            }
            if (this.mob.m_20270_((Entity)this.toAvoid) < this.avoidRadius * 0.65f) {
                this.mob.m_21573_().m_26517_(this.sprintSpeed);
            } else {
                this.mob.m_21573_().m_26517_(this.walkSpeed);
            }
        }

        public boolean m_6767_() {
            return true;
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

